/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.ui;

import com.tridium.fox.util.FoxRpcUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.point.BRdbmsPointQuery;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BRdbmsColumnNamePickerFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsColumnNamePickerFE.class);
    BTextDropDown field = new BTextDropDown("", 20, true);
    String[] columnNames;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRdbmsColumnNamePickerFE() {
        this.setContent((BWidget)this.field);
        this.linkTo("la", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lb", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.field.getList().removeAllItems();
        this.field.setText(value.toString());
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            int i;
            int columnCount;
            OrdTarget target = shell.getActiveOrdTarget();
            BComponent c = target.getComponent();
            while (!(c instanceof BRdbmsPointQuery)) {
                if (c == null) {
                    return;
                }
                c = c.getParent();
            }
            BRdbmsPointQuery query = (BRdbmsPointQuery)c;
            try {
                columnCount = ((BInteger)FoxRpcUtil.doRpc((BISpaceNode)query, (String)"getColumnCount", (Object[])new Object[0]).get()).getInt();
            }
            catch (Exception e) {
                Logger.getLogger("rdb").log(Level.WARNING, "Could not retrieve column count", e);
                return;
            }
            String[] columnNames = new String[columnCount];
            for (i = 0; i < columnCount; ++i) {
                try {
                    columnNames[i] = ((BString)FoxRpcUtil.doRpc((BISpaceNode)query, (String)"getColumnName", (Object[])new Object[]{BInteger.make((int)i)}).get()).getString();
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger("rdb").log(Level.WARNING, "Could not retrieve column name for column " + i, e);
                }
            }
            for (i = 0; i < columnNames.length; ++i) {
                if (columnNames[i] == null) continue;
                this.field.getList().addItem(null, (Object)columnNames[i]);
            }
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return BString.make((String)this.field.getText());
    }
}

