/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.BacnetEthernetAdapterQnx;
import com.tridium.platBacnet.EthernetFilter;
import java.security.AccessController;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetEthernetPlatformServiceQnx
extends BBacnetEthernetPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEthernetPlatformServiceQnx.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    @Override
    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading ether native library");
                System.loadLibrary("bacnet");
                log.fine("Loaded ether native library");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load ether native library", e);
            }
            return this.nativesLoaded;
        });
    }

    @Override
    public BacnetEthernetAdapter openAdapter(String adapterName, EthernetFilter etherType) {
        return new BacnetEthernetAdapterQnx(adapterName, etherType);
    }

    @Override
    protected void queryForAdapters(Vector<String> adapterTitles, Vector<String> adapterDescriptions, Vector<String> adapterNames) throws Exception {
        BacnetEthernetAdapterQnx.queryForAdapters(adapterTitles, adapterDescriptions, adapterNames);
    }
}

