/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.platBacnet.EthernetConst;
import com.tridium.platBacnet.EthernetFilter;
import com.tridium.platBacnet.EthernetListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Lexicon;

public abstract class BacnetEthernetAdapter
implements Runnable,
EthernetConst {
    private static final String E_BACNET_STACK_LINK_ETHERNET_DRIVER_OPEN_FAILED = "Ethernet driver failed to open";
    private static final String E_BACNET_STACK_LINK_ETHERNET_DRIVER_CLOSE_FAILED = "Ethernet driver failed to close";
    protected static final Logger log = Logger.getLogger("plat.ethernet");
    protected static final Lexicon lex = Lexicon.make((String)"platBacnet");
    private static final String NONE_ADAPTER_NAME = SlotPath.escape((String)lex.getText("ethernet.adapter.none"));
    static final int STOP_RECEPTION_LOOP = -2;
    static final int DEFAULT_RECEIVE_BUFFER_SIZE = 2048;
    static final int RECEPTION_PAUSE_MS = 5000;
    static final int TERMINATION_PAUSE_MS = 10000;
    private String adapterName;
    protected long deviceHandle = -1L;
    private boolean alive = false;
    private int threadsStarted = 0;
    private Thread receptionThread = null;
    protected long activeReceptionThreadID = 0L;
    private EthernetListener listener = null;
    protected EthernetFilter etherType = EthernetFilter.BACNET;

    public BacnetEthernetAdapter(String adapterName) {
        this.adapterName = adapterName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public void commStart() {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Communications starting on Ethernet adapter '" + this.adapterName + "'");
            }
            this.open();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Opened Ethernet device handle '" + this.deviceHandle + "'");
            }
            this.receptionThread = new Thread((Runnable)this, "EthRcv_" + this.adapterName + "_" + ++this.threadsStarted);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Created Ethernet packet reception thread '" + this.receptionThread.getName() + "'");
            }
            if (!this.receptionThread.isAlive()) {
                this.alive = false;
                this.receptionThread.start();
                this.activeReceptionThreadID = this.receptionThread.getId();
                int patience = 0;
                while (!this.alive && patience++ < 20) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.alive || !this.receptionThread.isAlive()) {
                    throw new Exception("Ethernet reception thread failed to start in timely fashion");
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Communications started on Ethernet adapter '" + this.adapterName + "'");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, E_BACNET_STACK_LINK_ETHERNET_DRIVER_OPEN_FAILED, e);
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void commStop() {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Communications stopping on Ethernet adapter '" + this.adapterName + "'");
            }
            this.stopReception();
            this.alive = false;
            if (this.receptionThread != null) {
                this.receptionThread.interrupt();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Stop requested for Ethernet packet reception thread '" + this.receptionThread.getName() + "'");
                }
            }
            this.close();
            log.fine("Closed Ethernet device handle");
            if (this.receptionThread != null) {
                log.fine("Waiting for the reception thread to terminate...");
                this.receptionThread.join(10000L);
                if (this.receptionThread.isAlive() && log.isLoggable(Level.FINE)) {
                    log.fine("Reception thread '" + this.receptionThread.getName() + "' (tid=" + this.receptionThread.getId() + ") did not terminate in a timely fashion after close, abandoning thread");
                }
                this.receptionThread = null;
                this.activeReceptionThreadID = 0L;
                log.fine("Reception thread terminated");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Communications stopped on Ethernet adapter '" + this.adapterName + "'");
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, E_BACNET_STACK_LINK_ETHERNET_DRIVER_CLOSE_FAILED, e);
        }
    }

    public void commCleanup() {
        this.receptionThread = null;
        this.activeReceptionThreadID = 0L;
        this.listener = null;
    }

    public void sendPacket(byte[] packet) throws Exception {
        this.send(packet, packet.length);
    }

    public boolean isNoneAdapter() {
        return this.getAdapterName() != null && this.getAdapterName().length() > 0 && this.getAdapterName().equalsIgnoreCase(NONE_ADAPTER_NAME);
    }

    public void addListener(EthernetListener listener) {
        this.listener = listener;
    }

    public void removeListener(EthernetListener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    @Override
    public void run() {
        if (this.deviceHandle == -1L) {
            log.severe("Ethernet packet reception thread can not run with closed device handle, stopping thread");
            return;
        }
        this.alive = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ethernet packet reception thread '" + Thread.currentThread().getName() + "' starting");
        }
        while (this.alive) {
            try {
                this.startReception();
                if (Thread.currentThread().getId() != this.activeReceptionThreadID) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Current reception thread '" + Thread.currentThread().getId() + "' is no longer active '" + this.activeReceptionThreadID + "', ignoring read result and stopping startReception loop on '" + this.getAdapterName() + "'");
                    }
                    return;
                }
                this.alive = false;
            }
            catch (IllegalStateException ise) {
                log.log(Level.SEVERE, "Fatal error in Ethernet packet reception, terminating reception loop", ise);
                this.alive = false;
                break;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error in Ethernet packet reception", e);
                if (this.deviceHandle == -1L) {
                    log.fine("Reception thread read handle is closed after Exception, terminating reception loop");
                    this.alive = false;
                    break;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Restarting reception in 5000 seconds...");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.stopReception();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error stopping Ethernet packet reception", e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ethernet packet reception thread '" + Thread.currentThread().getName() + "' stopping");
        }
    }

    public void receivePacket(byte[] packet) {
        this.receivePacket(packet, packet.length);
    }

    public void receivePacket(byte[] packet, int bytesReceived) {
        try {
            if (this.listener != null) {
                this.listener.receivePacket(packet, bytesReceived);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error in Ethernet packet reception thread (receivePacket)", e);
        }
    }

    protected static byte[] pad(byte[] packet) {
        byte[] padded = new byte[60];
        System.arraycopy(packet, 0, padded, 0, packet.length);
        return padded;
    }

    protected abstract void open() throws Exception;

    protected abstract void startReception() throws Exception;

    protected abstract void stopReception() throws Exception;

    protected abstract void send(byte[] var1, int var2) throws Exception;

    protected abstract void close() throws Exception;

    public abstract void getAddress(byte[] var1) throws Exception;
}

