/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.EthernetConst;
import com.tridium.platBacnet.EthernetFilter;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.io.BajaIOException;
import javax.baja.nre.util.ByteArrayUtil;

public class BacnetEthernetAdapterNpsdk
extends BacnetEthernetAdapter {
    private volatile boolean done = false;
    private volatile boolean closed = true;

    public BacnetEthernetAdapterNpsdk(String adapterName) {
        this(adapterName, EthernetFilter.BACNET);
    }

    public BacnetEthernetAdapterNpsdk(String adapterName, EthernetFilter etherType) {
        super(adapterName);
        if (etherType == null) {
            throw new IllegalArgumentException("EtherType must be specified");
        }
        this.etherType = etherType;
    }

    @Override
    protected void open() throws Exception {
        if (this.deviceHandle == -1L && !this.isNoneAdapter()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Opening Ethernet device '" + this.getAdapterName() + "'");
            }
            byte[] macAddress = new byte[6];
            this.getAddress(macAddress);
            String bpf = this.etherType.getBPF(macAddress, !ByteArrayUtil.equals((byte[])macAddress, (byte[])EthernetConst.UNINITIALIZED_MAC_ADDRESS));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Assigning Ethernet filter '" + bpf + "'");
            }
            this.deviceHandle = this.bacnetOpen0(this.getAdapterName(), 2048, bpf);
            if (this.deviceHandle == -1L) {
                throw new BajaIOException(lex.getText("cannotOpenAdapter") + this.getAdapterName());
            }
            this.closed = false;
        }
    }

    @Override
    protected void startReception() throws Exception {
        if (this.deviceHandle == -1L) {
            throw new IllegalStateException("Cannot start reception on '" + this.getAdapterName() + "', handle is closed");
        }
        this.done = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ethernet adapter startReception on '" + this.getAdapterName() + "'");
        }
        byte[] packet = new byte[2048];
        while (!this.done) {
            int bytesRead = this.read(packet);
            if (Thread.currentThread().getId() != this.activeReceptionThreadID) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Current reception thread '" + Thread.currentThread().getId() + "' is no longer active '" + this.activeReceptionThreadID + "', ignoring read result and stopping startReception loop on '" + this.getAdapterName() + "'");
                }
                return;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Read returned " + bytesRead + " bytes");
            }
            if (this.done || bytesRead == -2 || this.deviceHandle == -1L) {
                log.fine("Stopping startReception loop on '" + this.getAdapterName() + "'");
                return;
            }
            if (bytesRead < 60) {
                log.warning("Ethernet adapter '" + this.getAdapterName() + " read returned irregular sized packet with length = " + bytesRead + ", ignoring");
                throw new Exception("Irregular Ethernet packet, size = " + bytesRead);
            }
            int len = (packet[12] & 0xFF) << 8 | packet[13] & 0xFF;
            if (len <= 1500) {
                bytesRead = len + 14;
            }
            byte[] truncatedPacket = new byte[bytesRead];
            System.arraycopy(packet, 0, truncatedPacket, 0, bytesRead);
            this.receivePacket(truncatedPacket, bytesRead);
        }
    }

    protected int read(byte[] packet) throws Exception {
        if (this.deviceHandle != -1L) {
            return this.bacnetRead0(this.deviceHandle, packet);
        }
        return -1;
    }

    @Override
    protected void stopReception() throws Exception {
        if (!this.done && !this.closed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Ethernet adapter stopReception on '" + this.getAdapterName() + "'");
            }
            this.done = true;
            this.close();
        }
    }

    @Override
    protected void send(byte[] packet, int numBytes) throws Exception {
        if (this.deviceHandle != -1L && !this.done) {
            if (packet.length < 60) {
                packet = BacnetEthernetAdapterNpsdk.pad(packet);
                numBytes = 60;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("preparing frame as type '" + (Object)((Object)this.etherType) + "'");
            }
            this.etherType.prepareFrame(packet);
            if (log.isLoggable(Level.FINE)) {
                log.fine("sending: " + packet.length + " bytes");
            }
            this.bacnetWrite0(this.deviceHandle, packet, numBytes);
        }
    }

    @Override
    protected void close() throws Exception {
        if (this.deviceHandle != -1L && !this.closed) {
            this.closed = true;
            this.bacnetClose0(this.deviceHandle);
            this.deviceHandle = -1L;
        }
    }

    @Override
    public void getAddress(byte[] macAddress) throws Exception {
        if (macAddress == null) {
            throw new IllegalArgumentException();
        }
        this.getAddress0(this.getAdapterName(), macAddress);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getAddress('" + this.getAdapterName() + "') macAddress = " + ByteArrayUtil.toHexString((byte[])macAddress));
        }
    }

    public static void queryForAdapters(Vector<String> adapterTitles, Vector<String> adapterDescriptions, Vector<String> adapterNames) throws Exception {
        BacnetEthernetAdapterNpsdk.queryForAdapters0(adapterTitles, adapterDescriptions, adapterNames);
    }

    native long bacnetOpen0(String var1, int var2, String var3) throws Exception;

    native void bacnetClose0(long var1) throws Exception;

    native int bacnetRead0(long var1, byte[] var3) throws Exception;

    native void bacnetWrite0(long var1, byte[] var3, int var4) throws Exception;

    native void getAddress0(String var1, byte[] var2) throws Exception;

    static native void queryForAdapters0(Vector<String> var0, Vector<String> var1, Vector<String> var2) throws Exception;
}

