/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractMemoryMonitor;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="classesLoaded", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BLong.make(-1))")})
public final class BLoadedClassesMonitor
extends BAbstractMemoryMonitor {
    @Generated
    public static final Property classesLoaded = BLoadedClassesMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L)));
    @Generated
    public static final Type TYPE = Sys.loadType(BLoadedClassesMonitor.class);

    @Generated
    public long getClassesLoaded() {
        return this.getLong(classesLoaded);
    }

    @Generated
    public void setClassesLoaded(long v) {
        this.setLong(classesLoaded, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "loadedClasses";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:loadedClassesToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:loadedClassesToOffnormal)%";
    }

    @Override
    protected long checkMemory() {
        long loadedClasses = 0L;
        try {
            ClassLoadingMXBean classLoadingBean = ManagementFactory.getClassLoadingMXBean();
            loadedClasses = classLoadingBean.getLoadedClassCount();
            this.setClassesLoaded(loadedClasses);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Loaded classes: " + loadedClasses);
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking loaded classes memory", (Throwable)e);
        }
        return loadedClasses;
    }
}

