/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractAlarmMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="platformPort", type="int", defaultValue="-1", flags=3), @NiagaraProperty(name="rebootOnError", type="boolean", defaultValue="false", flags=4)})
public final class BPlatformMonitor
extends BAbstractAlarmMonitor {
    @Generated
    public static final Property platformPort = BPlatformMonitor.newProperty((int)3, (int)-1, null);
    @Generated
    public static final Property rebootOnError = BPlatformMonitor.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatformMonitor.class);

    @Generated
    public int getPlatformPort() {
        return this.getInt(platformPort);
    }

    @Generated
    public void setPlatformPort(int v) {
        this.setInt(platformPort, v, null);
    }

    @Generated
    public boolean getRebootOnError() {
        return this.getBoolean(rebootOnError);
    }

    @Generated
    public void setRebootOnError(boolean v) {
        this.setBoolean(rebootOnError, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doStarted() throws Exception {
        this.setPlatformPort(Integer.parseInt(BPlatformMonitor.getDaemonProperties().getProperty("port", "3011")));
    }

    private static Properties getDaemonProperties() {
        return AccessController.doPrivileged(new GetDaemonPropertiesPrivilegedAction());
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:platformToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:platformToOffnormal)%";
    }

    @Override
    public void doRunCheck() {
        this.checkPlatformRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPlatformRunning() {
        int port = this.getPlatformPort();
        if (port > -1) {
            boolean connectOk = false;
            Socket s = null;
            try {
                s = new Socket("127.0.0.1", port);
                connectOk = true;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!connectOk) {
                BFormat msg = BFormat.make((String)this.getToOffnormalText());
                this.getLog().warning(msg.format((Object)this));
                this.raiseAlarm(msg, true);
                if (this.getRebootOnError()) {
                    this.getLog().warning("Platform System Monitor Service could not detect platform. Attempting reboot!");
                    this.reboot();
                }
            } else {
                this.raiseAlarm(false);
            }
        } else {
            this.getLog().error("Could not find valid platform port");
        }
    }

    private static class GetDaemonPropertiesPrivilegedAction
    implements PrivilegedAction<Properties> {
        private GetDaemonPropertiesPrivilegedAction() {
        }

        @Override
        public Properties run() {
            Properties props;
            block14: {
                props = new Properties();
                try {
                    File propsFile = new File(Sys.getNiagaraUserHome() + File.separator + "daemon" + File.separator + "daemon.properties");
                    if (!propsFile.exists()) break block14;
                    try (FileInputStream inputStream = new FileInputStream(propsFile);){
                        props.load(inputStream);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return props;
        }
    }
}

