/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractMonitor;
import com.tridium.sysmon.BSysMonWorker;
import com.tridium.sysmon.BSystemRebootTimeTrigger;
import javax.baja.agent.BPxView;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="worker", type="BSysMonWorker", defaultValue="new BSysMonWorker()", flags=5), @NiagaraProperty(name="lastSystemCheckTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="systemCheckTimeTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.make(BRelTime.MINUTE.getMillis() * 15)))"), @NiagaraProperty(name="systemMonitorConfig", type="BPxView", defaultValue="new BPxView(BOrd.make(\"module://systemMonitor/px/systemMonitor.px\"))", flags=5), @NiagaraProperty(name="systemRebootTimeTrigger", type="BTimeTrigger", defaultValue="new BSystemRebootTimeTrigger(BManualTriggerMode.DEFAULT)", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="checkSystem", flags=16), @NiagaraAction(name="reboot", flags=16)})
public final class BSystemMonitorService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property worker = BSystemMonitorService.newProperty((int)5, (BValue)new BSysMonWorker(), null);
    @Generated
    public static final Property lastSystemCheckTime = BSystemMonitorService.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property systemCheckTimeTrigger = BSystemMonitorService.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.make((long)(BRelTime.MINUTE.getMillis() * 15L)))), null);
    @Generated
    public static final Property systemMonitorConfig = BSystemMonitorService.newProperty((int)5, (BValue)new BPxView(BOrd.make((String)"module://systemMonitor/px/systemMonitor.px")), null);
    @Generated
    public static final Property systemRebootTimeTrigger = BSystemMonitorService.newProperty((int)4, (BValue)new BSystemRebootTimeTrigger(BManualTriggerMode.DEFAULT), null);
    @Generated
    public static final Action checkSystem = BSystemMonitorService.newAction((int)16, null);
    @Generated
    public static final Action reboot = BSystemMonitorService.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemMonitorService.class);
    public static final Log log = Log.getLog((String)"systemMonitor");
    private static final BIcon icon = BIcon.std((String)"wrench.png");
    private static final String VERSION = "01.00.00.00";

    @Generated
    public BSysMonWorker getWorker() {
        return (BSysMonWorker)this.get(worker);
    }

    @Generated
    public void setWorker(BSysMonWorker v) {
        this.set(worker, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSystemCheckTime() {
        return (BAbsTime)this.get(lastSystemCheckTime);
    }

    @Generated
    public void setLastSystemCheckTime(BAbsTime v) {
        this.set(lastSystemCheckTime, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getSystemCheckTimeTrigger() {
        return (BTimeTrigger)this.get(systemCheckTimeTrigger);
    }

    @Generated
    public void setSystemCheckTimeTrigger(BTimeTrigger v) {
        this.set(systemCheckTimeTrigger, (BValue)v, null);
    }

    @Generated
    public BPxView getSystemMonitorConfig() {
        return (BPxView)this.get(systemMonitorConfig);
    }

    @Generated
    public void setSystemMonitorConfig(BPxView v) {
        this.set(systemMonitorConfig, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getSystemRebootTimeTrigger() {
        return (BTimeTrigger)this.get(systemRebootTimeTrigger);
    }

    @Generated
    public void setSystemRebootTimeTrigger(BTimeTrigger v) {
        this.set(systemRebootTimeTrigger, (BValue)v, null);
    }

    @Generated
    public void checkSystem() {
        this.invoke(checkSystem, null, null);
    }

    @Generated
    public void reboot() {
        this.invoke(reboot, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() {
        this.linkTo("systemCheckTriggerLink0", (BComponent)this.getSystemCheckTimeTrigger(), (Slot)BTimeTrigger.fireTrigger, (Slot)checkSystem);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void started() {
        if (log.isTraceOn()) {
            log.trace("*** Starting System Monitor Service - Version: 01.00.00.00 ***");
        }
        if (this.getSystemRebootTimeTrigger().getType().equals(BTimeTrigger.TYPE)) {
            BSystemRebootTimeTrigger trigger = new BSystemRebootTimeTrigger();
            trigger.copyFrom((BComplex)this.getSystemRebootTimeTrigger());
            this.setSystemRebootTimeTrigger(trigger);
        }
    }

    public void atSteadyState() {
        if (this.getEnabled()) {
            this.checkSystem();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    public BINavNode[] getNavChildren() {
        Array array = new Array(BINavNode.class);
        array.addAll((Object[])super.getNavChildren());
        array.remove((Object)this.getWorker());
        return (BINavNode[])array.trim();
    }

    public void doCheckSystem() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        this.setLastSystemCheckTime(BAbsTime.now());
        BAbstractMonitor[] monitors = (BAbstractMonitor[])this.getChildren(BAbstractMonitor.class);
        for (int i = 0; i < monitors.length; ++i) {
            monitors[i].runCheck();
        }
    }

    public void doReboot(Context cx) {
        log.warning("System Monitor Service attempted to reboot the Station. This action is disabled.");
    }
}

