/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BHistoryChannel
extends BBoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryChannel.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getChannelName() {
        return "history";
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "clearAllRecords": {
                this.clearAllRecords((JSONArray)body, out, op);
                return true;
            }
            case "clearOldRecords": {
                this.clearOldRecords((JSONObject)body, out, op);
                return true;
            }
            case "deleteHistories": {
                this.deleteHistories((JSONArray)body, out, op);
                return true;
            }
        }
        return false;
    }

    private void clearAllRecords(JSONArray ordArray, BoxWriter out, BoxOp op) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection((Context)op);){
            conn.clearAllRecords(this.decodeOrds(ordArray));
        }
        out.value(true);
    }

    private void clearOldRecords(JSONObject data, BoxWriter out, BoxOp op) throws IOException {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection((Context)op);){
            conn.clearOldRecords(this.decodeOrds(data.getJSONArray("ords")), (BAbsTime)BAbsTime.DEFAULT.decodeFromString(JSONUtil.getString((JSONObject)data, (String)"before")));
        }
        out.value(true);
    }

    private void deleteHistories(JSONArray ordArray, BoxWriter out, BoxOp op) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection((Context)op);){
            conn.deleteHistories(this.decodeOrds(ordArray));
        }
        out.value(true);
    }

    private BOrd[] decodeOrds(JSONArray ordArray) {
        BOrd[] ords = new BOrd[ordArray.length()];
        for (int i = 0; i < ordArray.length(); ++i) {
            ords[i] = BOrd.make((String)JSONUtil.getString((JSONArray)ordArray, (int)i));
        }
        return ords;
    }
}

