/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BServerSessionHandler;
import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryService;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="spaceOrd", type="BOrd", defaultValue="BOrd.DEFAULT")
public class BNavNodeSessionHandler
extends BServerSessionHandler
implements NavListener {
    @Generated
    public static final Property spaceOrd = BNavNodeSessionHandler.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNavNodeSessionHandler.class);
    private Context cx;
    private BINavNode targetNode;
    private static final BOrd[] supportedTargetNodes = new BOrd[]{BOrd.make((String)"history:"), BOrd.make((String)"module:"), BOrd.make((String)"file:^"), BOrd.make((String)"alarm:"), BOrd.make((String)"alarm:archive")};
    private static final Logger log = Logger.getLogger("box.spacenode");
    private final ArrayList<JSONObject> navEvents = new ArrayList();

    @Generated
    public BOrd getSpaceOrd() {
        return (BOrd)this.get(spaceOrd);
    }

    @Generated
    public void setSpaceOrd(BOrd v) {
        this.set(spaceOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object init(Object arg, BoxOp op) throws Exception {
        BOrd ord = BOrd.make((String)arg.toString());
        BOrd relativized = ord.relativizeToSession();
        boolean found = false;
        for (BOrd o : supportedTargetNodes) {
            if (!o.equals((Object)relativized)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Target Nav Node unsupported: " + ord);
        }
        this.targetNode = (BINavNode)ord.get(null, (Context)op);
        this.cx = new BasicContext(op.getUser(), op.getLanguage());
        if (this.targetNode instanceof BIProtected) {
            BNavNodeSessionHandler.checkReadPermissions((BIProtected)this.targetNode, (Context)op);
        }
        this.setSpaceOrd(ord);
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        return null;
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "navChildren": {
                BNavNodeSessionHandler.navChildren((String)body, this.targetNode, (JSONWriter)out, (Context)op);
                return true;
            }
        }
        return false;
    }

    private static void navChildren(String navOrdStr, BINavNode rootNode, JSONWriter out, Context cx) throws IOException {
        BINavNode node = (BINavNode)BOrd.make((String)navOrdStr).get((BObject)BLocalHost.INSTANCE, cx);
        if (!BNavNodeSessionHandler.isNavNodeSupported(node, rootNode, cx)) {
            throw new IOException("Nav Node isn't supported");
        }
        if (node instanceof BIProtected) {
            BNavNodeSessionHandler.checkReadPermissions((BIProtected)node, cx);
        }
        out.array();
        for (BINavNode navNode : BNavContainer.filter((BINavNode[])node.getNavChildren(), (Context)cx)) {
            if (!BNavNodeSessionHandler.isNavNodeSupported(navNode, rootNode, cx) || navNode instanceof BIProtected && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)navNode, cx)) continue;
            out.value((Object)BNavNodeSessionHandler.encodeNavNode(navNode, cx));
        }
        out.endArray();
    }

    private static JSONObject encodeNavNode(BINavNode node, Context cx) throws IOException {
        BOrd ord = node.getNavOrd().normalize();
        JSONObject obj = new JSONObject();
        obj.put("navName", (Object)node.getNavName());
        obj.put("displayName", (Object)node.getNavDisplayName(cx));
        obj.put("ord", (Object)ord.toString());
        obj.put("icon", (Object)node.getNavIcon().encodeToString());
        obj.put("typeSpec", (Object)node.getType().toString());
        if (cx != null) {
            BObject includeDescription = cx.getFacet("includeDescription");
            BObject includeCategorizableOrd = cx.getFacet("includeCategorizableOrd");
            if (includeDescription instanceof BBoolean && ((BBoolean)includeDescription).getBoolean()) {
                obj.put("description", (Object)node.getNavDescription(cx));
            }
            if (includeCategorizableOrd instanceof BBoolean && ((BBoolean)includeCategorizableOrd).getBoolean()) {
                obj.put("categorizableOrd", (Object)BCategoryService.getCategorizableOrd((BINavNode)node, (Context)cx));
            }
        }
        if (node instanceof BIProtected) {
            obj.put("permissions", (Object)((BIProtected)node).getPermissions(cx).encodeToString());
        }
        return obj;
    }

    public void stopped() {
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object detachEvents(BoxOp op) throws Exception {
        ArrayList<JSONObject> arrayList = this.navEvents;
        synchronized (arrayList) {
            if (this.navEvents.isEmpty()) {
                return null;
            }
            JSONArray navEventArray = new JSONArray();
            this.navEvents.forEach(arg_0 -> ((JSONArray)navEventArray).put(arg_0));
            this.navEvents.clear();
            return navEventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navEvent(NavEvent event) {
        String id;
        BOrd parentOrd = event.getParentOrd();
        BINavNode parent = event.getParent();
        if ((parentOrd == null || parentOrd.isNull()) && parent != null) {
            parentOrd = parent.getNavOrd();
        }
        if (parentOrd == null || parentOrd.isNull()) {
            return;
        }
        parentOrd = parentOrd.normalize();
        BOrd spaceOrd = this.getSpaceOrd();
        if (spaceOrd.isNull()) {
            return;
        }
        if (parent == null) {
            parent = (BINavNode)parentOrd.get((BObject)BLocalHost.INSTANCE, this.cx);
        }
        if (!BNavNodeSessionHandler.isNavNodeSupported(parent, this.targetNode, this.cx)) {
            return;
        }
        switch (event.getId()) {
            case 1: {
                id = "added";
                break;
            }
            case 2: {
                id = "removed";
                break;
            }
            case 3: {
                id = "renamed";
                break;
            }
            case 5: {
                id = "replaced";
                break;
            }
            case 4: {
                id = "reordered";
                break;
            }
            default: {
                id = null;
            }
        }
        if (id == null) {
            return;
        }
        if (parent instanceof BIProtected && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)parent, this.cx)) {
            return;
        }
        JSONObject obj = new JSONObject();
        obj.put("id", (Object)id);
        obj.put("ord", (Object)parentOrd.toString());
        if (event.getNewChildName() != null) {
            BINavNode child = parent.getNavChild(event.getNewChildName());
            if (child == null) {
                if (parent instanceof BLocalHistoryDatabase) {
                    this.handleLocalHistoryDatabaseNavEvent((BLocalHistoryDatabase)parent, event);
                }
                return;
            }
            if (child instanceof BIProtected && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)child, this.cx)) {
                return;
            }
            try {
                obj.put("newNode", (Object)BNavNodeSessionHandler.encodeNavNode(child, this.cx));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not encode Nav Node", e);
                return;
            }
        }
        if (event.getOldChildName() != null) {
            obj.put("oldName", (Object)event.getOldChildName());
        }
        ArrayList<JSONObject> arrayList = this.navEvents;
        synchronized (arrayList) {
            this.navEvents.add(obj);
        }
        this.getServerSession().newEvents(this);
        if (parent instanceof BLocalHistoryDatabase) {
            this.handleLocalHistoryDatabaseNavEvent((BLocalHistoryDatabase)parent, event);
        }
    }

    private void handleLocalHistoryDatabaseNavEvent(BLocalHistoryDatabase parent, NavEvent event) {
        BINavNode navNode;
        int id = event.getId();
        if ((id == 1 || id == 2) && (navNode = parent.getNavChild("history:///")) != null) {
            this.navEvent(NavEvent.make((NavEvent)event, (BINavNode)navNode));
        }
    }

    private static boolean isNavNodeSupported(BINavNode node, BINavNode rootNode, Context cx) {
        if (node instanceof BIFile && !BNavNodeSessionHandler.hasReadPermissions((BIProtected)((BIFile)node), cx)) {
            return false;
        }
        if (rootNode == null) {
            return true;
        }
        if (rootNode instanceof BModuleSpace && node instanceof BIDirectory) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            for (BINavNode n = node; n != null; n = n.getNavParent()) {
                if (n != rootNode && (!(n instanceof BZipSpace) || !((BZipSpace)n).isModule())) continue;
                return true;
            }
            return false;
        });
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getNavChildren(String ordString, String facetsEncoding, Context cx) throws IOException {
        StringWriter strWtr = new StringWriter();
        JSONWriter out = QuickJSONWriter.make((Appendable)strWtr);
        if (facetsEncoding != null && !facetsEncoding.isEmpty()) {
            cx = new BasicContext(cx, (BFacets)BFacets.DEFAULT.decodeFromString(facetsEncoding));
        }
        BNavNodeSessionHandler.navChildren(ordString, null, out, cx);
        return strWtr.toString();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONObject getNavNodeInfo(String ordString, String facetsEncoding, Context cx) throws IOException {
        BINavNode node = (BINavNode)BOrd.make((String)ordString).get((BObject)BLocalHost.INSTANCE, cx);
        if (!BNavNodeSessionHandler.isNavNodeSupported(node, null, cx)) {
            throw new IOException("Nav Node isn't supported");
        }
        if (node instanceof BIProtected) {
            BNavNodeSessionHandler.checkReadPermissions((BIProtected)node, cx);
        }
        if (facetsEncoding != null && !facetsEncoding.isEmpty()) {
            cx = new BasicContext(cx, (BFacets)BFacets.DEFAULT.decodeFromString(facetsEncoding));
        }
        return BNavNodeSessionHandler.encodeNavNode(node, cx);
    }
}

