/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.BServerSession;
import com.tridium.box.BoxOp;
import com.tridium.box.ServerSessionException;
import com.tridium.box.json.BoxWriter;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.util.EscUtil;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.web.WebOp;

@NiagaraType
public final class BServerSessionChannel
extends BBoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BServerSessionChannel.class);
    private final Map<String, BServerSession> sessionMap = new ConcurrentHashMap<String, BServerSession>();
    private static final String SERVER_SESSION_NAME_PREFIX = "serverSession";
    public static final String SERVER_SESSION_ID_KEY = "serverSessionId";
    private static final String INSECURE_CREATE_REQUEST = "Can only create server session over HTTP/HTTPS";
    private static final SecureRandom RAND = new SecureRandom();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getChannelName() {
        return "ssession";
    }

    @Override
    public boolean service(String key, Object body, BoxWriter out, BoxOp op) throws Exception {
        switch (key) {
            case "make": {
                this.makeServerSession(out, op);
                break;
            }
            case "del": {
                this.deleteServerSession((JSONObject)body, out, op);
                break;
            }
            case "pollchgs": {
                this.pollChanges((JSONObject)body, out, op);
                break;
            }
            case "makessc": {
                this.makeServerSessionHandler((JSONObject)body, out, op);
                break;
            }
            case "removessc": {
                this.removeServerSessionHandler((JSONObject)body, out, op);
                break;
            }
            case "callssc": {
                this.serverSessionHandlerCall((JSONObject)body, out, op);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning() && oldValue instanceof BServerSession) {
            String id = ((BServerSession)oldValue).getId();
            this.sessionMap.remove(id);
        }
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Server Session Channel");
        out.prop((Object)"Active server session count ", this.sessionMap.size());
        out.endProps();
        super.spy(out);
    }

    private void makeServerSession(BoxWriter out, BoxOp op) throws Exception {
        if (!BServerSessionChannel.isSecureCreateRequest(op)) {
            throw new IllegalStateException(INSECURE_CREATE_REQUEST);
        }
        BBoxService service = this.getBoxService();
        int sessionLimit = service.getSessionLimit();
        if (sessionLimit > -1 && service.getSessionCount() >= sessionLimit) {
            throw new SessionLimitException((Context)op, sessionLimit);
        }
        String sessionId = BServerSessionChannel.generateUniqueSessionIdName();
        BServerSession serverSession = new BServerSession(sessionId);
        this.add(null, (BValue)serverSession, 3);
        this.sessionMap.put(sessionId, serverSession);
        serverSession.init(op);
        op.put(SERVER_SESSION_ID_KEY, sessionId);
        if (service.hasListeners()) {
            service.notifyListeners((Context)op, BBoxRecordType.status, "Created Server Session: " + sessionId);
        }
        out.value(sessionId);
    }

    private void deleteServerSession(JSONObject body, BoxWriter out, BoxOp op) throws ServerSessionException {
        BServerSession session = this.getServerSession(body, op);
        BBoxService service = this.getBoxService();
        if (service.hasListeners()) {
            service.notifyListeners((Context)op, BBoxRecordType.status, "Removed Server Session: " + session.getName());
        }
        this.remove((BComplex)session);
        this.sessionMap.remove(session.getId());
        out.value(null);
    }

    private void pollChanges(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        this.getServerSession(body, op).pollChanges(out, op);
    }

    private void makeServerSessionHandler(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        this.getServerSession(body, op).makeServerSessionHandler(body, out, op);
    }

    private void removeServerSessionHandler(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        this.getServerSession(body, op).removeServerSessionHandler(body, op);
        out.value(null);
    }

    private void serverSessionHandlerCall(JSONObject body, BoxWriter out, BoxOp op) throws Exception {
        this.getServerSession(body, op).service(body, out, op);
    }

    BServerSession getServerSession(JSONObject boxObj, BoxOp op) throws ServerSessionException {
        String id;
        String string = id = null != boxObj && boxObj.has("id") ? JSONUtil.getString((JSONObject)boxObj, (String)"id") : (String)op.get(SERVER_SESSION_ID_KEY);
        if (id == null) {
            throw new ServerSessionException("Could not find server session Id");
        }
        return this.getServerSession(id, op);
    }

    BServerSession getServerSession(String serverSessionId, BoxOp op) throws ServerSessionException {
        if (serverSessionId == null) {
            throw new ServerSessionException("Could not find Server Session Id");
        }
        BServerSession serverSession = this.sessionMap.get(serverSessionId);
        if (serverSession == null) {
            throw new ServerSessionException("Could not find Server Session");
        }
        if (!serverSession.getUserName().equals(op.getUsername())) {
            throw new ServerSessionException("Security Exception: cannot access Server Session");
        }
        op.put(SERVER_SESSION_NAME_PREFIX, (Object)serverSession);
        return serverSession;
    }

    private static String generateUniqueSessionIdName() {
        byte[] sessionBytes = new byte[25];
        RAND.nextBytes(sessionBytes);
        String id = Base64.getEncoder().encodeToString(sessionBytes);
        return SERVER_SESSION_NAME_PREFIX + EscUtil.slot.escape(id);
    }

    private static boolean isSecureCreateRequest(BoxOp op) {
        String scheme;
        WebOp webOp = op.getWebOp();
        if (webOp == null) {
            return BoxOp.isWorkbench(op);
        }
        switch (scheme = webOp.getRequest().getScheme().toLowerCase()) {
            case "http": 
            case "https": {
                return true;
            }
        }
        return false;
    }

    static final class SessionLimitException
    extends BBoxService.BoxCommsFailed {
        private SessionLimitException(Context cx, int sessionLimit) {
            super(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("service.exceededSessionLimit", new Object[]{String.valueOf(sessionLimit)}));
        }

        @Override
        String getBsonErrorType() {
            return "BoxSessionLimitError";
        }
    }
}

