/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.box.typenode.CommonTypes;
import com.tridium.box.typenode.TypeNode;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.json.JSONWriter;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import java.io.IOException;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public final class ContractEncoderVisitor
extends TypeNodeVisitor {
    private BoxWriter writer;
    private Context cx;

    public ContractEncoderVisitor(BoxWriter writer, Context cx) {
        this.writer = writer;
        this.cx = cx;
    }

    @Override
    public boolean doVisit(TypeNode node) throws IOException {
        boolean encodeValue;
        String typeSpec = node.toString();
        this.writer.key(typeSpec);
        boolean bl = encodeValue = !CommonTypes.isCommonType(typeSpec);
        if (encodeValue) {
            this.encode(node, this.writer);
        } else {
            this.writer.array().endArray();
        }
        return encodeValue;
    }

    private void encodeComplex(ComplexType compt, BoxWriter out) throws IOException {
        NSlot[] slots = compt.getFrozenSlots();
        if (slots != null) {
            for (NSlot s : compt.getFrozenSlots()) {
                BsonEncoderPlugin.DisplayEncoder encoder;
                BFacets facets;
                String slotType;
                if (!s.getDeclaringType().equals(compt)) continue;
                if (s.isProperty()) {
                    slotType = "p";
                } else if (s.isAction()) {
                    slotType = "a";
                } else if (s.isTopic()) {
                    slotType = "t";
                } else {
                    throw new IllegalStateException();
                }
                out.object();
                out.key("st").value((Object)slotType);
                out.key("n").value((Object)s.getName());
                out.key("dn").value((Object)s.getDefaultDisplayName(this.cx));
                int flags = s.getDefaultFlags();
                if (flags > 0) {
                    out.key("f").value((Object)Flags.encodeToString((int)flags));
                }
                if (!(facets = s.getFacets()).isNull()) {
                    out.key("x").value((Object)facets.encodeToString());
                }
                if (s.isProperty()) {
                    out.key("v");
                    Property prop = s.asProperty();
                    BValue val = prop instanceof NProperty ? ((NProperty)prop).value : prop.getDefaultValue();
                    encoder = new BsonEncoderPlugin.DisplayEncoder(new BsonEncoderPlugin((JSONWriter)out), (Context)new BasicContext(this.cx, val.isComponent() ? BFacets.DEFAULT : facets));
                    encoder.encode(val);
                    if (!val.getType().equals(prop.getType())) {
                        out.key("ts").value((Object)prop.getType().toString());
                    }
                } else {
                    encoder = new BsonEncoderPlugin.DisplayEncoder(new BsonEncoderPlugin((JSONWriter)out), (Context)new BasicContext(this.cx, facets));
                    if (s.isAction()) {
                        Action action = s.asAction();
                        BsonEncoderPlugin.encodeActionBson(encoder, action.getParameterType(), action.getParameterDefault(), action.getReturnType());
                    }
                    if (s.isTopic()) {
                        BsonEncoderPlugin.encodeTopicBson(encoder, s.asTopic().getEventType());
                    }
                }
                out.endObject();
            }
        }
    }

    private void encodeEnum(EnumType enumType, BoxWriter out) {
        int[] ordinals = enumType.getOrdinals();
        if (!enumType.isAbstract()) {
            BFrozenEnum frozen = (BFrozenEnum)enumType.getInstance();
            if (ordinals != null) {
                for (int ordi : ordinals) {
                    out.object().key("t").value((Object)enumType.getTag(ordi));
                    if (frozen.getOrdinal() == ordi) {
                        out.key("d").value(true);
                    }
                    out.key("dt").value((Object)enumType.getDisplayTag(ordi, this.cx));
                    out.key("o").value((long)ordi).endObject();
                }
            }
        }
    }

    void encode(TypeNode node, BoxWriter out) throws IOException {
        Type t = node.getResolvedType();
        out.array();
        if (t instanceof ComplexType) {
            this.encodeComplex((ComplexType)t, out);
        } else if (t instanceof EnumType) {
            this.encodeEnum((EnumType)t, out);
        }
        out.endArray();
    }
}

