/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.box.typenode.TypeNode;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class TypeNodeBuilder {
    private final Map<String, TypeNode> typeNodeMap = new HashMap<String, TypeNode>();
    private final TypeNodeVisitor superVisitor = new SuperVisitor();
    private final TypeNodeVisitor interfaceVisitor = new InterfaceVisitor();
    private final TypeNodeVisitor complexVisitor = new ComplexVisitor();

    private TypeNodeBuilder() {
    }

    public static TypeNodeBuilder make() {
        return new TypeNodeBuilder();
    }

    public TypeNode get(String typeSpec) throws Exception {
        TypeNode node = this.findTypeNode(typeSpec);
        if (node == null) {
            TypeInfo typeInfo = Sys.getRegistry().getType(typeSpec);
            node = this.makeTypeNode(typeInfo);
            this.putTypeNode(node);
            this.runExpanderVisitors(node);
        }
        return node;
    }

    public List<TypeNode> get(Set<String> typeSpecs) throws Exception {
        return typeSpecs.stream().map(ts -> {
            try {
                return this.get((String)ts);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public void clear() {
        this.typeNodeMap.clear();
        this.superVisitor.clear();
        this.interfaceVisitor.clear();
        this.complexVisitor.clear();
    }

    public int getSize() {
        return this.typeNodeMap.size();
    }

    private void runExpanderVisitors(TypeNode node) throws Exception {
        node.visit(this.superVisitor);
        node.visit(this.interfaceVisitor);
        node.visit(this.complexVisitor);
    }

    private TypeNode makeTypeNode(TypeInfo typeInfo) {
        return new TypeNode(typeInfo);
    }

    private void putTypeNode(TypeNode node) {
        this.typeNodeMap.put(node.toString(), node);
    }

    private TypeNode findTypeNode(String typeSpec) {
        return this.typeNodeMap.get(typeSpec);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                TypeNodeBuilder.make().get(args[0]).visit(new TraceDependenciesVisitor());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        } else {
            System.out.println("Please enter a type spec as an argument!");
            System.exit(-1);
        }
    }

    public static final class TraceDependenciesVisitor
    extends TypeNodeVisitor {
        private int indent = 0;

        @Override
        public boolean doVisit(TypeNode node) throws Exception {
            char[] padding = new char[this.indent * 2];
            for (int i = 0; i < padding.length; ++i) {
                padding[i] = 32;
            }
            System.out.print(padding);
            System.out.println(node);
            TraceDependenciesVisitor visitor = new TraceDependenciesVisitor();
            visitor.indent = this.indent + 1;
            node.visitDependencies(visitor);
            return false;
        }
    }

    private final class ComplexVisitor
    extends TypeNodeVisitor {
        private ComplexVisitor() {
        }

        @Override
        public boolean doVisit(TypeNode typeNode) throws Exception {
            if (typeNode.isComplex()) {
                ComplexType clxt = (ComplexType)typeNode.getResolvedType();
                for (NSlot s : clxt.getFrozenSlots()) {
                    BFacets facets = s.getFacets();
                    if (facets != BFacets.DEFAULT) {
                        this.scanValue(typeNode, (BValue)facets);
                    }
                    if (!s.getDeclaringType().equals(clxt)) {
                        this.scan(typeNode, s.getDeclaringType().getTypeInfo());
                        continue;
                    }
                    if (s.isProperty()) {
                        Property prop = s.asProperty();
                        this.scanValue(typeNode, prop instanceof NProperty ? ((NProperty)prop).value : prop.getDefaultValue());
                        continue;
                    }
                    if (s.isAction()) {
                        Action action = s.asAction();
                        if (action.getParameterDefault() != null) {
                            this.scanValue(typeNode, action.getParameterDefault());
                        }
                        if (action.getReturnType() == null) continue;
                        this.scan(typeNode, action.getReturnType().getTypeInfo());
                        continue;
                    }
                    if (!s.isTopic() || s.asTopic().getEventType() == null) continue;
                    this.scan(typeNode, s.asTopic().getEventType().getTypeInfo());
                }
            }
            return true;
        }

        private void scan(TypeNode typeNode, TypeInfo typeInfo) throws Exception {
            TypeNode node = TypeNodeBuilder.this.findTypeNode(typeInfo.toString());
            if (node == null) {
                node = TypeNodeBuilder.this.makeTypeNode(typeInfo);
                TypeNodeBuilder.this.putTypeNode(node);
                TypeNodeBuilder.this.runExpanderVisitors(node);
            }
            typeNode.addDependency(node);
        }

        private void scanValue(TypeNode typeNode, BValue value) throws Exception {
            Type[] types;
            this.scan(typeNode, value.getType().getTypeInfo());
            for (Type t : types = BsonEncoderPlugin.detectTypeDependencies((BObject)value)) {
                this.scan(typeNode, t.getTypeInfo());
            }
            if (value instanceof BComplex) {
                BComplex clx = (BComplex)value;
                SlotCursor cursor = clx.getProperties();
                while (cursor.next()) {
                    this.scanValue(typeNode, clx.get(cursor.property()));
                }
            }
        }
    }

    private final class InterfaceVisitor
    extends TypeNodeVisitor {
        private InterfaceVisitor() {
        }

        @Override
        public boolean doVisit(TypeNode typeNode) throws Exception {
            TypeInfo[] interfaceTypeInfos = typeNode.getInterfaces();
            if (interfaceTypeInfos != null) {
                for (TypeInfo info : interfaceTypeInfos) {
                    TypeNode node = TypeNodeBuilder.this.findTypeNode(info.toString());
                    if (node == null) {
                        node = TypeNodeBuilder.this.makeTypeNode(info);
                        TypeNodeBuilder.this.putTypeNode(node);
                        node.visit(TypeNodeBuilder.this.superVisitor);
                        node.visit(this);
                    }
                    typeNode.addDependency(node);
                }
            }
            return true;
        }
    }

    private final class SuperVisitor
    extends TypeNodeVisitor {
        private SuperVisitor() {
        }

        @Override
        public boolean doVisit(TypeNode typeNode) throws Exception {
            TypeInfo superTypeInfo = typeNode.getSuperType();
            if (superTypeInfo != null) {
                TypeNode node = TypeNodeBuilder.this.findTypeNode(superTypeInfo.toString());
                if (node == null) {
                    node = TypeNodeBuilder.this.makeTypeNode(superTypeInfo);
                    TypeNodeBuilder.this.putTypeNode(node);
                    node.visit(TypeNodeBuilder.this.interfaceVisitor);
                    node.visit(this);
                    node.visit(TypeNodeBuilder.this.complexVisitor);
                }
                typeNode.addDependency(node);
            }
            return true;
        }
    }
}

