/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.util;

import com.tridium.box.BoxOp;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.util.UndoableRecord;
import com.tridium.sys.transfer.DeleteOp;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.baja.file.BIFile;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class DeleteRecord
extends UndoableRecord {
    private DeleteOp deleteOp;
    private Set<String> affectedSpaceOrds;

    private DeleteRecord(BoxOp op) {
        super(op);
    }

    public static DeleteRecord deleteComponents(Mark mark, BoxOp op) {
        DeleteRecord deleteRecord = new DeleteRecord(op);
        deleteRecord.doTransfer(mark, DeleteRecord.getTransferContext(op));
        return deleteRecord;
    }

    private static void deleteFiles(Mark mark) throws IOException {
        for (BObject obj : mark.getValues()) {
            BIFile file = (BIFile)obj;
            file.delete();
        }
    }

    @Override
    public void undoTransfer(BoxWriter out) {
        if (this.deleteOp == null) {
            throw new IllegalStateException("Nothing to undelete");
        }
        this.deleteOp.undelete();
    }

    @Override
    public Set<String> getAffectedSpaceOrds() {
        return Collections.unmodifiableSet(this.affectedSpaceOrds);
    }

    private void doTransfer(Mark mark, Context cx) {
        if (this.deleteOp != null) {
            throw new IllegalStateException("Already deleted");
        }
        this.deleteOp = DeleteOp.make((Mark)mark, (Context)cx);
        this.affectedSpaceOrds = DeleteRecord.getComponentSpaceOrds(mark);
        this.deleteOp.delete();
    }
}

