/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.data.BooleanValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="testIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="trueIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="falseIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="valueSearchLimit", type="BRelTime", defaultValue="BRelTime.HOUR", flags=8)})
public class BCovSwitchBlock
extends BOutputBlock {
    @Generated
    public static final Property testIn = BCovSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property trueIn = BCovSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property falseIn = BCovSwitchBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property valueSearchLimit = BCovSwitchBlock.newProperty((int)8, (BValue)BRelTime.HOUR, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCovSwitchBlock.class);

    @Generated
    public BBlockPin getTestIn() {
        return (BBlockPin)this.get(testIn);
    }

    @Generated
    public void setTestIn(BBlockPin v) {
        this.set(testIn, (BValue)v, null);
    }

    @Generated
    public BBlockPin getTrueIn() {
        return (BBlockPin)this.get(trueIn);
    }

    @Generated
    public void setTrueIn(BBlockPin v) {
        this.set(trueIn, (BValue)v, null);
    }

    @Generated
    public BBlockPin getFalseIn() {
        return (BBlockPin)this.get(falseIn);
    }

    @Generated
    public void setFalseIn(BBlockPin v) {
        this.set(falseIn, (BValue)v, null);
    }

    @Generated
    public BRelTime getValueSearchLimit() {
        return (BRelTime)this.get(valueSearchLimit);
    }

    @Generated
    public void setValueSearchLimit(BRelTime v) {
        this.set(valueSearchLimit, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getInputDefault(int idx, AnalyticContext cx) {
        if (idx == 1) {
            return new BooleanValue(System.currentTimeMillis(), true, 0);
        }
        return new BooleanValue(System.currentTimeMillis(), false, 0);
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        try (AnalyticTrend trend = this.getInput(0).getTrend(this.prepareContext(cx));){
            long end = trend.getContext().getEndTime();
            AnalyticValue last = null;
            AnalyticValue tmp = null;
            while (trend.hasNext()) {
                tmp = trend.next();
                if (end > 0L && tmp.getTimestamp() > end) break;
                if (last == null) {
                    last = tmp.newCopy();
                    continue;
                }
                last.copy(tmp);
            }
            AnalyticValue current = this.getInput(0).getValue(cx);
            tmp = last != null && !current.statusValueEquals(last) ? this.getInputValue(1, cx) : this.getInputValue(2, cx);
            AnalyticValue analyticValue = tmp.orStatus(current);
            return analyticValue;
        }
    }

    @Override
    public boolean isInputRequired(int idx) {
        return idx == 0;
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        AnalyticContextWrapper w = new AnalyticContextWrapper(cx);
        BAbsTime now = Clock.time();
        BAbsTime start = now.subtract(this.getValueSearchLimit());
        w.setTimeRange(BAnalyticTimeRange.make(start, now));
        return w;
    }

    private static class MyTrend
    extends BlockTrend {
        private AnalyticValue last;

        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            AnalyticValue val = this.getValue(0);
            if (this.last == null) {
                this.last = val.newCopy();
            }
            AnalyticValue ret = null;
            ret = !val.statusValueEquals(this.last) ? this.getValue(1) : this.getValue(2);
            this.last.copy(val);
            return ret.orStatus(val);
        }
    }
}

