/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.algorithm.AlgorithmBlock;
import com.tridiumx.analytics.util.Utils;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="trendIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="mode", type="BEnum", defaultValue="BDynamicEnum.make((int)MILLIS_MINUTE)", flags=8, facets={@Facet(value="BFacets.makeEnum(MODE)")}), @NiagaraProperty(name="timeRange", type="BAnalyticTimeRange", defaultValue="BAnalyticTimeRange.make(\"current30days\")", flags=8), @NiagaraProperty(name="useRequestTimeRange", type="boolean", defaultValue="true", flags=8)})
public class BRuntimeBlock
extends BOutputBlock {
    public static final BEnumRange MODE = BEnumRange.make((int[])new int[]{1, 1000, 60000, 3600000}, (String[])new String[]{Utils.lex("millis"), Utils.lex("seconds"), Utils.lex("minutes"), Utils.lex("hours")});
    @Generated
    public static final Property trendIn = BRuntimeBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property mode = BRuntimeBlock.newProperty((int)8, (BValue)BDynamicEnum.make((int)60000), (BFacets)BFacets.makeEnum((BEnumRange)MODE));
    @Generated
    public static final Property timeRange = BRuntimeBlock.newProperty((int)8, (BValue)BAnalyticTimeRange.make("current30days"), null);
    @Generated
    public static final Property useRequestTimeRange = BRuntimeBlock.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRuntimeBlock.class);

    @Generated
    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    @Generated
    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Generated
    public BEnum getMode() {
        return (BEnum)this.get(mode);
    }

    @Generated
    public void setMode(BEnum v) {
        this.set(mode, (BValue)v, null);
    }

    @Generated
    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public boolean getUseRequestTimeRange() {
        return this.getBoolean(useRequestTimeRange);
    }

    @Generated
    public void setUseRequestTimeRange(boolean v) {
        this.setBoolean(useRequestTimeRange, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        cx = this.prepareContext(cx);
        AnalyticNumeric ret = AnalyticValue.makeNumeric();
        if (!this.getInput(0).hasTrend(cx)) {
            return ret.setValue(0.0);
        }
        try (AnalyticTrend trend = this.getInput(0).getTrend(cx);){
            double millis = Utils.runtimeMillis(trend);
            AnalyticValue analyticValue = ret.setValue(millis / (double)this.getMode().getOrdinal());
            return analyticValue;
        }
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        cx = this.prepareContext(cx);
        return new MyTrend(this, cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        return true;
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        if (!this.getUseRequestTimeRange() || cx.getTimeRange(false) == null) {
            cx = new AnalyticContextWrapper(cx);
            cx.setTimeRange(this.getTimeRange());
        }
        return cx;
    }

    private static class MyTrend
    extends BlockTrend {
        private AnalyticNumeric cache = AnalyticValue.makeNumeric();
        private long lastTs = -1L;
        private int lastSts = 0;
        private boolean lastVal = false;
        private long runtime = 0L;
        private BEnum mode;

        public MyTrend(AlgorithmBlock block, AnalyticContext cx) {
            super(block, cx);
            this.mode = ((BRuntimeBlock)block).getMode();
        }

        @Override
        protected AnalyticValue getNext() {
            while (this.advance()) {
                AnalyticValue val = this.getValue(0);
                long curTs = val.getTimestamp();
                if (this.lastTs < 0L) {
                    this.lastTs = curTs;
                    this.lastVal = val.toBoolean();
                    this.lastSts = val.getStatus();
                    continue;
                }
                this.runtime = this.lastVal ? (this.runtime += curTs - this.lastTs) : 0L;
                this.cache.setValue((double)this.runtime / (double)this.mode.getOrdinal()).setStatus(this.lastSts).setTimestamp(curTs);
                this.lastTs = curTs;
                this.lastVal = val.toBoolean() && val.isValid();
                this.lastSts = val.getStatus();
                return this.cache;
            }
            return null;
        }
    }
}

