/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.BFunctionBlock;
import com.tridiumx.analytics.algorithm.BTimeUnit;
import com.tridiumx.analytics.time.TimeBinding;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.data.AnalyticValue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="quantity", type="int", defaultValue="1", flags=8), @NiagaraProperty(name="timeUnit", type="BTimeUnit", defaultValue="BTimeUnit.years", flags=8)})
public class BTimestampOffsetBlock
extends BFunctionBlock {
    @Generated
    public static final Property quantity = BTimestampOffsetBlock.newProperty((int)8, (int)1, null);
    @Generated
    public static final Property timeUnit = BTimestampOffsetBlock.newProperty((int)8, (BValue)BTimeUnit.years, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimestampOffsetBlock.class);

    @Generated
    public int getQuantity() {
        return this.getInt(quantity);
    }

    @Generated
    public void setQuantity(int v) {
        this.setInt(quantity, v, null);
    }

    @Generated
    public BTimeUnit getTimeUnit() {
        return (BTimeUnit)this.get(timeUnit);
    }

    @Generated
    public void setTimeUnit(BTimeUnit v) {
        this.set(timeUnit, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue apply(AnalyticValue val) {
        return val.setTimestamp(this.adjust(val.getTimestamp()));
    }

    private long adjust(long time) {
        int qty = this.getQuantity();
        if (time == 0L) {
            return 0L;
        }
        switch (this.getTimeUnit().getOrdinal()) {
            case 0: {
                return TimeBinding.addSeconds(qty, time);
            }
            case 1: {
                return TimeBinding.addMinutes(qty, time);
            }
            case 2: {
                return TimeBinding.addHours(qty, time);
            }
            case 3: {
                return TimeBinding.addDays(qty, time);
            }
            case 4: {
                return TimeBinding.addWeeks(qty, time);
            }
            case 5: {
                return TimeBinding.addMonths(qty, time);
            }
            case 6: {
                return TimeBinding.addYears(qty, time);
            }
        }
        return time;
    }
}

