/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.algorithm.BFunctionBlock;
import com.tridiumx.analytics.algorithm.BUniMathOperator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticValue;

@NiagaraType
@NiagaraProperty(name="operator", type="BUniMathOperator", defaultValue="BUniMathOperator.abs", flags=8)
public class BUniMathBlock
extends BFunctionBlock {
    @Generated
    public static final Property operator = BUniMathBlock.newProperty((int)8, (BValue)BUniMathOperator.abs, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUniMathBlock.class);

    @Generated
    public BUniMathOperator getOperator() {
        return (BUniMathOperator)this.get(operator);
    }

    @Generated
    public void setOperator(BUniMathOperator v) {
        this.set(operator, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue apply(AnalyticValue val) {
        double v = val.toNumeric();
        double result = this.getOperator().evaluate(v);
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            val.setStatus(val.getStatus() | 0x40);
        }
        if (val instanceof AnalyticNumeric) {
            ((AnalyticNumeric)val).setValue(result);
        } else {
            val.setValue(BDouble.make((double)result));
        }
        return val;
    }
}

