/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import javax.bajax.analytics.data.AnalyticValue;

public final class RangeCombiner
extends AbstractCombiner {
    private NumericValue analytic = new NumericValue();
    private double min;
    private double max;

    public RangeCombiner() {
        super(10);
        this.reset();
    }

    @Override
    public AnalyticValue getValue() {
        return this.analytic.setValue(this.max - this.min);
    }

    @Override
    protected void doReset() {
        this.min = 0.0;
        this.max = 0.0;
        this.analytic.set(0L, 0.0, 64, BInterpolationTrendFlags.DEFAULT);
    }

    @Override
    protected boolean doUpdate(AnalyticValue arg) {
        double val = arg.toNumeric();
        if (this.getCount() == 0) {
            this.min = val;
            this.max = val;
            this.analytic.setStatus(arg.getStatus());
        } else {
            if (val > this.max) {
                this.max = val;
            } else if (val < this.min) {
                this.min = val;
            }
            this.analytic.orStatus(arg);
        }
        this.analytic.copyTimestamp(arg);
        this.analytic.orTrendFlags(arg);
        return true;
    }
}

