/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.bajax.analytics.data.AnalyticValue;

public abstract class AbstractAnalyticValue
implements AnalyticValue {
    protected int status = 0;
    protected long timestamp = 0L;
    protected BInterpolationTrendFlags trendFlags = BInterpolationTrendFlags.DEFAULT;

    @Override
    public AnalyticValue andStatus(AnalyticValue arg) {
        this.status &= arg.getStatus();
        return this;
    }

    @Override
    public AnalyticValue copyStatus(AnalyticValue arg) {
        this.status = arg.getStatus();
        return this;
    }

    @Override
    public AnalyticValue copyTimestamp(AnalyticValue arg) {
        this.timestamp = arg.getTimestamp();
        return this;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public AnalyticValue orStatus(AnalyticValue arg) {
        this.status |= arg.getStatus();
        return this;
    }

    public AnalyticValue orTrendFlags(AnalyticValue arg) {
        BInterpolationTrendFlags otherTrendFlags = ((AbstractAnalyticValue)arg).getTrendFlags();
        int trendFlagBits = this.trendFlags.getBits() | otherTrendFlags.getBits();
        this.trendFlags = BInterpolationTrendFlags.make(trendFlagBits);
        return this;
    }

    @Override
    public AnalyticValue setStatus(int arg) {
        this.status = arg;
        return this;
    }

    @Override
    public AnalyticValue setTimestamp(long arg) {
        this.timestamp = arg;
        return this;
    }

    @Override
    public boolean statusValueEquals(AnalyticValue arg) {
        if (this.status != arg.getStatus()) {
            return false;
        }
        return this.valueEquals(arg);
    }

    public BInterpolationTrendFlags getTrendFlags() {
        return this.trendFlags;
    }

    public void setTrendFlags(BInterpolationTrendFlags trendFlags) {
        this.trendFlags = trendFlags;
    }

    @Override
    public String toString(Context cx) {
        StringBuilder buf = new StringBuilder();
        if (this.timestamp > 0L) {
            buf.append(BAbsTime.make((long)this.timestamp).toString(cx));
            buf.append(' ');
        }
        buf.append(this.toString());
        buf.append(" {").append(Values.toString(this.status)).append('}');
        return buf.toString();
    }
}

