/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data.substitute;

import com.tridiumx.analytics.data.substitute.Interpolator;
import com.tridiumx.analytics.trend.NiagaraTrend;
import com.tridiumx.analytics.trend.RawDataFilterTrend;
import com.tridiumx.analytics.trend.StatusFilterTrend;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BInterval;

public abstract class AbstractInterpolator
implements Interpolator {
    protected long currentTimestamp;
    protected long currentTime;
    protected long lastTimestamp;
    protected AnalyticValue currentVal;
    protected AnalyticTrend trend;
    protected long trendStartTime;
    protected long trendEndTime;
    protected long historyInterval = 0L;
    protected BInterval bHistoryInterval = BInterval.DEFAULT;
    protected short vicinityTolerance = (short)50;

    public AbstractInterpolator(AnalyticTrend trend) {
        this.trend = trend;
        this.init();
    }

    @Override
    public void accept(AnalyticValue analyticValue) {
        this.interpolate();
    }

    @Override
    public void init() {
        AnalyticContext cx = this.trend.getContext();
        this.trendStartTime = cx.getStartTime();
        this.trendEndTime = cx.getEndTime();
        this.updateIntervalValue(cx);
        boolean isIntervalTrend = this.isIntervalTrend();
        this.vicinityTolerance = AnalyticConstants.findVicinityTolerance(this.historyInterval);
        this.currentTime = BAbsTime.now().getMillis();
        long l = this.trendEndTime = this.trendEndTime < 0L || this.trendEndTime > this.currentTime ? this.currentTime : this.trendEndTime;
        if (isIntervalTrend) {
            boolean hasTrendData = this.trend.hasNext();
            if (hasTrendData) {
                this.currentVal = this.trend.next().newCopy();
                this.currentTimestamp = this.currentVal.getTimestamp();
                if (this.currentTimestamp >= this.trendEndTime) {
                    this.currentVal = null;
                    hasTrendData = false;
                } else if (this.historyInterval > 0L && this.currentTimestamp >= this.trendStartTime + this.historyInterval) {
                    do {
                        this.currentTimestamp -= this.historyInterval;
                    } while (this.currentTimestamp >= this.trendStartTime + this.historyInterval);
                } else if (!this.bHistoryInterval.equals(BInterval.none)) {
                    this.alignCurrentTSByInterval();
                }
            }
            if (!hasTrendData) {
                this.currentTimestamp = this.trendEndTime;
            }
        } else {
            String warning = "Currently, interpolation can be applied to regular interval trends only";
            Log.getLog((String)"interpolator").warning(warning);
        }
    }

    private void alignCurrentTSByInterval() {
        while (this.currentTimestamp > this.trendStartTime) {
            this.currentTimestamp = this.bHistoryInterval.previous(this.currentTimestamp);
        }
        if (this.currentTimestamp < this.trendStartTime) {
            this.currentTimestamp = this.bHistoryInterval.next(this.currentTimestamp);
        }
        this.historyInterval = this.bHistoryInterval.millis();
    }

    private void updateIntervalValue(AnalyticContext cx) {
        if (this.trend instanceof NiagaraTrend) {
            this.historyInterval = ((NiagaraTrend)this.trend).getInterval().getMillis();
        } else if (this.trend instanceof StatusFilterTrend) {
            this.historyInterval = ((StatusFilterTrend)this.trend).getInterval().getMillis();
        } else if (this.trend instanceof RawDataFilterTrend) {
            this.historyInterval = ((RawDataFilterTrend)this.trend).getInterval().getMillis();
        } else {
            this.bHistoryInterval = (BInterval)cx.getInterval(true);
        }
    }

    protected boolean isIntervalTrend() {
        return this.historyInterval != 0L || !this.bHistoryInterval.equals(BInterval.none);
    }

    @Override
    public boolean complete() {
        boolean isIntervalTrend = this.isIntervalTrend();
        boolean flag = false;
        if (isIntervalTrend) {
            flag = this.currentTimestamp < this.trendEndTime && this.currentTimestamp < this.currentTime;
        }
        return !flag;
    }
}

