/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data.substitute;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.substitute.AbstractInterpolator;
import com.tridiumx.analytics.data.substitute.KNNLinkedList;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.trend.NiagaraTrend;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class KNNInterpolator
extends AbstractInterpolator {
    protected AnalyticValue ret;
    private static final int DEFAULT_KNN_VAL = 3;
    private int knnVal;
    private KNNLinkedList kNNLinkedList;
    private long firstTimestamp;
    private final boolean proceed;
    private static final int HISTORY_INTERVAL_FACTOR = 2;

    public KNNInterpolator(NiagaraTrend trend) {
        this(trend, 3);
    }

    public KNNInterpolator(AnalyticTrend trend, int knnVal) {
        super(trend);
        this.knnVal = knnVal;
        this.kNNLinkedList = new KNNLinkedList(this.knnVal);
        this.firstTimestamp = this.currentTimestamp;
        this.proceed = super.isIntervalTrend();
    }

    @Override
    public boolean interpolate() {
        boolean inserted = false;
        if (this.proceed) {
            long nextTimeStamp = this.bHistoryInterval.next(this.currentTimestamp);
            if (this.currentVal == null) {
                this.ret = null;
            } else {
                long recTimeStamp = this.currentVal.getTimestamp();
                if (recTimeStamp < nextTimeStamp && this.timeStampsInVicinity(this.currentTimestamp, recTimeStamp, this.historyInterval)) {
                    this.ret = this.currentVal.newCopy();
                    inserted = this.kNNLinkedList.tryInsert(this.ret, this.getCalculatedOffset(this.ret.getTimestamp()));
                    this.currentVal = this.trend.hasNext() ? this.trend.next().newCopy() : this.currentVal;
                } else {
                    this.ret = this.kNNLinkedList.getRecordByTimestamp(this.currentTimestamp);
                    if (this.ret == null) {
                        do {
                            long offset = this.getCalculatedOffset(this.currentVal.getTimestamp());
                            boolean bl = inserted = this.currentVal.getTimestamp() < this.trendEndTime && this.kNNLinkedList.tryInsert(this.currentVal, this.currentTimestamp, offset);
                            if (!inserted) continue;
                            if (this.trend.hasNext()) {
                                this.currentVal = this.trend.next().newCopy();
                                continue;
                            }
                            inserted = false;
                        } while (inserted);
                        this.ret = this.kNNLinkedList.getInterpolatedValue(this.currentTimestamp);
                        this.ret.setTimestamp(this.currentTimestamp);
                        if (this.ret instanceof AbstractAnalyticValue) {
                            ((AbstractAnalyticValue)this.ret).setTrendFlags(BInterpolationTrendFlags.knnInterpolated);
                        }
                    }
                    if (this.ret != null) {
                        inserted = this.kNNLinkedList.tryInsert(this.ret, this.getCalculatedOffset(this.ret.getTimestamp()));
                    }
                }
            }
            this.currentTimestamp = nextTimeStamp;
            return this.ret != null && inserted;
        }
        return false;
    }

    private long getCalculatedOffset(long timestamp) {
        long diff;
        long offset = timestamp;
        if (this.firstTimestamp >= this.trendStartTime && (offset = (diff = timestamp - this.firstTimestamp) % this.historyInterval) != 0L) {
            return offset <= this.historyInterval / 2L ? -offset : this.historyInterval - offset;
        }
        return offset;
    }

    private boolean timeStampsInVicinity(long ts1, long ts2, long interval) {
        long diff = Math.abs(ts1 - ts2);
        return diff <= interval * (long)this.vicinityTolerance / 100L;
    }

    @Override
    public AnalyticValue getCurrentValue() {
        return this.ret;
    }
}

