/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.hier;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.hier.BHierNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="hier")
@NiagaraSingleton
public class BHierOrdScheme
extends BOrdScheme {
    @Generated
    public static final BHierOrdScheme INSTANCE = new BHierOrdScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BHierOrdScheme.class);
    private static Map<String, BHierNode> cache = new ConcurrentHashMap<String, BHierNode>(100);
    private static BINavNode hierarchyRoot;
    private static BHierNode hierRoot;
    private static volatile BComponent space;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHierOrdScheme() {
        super("hier");
    }

    public static void clearCache() {
        hierarchyRoot = null;
        hierRoot = null;
        cache.clear();
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        try {
            BHierNode node;
            BISession session = this.toSession(base);
            if (session instanceof BFoxSession) {
                return this.resolveFox((BFoxSession)session, base, query);
            }
            if (space == null) {
                space = BAnalyticService.getInstance().getHierCache();
            }
            if (hierarchyRoot == null) {
                hierarchyRoot = (BINavNode)BOrd.make((String)"hierarchy:").get((BObject)Sys.getStation());
                hierRoot = new BHierNode(hierarchyRoot);
                hierRoot.setNavOrd(BOrd.make((String)"hier:"));
                space.add(SlotPath.escape((String)hierarchyRoot.getNavDisplayName((Context)base)), (BValue)hierRoot, BHierNode.flags);
                cache.put("hier:", hierRoot);
            }
            if ((node = cache.get(query.toString())) != null) {
                return new OrdTarget(base, (BObject)node);
            }
            BHierNode lastNode = hierRoot;
            String[] parts = query.toString().split("/");
            StringBuilder buf = new StringBuilder("hier:");
            int len = parts.length;
            for (int i = 1; i < len; ++i) {
                String slotName = SlotPath.escape((String)parts[i]);
                buf.append('/').append(parts[i]);
                String tmp = buf.toString();
                node = cache.get(tmp);
                if (node == null) {
                    node = (BHierNode)lastNode.get(slotName);
                }
                if (node == null) {
                    node = (BHierNode)lastNode.getNavChild(parts[i]);
                    cache.put(tmp, node);
                }
                lastNode = node;
            }
            return new OrdTarget(base, (BObject)node);
        }
        catch (Exception x) {
            x.printStackTrace();
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
    }

    private OrdTarget resolveFox(BFoxSession session, OrdTarget base, OrdQuery query) throws Exception {
        BOrd remoteOrd = BOrd.make((String)query.toString());
        BFoxClientConnection conn = session.getConnection();
        BDataChannel channel = (BDataChannel)conn.getChannels().get("data");
        BObject res = channel.resolve(remoteOrd, new String[0]);
        remoteOrd = BOrd.make((String)res.toString(null));
        return remoteOrd.resolve(base.get(), (Context)base);
    }

    private BISession toSession(OrdTarget baseTarget) {
        if (baseTarget == null) {
            throw new InvalidOrdBaseException("null");
        }
        BISession session = null;
        for (OrdTarget target = baseTarget; target != null && (session = BOrd.toSession((BObject)target.get())) == null; target = target.getBaseOrdTarget()) {
        }
        if (session != null) {
            return session;
        }
        throw new InvalidOrdBaseException("" + baseTarget.get());
    }
}

