/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.history;

import com.tridiumx.analytics.time.Duration;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public final class BComplexTimeRange
extends BSimple {
    private static final int TYPE_NULL = 0;
    private static final int TYPE_DATE_RANGE = 1;
    public static final int ALIGN_SECOND = 10;
    public static final int ALIGN_MINUTE = 20;
    public static final int ALIGN_HOUR = 30;
    public static final int ALIGN_DAY = 40;
    public static final int ALIGN_WEEK = 50;
    public static final int ALIGN_MONTH = 60;
    public static final int ALIGN_YEAR = 70;
    public static final BComplexTimeRange NULL;
    public static final BComplexTimeRange DEFAULT;
    public static final BComplexTimeRange all;
    public static final BComplexTimeRange today;
    public static final BComplexTimeRange yesterday;
    public static final BComplexTimeRange thisWeek;
    public static final BComplexTimeRange lastWeek;
    public static final BComplexTimeRange thisMonth;
    public static final BComplexTimeRange lastMonth;
    public static final BComplexTimeRange thisYear;
    public static final BComplexTimeRange lastYear;
    public static final BComplexTimeRange weekToDate;
    public static final BComplexTimeRange monthToDate;
    public static final BComplexTimeRange yearToDate;
    public static final Type TYPE;
    private String value;
    private int units;
    private Duration startOffset = null;
    private Duration endOffset = null;

    public Type getType() {
        return TYPE;
    }

    private BComplexTimeRange() {
        this.value = "null";
        this.units = 0;
    }

    private BComplexTimeRange(String value, int units) {
        this.value = value;
        this.units = units;
    }

    private BComplexTimeRange(String value, int units, Duration startOffset, Duration endOffset) {
        this.value = value;
        this.units = units;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof BObject) {
            return this.value.compareTo(((BObject)obj).toString(null));
        }
        return this.value.compareTo(obj.toString());
    }

    public BObject decode(DataInput in) throws IOException {
        return BComplexTimeRange.make(in.readUTF());
    }

    public BObject decodeFromString(String s) {
        return BComplexTimeRange.make(s);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.value);
    }

    public String encodeToString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BComplexTimeRange) {
            BComplexTimeRange str = (BComplexTimeRange)((Object)obj);
            return this.value.equals(str.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean isNull() {
        return this == NULL;
    }

    public BAbsTime getEnd() {
        return this.getEndFrom(Clock.time());
    }

    public BAbsTime getEnd(BAbsTime from) {
        return this.getEndFrom(from);
    }

    public BAbsTime getEndFrom(BAbsTime time) {
        if (this.units == 0) {
            return BAbsTime.NULL;
        }
        if (this.units == 1) {
            try {
                return (BAbsTime)BAbsTime.NULL.decodeFromString(this.value.substring(this.value.indexOf(59) + 1));
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid time: " + this.value.substring(this.value.indexOf(59) + 1));
            }
        }
        if (this.endOffset == null) {
            return time;
        }
        return this.endOffset.addTo(this.getStartFrom(time));
    }

    public BAbsTime getStart() {
        return this.getStartFrom(Clock.time());
    }

    public BAbsTime getStart(BAbsTime end) {
        if (this.units == 0) {
            return BAbsTime.NULL;
        }
        if (this.units == 1) {
            try {
                return (BAbsTime)BAbsTime.NULL.decodeFromString(this.value.substring(0, this.value.indexOf(59)));
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid time: " + this.value.substring(0, this.value.indexOf(59)));
            }
        }
        if (this.endOffset == null) {
            return this.getStartFrom(end);
        }
        Duration eo = new Duration(this.endOffset);
        eo.negative = !eo.negative;
        return eo.addTo(end);
    }

    public BAbsTime getStartFrom(BAbsTime from) {
        if (this.units == 0) {
            return BAbsTime.NULL;
        }
        if (this.units == 1) {
            try {
                return (BAbsTime)BAbsTime.NULL.decodeFromString(this.value.substring(0, this.value.indexOf(59)));
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Invalid time: " + this.value.substring(0, this.value.indexOf(59)));
            }
        }
        BAbsTime start = this.align(from, this.units);
        if (this.startOffset != null) {
            start = this.startOffset.addTo(start);
        }
        return start;
    }

    public boolean includes(BAbsTime time) {
        if (this == DEFAULT || this == NULL) {
            return true;
        }
        if (time.isAfter(this.getEnd())) {
            return false;
        }
        return !time.isBefore(this.getStart());
    }

    public static BComplexTimeRange make(BAbsTime start, BAbsTime end) {
        return new BComplexTimeRange(start.encodeToString() + ";" + end.encodeToString(), 1);
    }

    public static BComplexTimeRange make(String s) {
        if (s == null) {
            return NULL;
        }
        if (s.length() == 0) {
            return NULL;
        }
        switch (s.charAt(0)) {
            case 'a': 
            case 'l': 
            case 'm': 
            case 't': 
            case 'w': 
            case 'y': {
                return BComplexTimeRange.parseConstant(s);
            }
            case 'c': {
                return BComplexTimeRange.parseCurrent(s);
            }
            case 'p': {
                return BComplexTimeRange.parsePrevious(s);
            }
            case 'n': {
                if (s.startsWith("null")) {
                    return NULL;
                }
                return BComplexTimeRange.parseNext(s);
            }
            case 'f': {
                return BComplexTimeRange.parseFrom(s);
            }
        }
        if (s.indexOf(59) > 0) {
            return new BComplexTimeRange(s, 1);
        }
        if (s.startsWith("NULL")) {
            return NULL;
        }
        throw new IllegalArgumentException("Unknown time range: " + s);
    }

    public static String[] parseParts(String s) {
        if (s == null) {
            return new String[]{"null"};
        }
        if (s.length() == 0) {
            return new String[]{"null"};
        }
        switch (s.charAt(0)) {
            case 'l': 
            case 'm': 
            case 't': 
            case 'w': 
            case 'y': {
                return new String[]{s};
            }
            case 'a': {
                return new String[]{"null"};
            }
            case 'c': 
            case 'n': 
            case 'p': {
                if (s.equals("null")) {
                    return new String[]{s};
                }
                return BComplexTimeRange.parsePcnParts(s);
            }
            case 'f': {
                return BComplexTimeRange.parseFromParts(s);
            }
        }
        if (s.indexOf(59) > 0) {
            return new String[]{s};
        }
        throw new IllegalArgumentException("Unknown time range: " + s);
    }

    public String toString(Context cx) {
        return this.value;
    }

    private BAbsTime align(BAbsTime base, int unit) {
        BAbsTime ret = base;
        BTimeZone tz = base.getTimeZone();
        switch (unit) {
            case 10: {
                return BAbsTime.make((int)ret.getYear(), (BMonth)ret.getMonth(), (int)ret.getDay(), (int)ret.getHour(), (int)ret.getMinute(), (int)ret.getSecond(), (int)0, (BTimeZone)tz);
            }
            case 20: {
                return BAbsTime.make((int)ret.getYear(), (BMonth)ret.getMonth(), (int)ret.getDay(), (int)ret.getHour(), (int)ret.getMinute(), (int)0, (int)0, (BTimeZone)tz);
            }
            case 30: {
                return BAbsTime.make((int)ret.getYear(), (BMonth)ret.getMonth(), (int)ret.getDay(), (int)ret.getHour(), (int)0, (int)0, (int)0, (BTimeZone)tz);
            }
            case 40: {
                return BAbsTime.make((int)ret.getYear(), (BMonth)ret.getMonth(), (int)ret.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)tz);
            }
            case 50: {
                BWeekday wd = BWeekday.getFirstDayOfWeek(null);
                if (!ret.getWeekday().equals((Object)wd)) {
                    ret = ret.prev(wd);
                }
                return BAbsTime.make((int)ret.getYear(), (BMonth)ret.getMonth(), (int)ret.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)tz);
            }
            case 60: {
                return BAbsTime.make((int)ret.getYear(), (BMonth)ret.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)tz);
            }
            case 70: {
                return BAbsTime.make((int)ret.getYear(), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)tz);
            }
        }
        throw new IllegalStateException("Unexpected error: " + this.value);
    }

    private static BComplexTimeRange parseConstant(String str) {
        switch (str.charAt(0)) {
            case 'y': {
                if (str.equals("yesterday")) {
                    return yesterday;
                }
                if (!str.equals("yearToDate")) break;
                return yearToDate;
            }
            case 'm': {
                if (!str.equals("monthToDate")) break;
                return monthToDate;
            }
            case 'w': {
                if (!str.equals("weekToDate")) break;
                return weekToDate;
            }
            case 't': {
                if (str.equals("today")) {
                    return today;
                }
                if (str.equals("thisWeek")) {
                    return thisWeek;
                }
                if (str.equals("thisMonth")) {
                    return thisMonth;
                }
                if (!str.equals("thisYear")) break;
                return thisYear;
            }
            case 'l': {
                if (str.equals("lastWeek")) {
                    return lastWeek;
                }
                if (str.equals("lastMonth")) {
                    return lastMonth;
                }
                if (!str.equals("lastYear")) break;
                return lastYear;
            }
            case 'a': {
                if (!str.equals("all")) break;
                return NULL;
            }
        }
        throw new IllegalArgumentException("Unknown time range: " + str);
    }

    private static BComplexTimeRange parseCurrent(String s) {
        int i;
        int j;
        int len = s.length();
        for (j = i = 7; j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        int num = Integer.parseInt(s.substring(i, j));
        int units = BComplexTimeRange.toUnit(s, s.charAt(j), s.charAt(j + 1));
        Duration sdur = new Duration();
        sdur.negative = true;
        Duration edur = new Duration();
        switch (units) {
            case 10: {
                sdur.seconds = num - 1;
                edur.seconds = num;
                break;
            }
            case 20: {
                sdur.minutes = num - 1;
                edur.minutes = num;
                break;
            }
            case 30: {
                sdur.hours = num - 1;
                edur.hours = num;
                break;
            }
            case 40: {
                sdur.days = num - 1;
                edur.days = num;
                break;
            }
            case 50: {
                sdur.days = (num - 1) * 7;
                edur.days = num * 7;
                break;
            }
            case 60: {
                sdur.months = num - 1;
                edur.months = num;
                break;
            }
            case 70: {
                sdur.years = num - 1;
                edur.years = num;
            }
        }
        if (num == 1) {
            sdur = null;
        }
        return new BComplexTimeRange(s, units, sdur, edur);
    }

    private static BComplexTimeRange parseFrom(String str) {
        int units = BComplexTimeRange.toUnit(str, str.charAt(4), str.charAt(5));
        Duration startOff = null;
        Duration endOff = null;
        int to = str.indexOf("To");
        if (to < 0) {
            throw new IllegalStateException("Unknown time range: " + str);
        }
        int i = str.indexOf("P", 6);
        if (i > 0 && i < to) {
            char ch = str.charAt(i - 1);
            if (ch == '+' || ch == '-') {
                --i;
            }
            startOff = Duration.make(str.substring(i, to));
        }
        if (str.indexOf("Now", to) < 0) {
            endOff = Duration.make(str.substring(to + 2));
        }
        return new BComplexTimeRange(str, units, startOff, endOff);
    }

    private static String[] parseFromParts(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (!str.startsWith("from")) {
            throw new IllegalStateException("Unknown time range: " + str);
        }
        list.add("from");
        int to = str.indexOf("To");
        if (to < 0) {
            throw new IllegalStateException("Unknown time range: " + str);
        }
        int i = str.indexOf("P", 6);
        if (i > 0 && i < to) {
            char ch = str.charAt(i - 1);
            if (ch == '+' || ch == '-') {
                --i;
            }
            list.add(str.substring(4, i));
            list.add(str.substring(i, to));
        } else {
            list.add(str.substring(4, to));
        }
        list.add("To");
        if (str.indexOf("Now", to) < 0) {
            list.add(str.substring(to + 2));
        } else {
            list.add("Now");
        }
        return list.toArray(new String[0]);
    }

    private static BComplexTimeRange parseNext(String s) {
        int i;
        int j;
        int len = s.length();
        for (j = i = 4; j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        int num = Integer.parseInt(s.substring(i, j));
        int units = BComplexTimeRange.toUnit(s, s.charAt(j), s.charAt(j + 1));
        Duration sdur = new Duration();
        Duration edur = new Duration();
        switch (units) {
            case 10: {
                sdur.seconds = 1;
                edur.seconds = num;
                break;
            }
            case 20: {
                sdur.minutes = 1;
                edur.minutes = num;
                break;
            }
            case 30: {
                sdur.hours = 1;
                edur.hours = num;
                break;
            }
            case 40: {
                sdur.days = 1;
                edur.days = num;
                break;
            }
            case 50: {
                sdur.days = 7;
                edur.days = num * 7;
                break;
            }
            case 60: {
                sdur.months = 1;
                edur.months = num;
                break;
            }
            case 70: {
                sdur.years = 1;
                edur.years = num;
            }
        }
        return new BComplexTimeRange(s, units, sdur, edur);
    }

    private static String[] parsePcnParts(String s) {
        int i;
        int j;
        String[] ret = new String[3];
        if (s.startsWith("previous")) {
            ret[0] = "previous";
        } else if (s.startsWith("current")) {
            ret[0] = "current";
        } else if (s.startsWith("next")) {
            ret[0] = "next";
        } else {
            throw new IllegalStateException("Unknown time range: " + s);
        }
        int len = s.length();
        for (j = i = ret[0].length(); j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        ret[1] = s.substring(i, j);
        ret[2] = s.substring(j);
        return ret;
    }

    private static BComplexTimeRange parsePrevious(String s) {
        int i;
        int j;
        int len = s.length();
        for (j = i = 8; j < len && Character.isDigit(s.charAt(j)); ++j) {
        }
        int num = Integer.parseInt(s.substring(i, j));
        int units = BComplexTimeRange.toUnit(s, s.charAt(j), s.charAt(j + 1));
        Duration sdur = new Duration();
        sdur.negative = true;
        Duration edur = new Duration();
        switch (units) {
            case 10: {
                sdur.seconds = num;
                edur.seconds = num;
                break;
            }
            case 20: {
                sdur.minutes = num;
                edur.minutes = num;
                break;
            }
            case 30: {
                sdur.hours = num;
                edur.hours = num;
                break;
            }
            case 40: {
                sdur.days = num;
                edur.days = num;
                break;
            }
            case 50: {
                sdur.days = num * 7;
                edur.days = num * 7;
                break;
            }
            case 60: {
                sdur.months = num;
                edur.months = num;
                break;
            }
            case 70: {
                sdur.years = num;
                edur.years = num;
            }
        }
        return new BComplexTimeRange(s, units, sdur, edur);
    }

    private static int toUnit(String tr, char c1, char c2) {
        switch (c1) {
            case 'S': 
            case 's': {
                return 10;
            }
            case 'M': 
            case 'm': {
                if (c2 == 'i') {
                    return 20;
                }
                return 60;
            }
            case 'H': 
            case 'h': {
                return 30;
            }
            case 'D': 
            case 'd': {
                return 40;
            }
            case 'W': 
            case 'w': {
                return 50;
            }
            case 'Y': 
            case 'y': {
                return 70;
            }
        }
        throw new IllegalArgumentException("Unknown time range: " + tr);
    }

    static {
        DEFAULT = NULL = new BComplexTimeRange("null", 0);
        all = new BComplexTimeRange("all", 0);
        today = new BComplexTimeRange("today", 40, null, new Duration(false, 0, 0, 1));
        yesterday = new BComplexTimeRange("yesterday", 40, new Duration(true, 0, 0, 1), new Duration(false, 0, 0, 1));
        thisWeek = new BComplexTimeRange("thisWeek", 50, null, new Duration(false, 0, 0, 7));
        lastWeek = new BComplexTimeRange("lastWeek", 50, new Duration(true, 0, 0, 7), new Duration(false, 0, 0, 7));
        thisMonth = new BComplexTimeRange("thisMonth", 60, null, new Duration(false, 0, 1, 0));
        lastMonth = new BComplexTimeRange("lastMonth", 60, new Duration(true, 0, 1, 0), new Duration(false, 0, 1, 0));
        thisYear = new BComplexTimeRange("thisYear", 70, null, new Duration(false, 1, 0, 0));
        lastYear = new BComplexTimeRange("lastYear", 70, new Duration(true, 1, 0, 0), new Duration(false, 1, 0, 0));
        weekToDate = new BComplexTimeRange("weekToDate", 50, null, null);
        monthToDate = new BComplexTimeRange("monthToDate", 60, null, null);
        yearToDate = new BComplexTimeRange("yearToDate", 70, null, null);
        TYPE = Sys.loadType(BComplexTimeRange.class);
    }
}

