/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.data.BDataTable;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.util.BBinderCacheScheme;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.alert.AlertEntry;
import com.tridiumx.analytics.alert.BAnalyticAlert;
import com.tridiumx.analytics.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="alertNodes")
@NiagaraSingleton
public class BAlertNodesOrdScheme
extends BBinderCacheScheme {
    @Generated
    public static final BAlertNodesOrdScheme INSTANCE = new BAlertNodesOrdScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BAlertNodesOrdScheme.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BAlertNodesOrdScheme() {
        super("alertNodes");
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        try {
            if (Sys.isStation() && !BAnalyticService.getInstance().isSteady()) {
                return base;
            }
            BISession session = this.toSession(base);
            if (session instanceof BFoxSession) {
                return this.resolveFox((BFoxSession)session, base, query);
            }
            BAnalyticAlert alert = null;
            if (base.get() instanceof BAnalyticAlert) {
                alert = (BAnalyticAlert)base.get();
            } else if (base.getComponent() instanceof BAnalyticAlert) {
                alert = (BAnalyticAlert)base.getComponent();
            }
            ArrayList<AlertEntry> entries = null;
            entries = alert != null ? alert.getEntries((Context)base) : new ArrayList();
            Collections.sort(entries);
            BDataTable ret = new BDataTable();
            ret.addColumn("node", Utils.lex("node"), BOrd.DEFAULT.getType(), 0, BFacets.NULL);
            ret.addColumn("state", Utils.lex("state"), BBoolean.TRUE.toDataValue().getType(), 0, BFacets.makeBoolean((String)Utils.lex("alert"), (String)Utils.lex("normal")));
            ret.addColumn("cost", Utils.lex("cost"), BDouble.DEFAULT.toDataValue().getType(), 0, BFacets.makeNumeric((int)2));
            ret.startRows();
            for (AlertEntry e : entries) {
                ret.startRow();
                BINavNode node = e.getNode();
                ret.set((BIDataValue)Utils.getFriendlyName(node), BFacets.NULL);
                ret.set(BBoolean.make((boolean)e.isInAlert()).toDataValue(), BFacets.NULL);
                ret.set(BDouble.make((double)e.getTotalCost()).toDataValue(), BFacets.NULL);
                ret.endRow();
            }
            ret.endRows();
            return new OrdTarget(base, (BObject)ret);
        }
        catch (Exception x) {
            x.printStackTrace();
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
    }

    private OrdTarget resolveFox(BFoxSession session, OrdTarget base, OrdQuery query) throws Exception {
        BObject baseObject = base.get();
        BOrd ord = Utils.getNodeOrd((BINavNode)baseObject);
        ord = BOrd.make((BOrd)ord, (OrdQuery)query).normalize();
        ord = BOrd.make((String)(ord.toString(null) + "&remoteFox=true"));
        ord = BOrd.make((BOrd)BOrd.make((String)"station:"), (BOrd)ord);
        BFoxClientConnection conn = session.getConnection();
        BDataChannel channel = (BDataChannel)conn.getChannels().get("data");
        BObject res = channel.resolve(ord, new String[0]);
        return new OrdTarget(base, res);
    }

    private BISession toSession(OrdTarget baseTarget) {
        if (baseTarget == null) {
            throw new InvalidOrdBaseException("null");
        }
        BISession session = null;
        for (OrdTarget target = baseTarget; target != null && (session = BOrd.toSession((BObject)target.get())) == null; target = target.getBaseOrdTarget()) {
        }
        if (session != null) {
            return session;
        }
        throw new InvalidOrdBaseException("" + baseTarget.get());
    }
}

