/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.IntervalTrend;
import java.util.Collection;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.Interval;

public class AggregateTrend
extends AbstractTrend {
    protected static final int NULL_TS = -1;
    protected Combiner combiner;
    protected long timestamp = -1L;
    protected AnalyticTrend[] trends;
    protected AnalyticValue[] values;

    public AggregateTrend(Collection<AnalyticTrend> trends) {
        this(trends, null);
    }

    public AggregateTrend(Collection<AnalyticTrend> trends, Combiner combiner) {
        this.trends = trends.toArray(new AnalyticTrend[0]);
        this.combiner = combiner;
        this.init();
    }

    @Override
    public AnalyticContext getContext() {
        return this.trends[0].getContext();
    }

    @Override
    protected AnalyticValue getNext() {
        if (this.findNextTs() == -1L) {
            return null;
        }
        this.combiner.reset();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.combiner.update(this.values[i]);
        }
        return this.combiner.getValue();
    }

    protected long findNextTs() {
        long last = this.timestamp;
        long latest = -1L;
        boolean done = false;
        while (!done) {
            done = true;
            int len = this.trends.length;
            for (int i = 0; i < len; ++i) {
                AnalyticValue val = this.values[i];
                if (val == null) {
                    this.timestamp = -1L;
                    return -1L;
                }
                long cur = val.getTimestamp();
                if (latest == -1L) {
                    latest = cur;
                }
                AnalyticTrend trend = this.trends[i];
                while (cur == last || cur < latest) {
                    if (!trend.hasNext()) {
                        this.timestamp = -1L;
                        return -1L;
                    }
                    this.values[i] = val = trend.next();
                    cur = val.getTimestamp();
                }
                if (cur <= latest) continue;
                latest = cur;
                if (i <= 0) continue;
                done = false;
            }
        }
        this.timestamp = latest;
        return latest;
    }

    protected void init() {
        AnalyticTrend trend;
        int i;
        int length = this.trends.length;
        this.values = new AnalyticValue[length];
        Object ivl = null;
        for (i = 0; i < length; ++i) {
            trend = this.trends[i];
            Interval tivl = trend.getContext().getInterval(true);
            if (ivl == null) {
                ivl = tivl;
                continue;
            }
            if (tivl == null || tivl.getOrdinal() <= ivl.getOrdinal()) continue;
            ivl = tivl;
        }
        if (!ivl.equals(this.getContext().getInterval(true))) {
            AnalyticContextWrapper cx = new AnalyticContextWrapper(this.getContext());
            cx.setInterval((Interval)ivl);
            this.setContext(cx);
        }
        for (i = 0; i < length; ++i) {
            trend = this.trends[i];
            if (!ivl.equals(trend.getContext().getInterval(true))) {
                AnalyticContextWrapper cx = new AnalyticContextWrapper(trend.getContext());
                cx.setInterval((Interval)ivl);
                trend = new IntervalTrend(trend, cx);
            }
            if (!trend.hasNext()) continue;
            this.values[i] = trend.next();
            if (this.combiner != null) continue;
            this.combiner = this.getContext().getAggregation(true).makeCombiner();
        }
    }
}

