/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.data.UnitConverter;
import com.tridiumx.analytics.time.TimeZoneConverter;
import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import com.tridiumx.analytics.trend.EmptyTrend;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;

public class ExitTrend
extends AbstractTrendWrapper {
    private long endTime;
    private TimeZoneConverter tzConvert;
    private UnitConverter unitConvert;

    public ExitTrend(AnalyticTrend trend, AnalyticContext cx) {
        super(trend == null ? new EmptyTrend(cx) : trend);
        this.setContext(cx);
        this.init();
    }

    @Override
    protected AnalyticValue getNext() {
        if (!this.trend.hasNext()) {
            return null;
        }
        AnalyticValue next = this.trend.next();
        if (next == null) {
            return null;
        }
        long ts = next.getTimestamp();
        if (this.tzConvert != null) {
            ts = this.tzConvert.convert(ts);
            next.setTimestamp(ts);
        }
        if (ts >= this.endTime) {
            return null;
        }
        if (this.unitConvert != null) {
            double val = this.unitConvert.convert(next.toNumeric());
            if (next instanceof AnalyticNumeric) {
                ((AnalyticNumeric)next).setValue(val);
            } else {
                next.setValue(val);
            }
        }
        return next;
    }

    protected void init() {
        BUnit from;
        BUnit to;
        this.endTime = this.trend.getContext().getEndTime();
        if (this.endTime <= 0L) {
            this.endTime = this.getContext().getEndTime();
            if (this.endTime <= 0L) {
                this.endTime = System.currentTimeMillis();
            }
        }
        AnalyticContext inner = this.trend.getContext();
        AnalyticContext mine = this.getContext();
        if (this.cx.getNormalizeTime()) {
            this.tzConvert = TimeZoneConverter.make(inner.getTimeZone(), mine.getTimeZone());
            if (this.tzConvert != null) {
                this.endTime = this.tzConvert.convert(this.endTime);
            }
        }
        if ((to = UnitConverter.getConversionUnit(from = inner.getInnermostUnit(), mine.getUnit(false), mine)) != null) {
            this.unitConvert = UnitConverter.make(from, to);
            mine.setUnit(to);
        } else {
            mine.setUnit(from);
        }
    }
}

