/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryEventListener;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;

public class Histories {
    private static volatile BHistoryDatabase hdb;
    private static volatile HistoryDatabaseConnection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BHistoryDatabase getDb(AnalyticContext cx) {
        if (hdb != null) return hdb;
        Class<Histories> clazz = Histories.class;
        synchronized (Histories.class) {
            if (hdb != null) return hdb;
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase hdbLocal = service.getDatabase();
            hdbLocal.addHistoryEventListener((HistoryEventListener)new Listener());
            hdb = hdbLocal;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return hdb;
        }
    }

    public static HistoryDatabaseConnection getDbConnection(AnalyticContext cx) {
        if (conn == null) {
            Context baseCx = cx == null ? null : cx.getBase();
            conn = Histories.getDb(cx).getDbConnection(baseCx);
        }
        return conn;
    }

    public static BIHistory getHistory(BHistoryId id, AnalyticContext cx) {
        return Histories.getDbConnection(cx).getHistory(id);
    }

    private static class Listener
    implements HistoryEventListener {
        Listener() {
        }

        public void historyEvent(BHistoryEvent event) {
            if (event.getId() == 9) {
                hdb = null;
                conn = null;
            }
        }
    }
}

