/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.baja.sys.Clock;

public class KeyedCache<K, V> {
    private Map<K, Entry<K, V>> keys = new ConcurrentHashMap<K, Entry<K, V>>();
    private int maxCapacity = -1;
    private Queue<Entry<K, V>> expires = new ConcurrentLinkedQueue<Entry<K, V>>();

    public KeyedCache() {
    }

    public KeyedCache(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public synchronized void clear() {
        this.keys.clear();
        this.expires.clear();
    }

    public synchronized void clean() {
        while (this.expires.size() > 0) {
            Entry<K, V> e = this.expires.peek();
            if (!e.isValid()) {
                this.expires.poll();
                continue;
            }
            if (e.isExpired()) {
                this.keys.remove(e.key);
                this.expires.poll();
                continue;
            }
            if (this.maxCapacity > 0 && this.keys.size() > this.maxCapacity) {
                this.keys.remove(e.key);
                this.expires.poll();
                continue;
            }
            return;
        }
    }

    public synchronized V get(K key) {
        Entry<K, V> e = this.keys.get(key);
        if (e == null) {
            return null;
        }
        if (e.isExpired() || !e.isValid()) {
            return null;
        }
        return e.value;
    }

    public synchronized void put(K key, V value, long cacheNanos) {
        Entry<K, V> e = this.keys.get(key);
        if (e != null) {
            this.keys.remove(key);
            e.invalidate();
        }
        e = new Entry<K, V>(key, value, Clock.nanoTicks() + cacheNanos);
        this.keys.put(key, e);
        this.expires.add(e);
    }

    private class Entry<K, V> {
        K key;
        long expires;
        boolean valid = true;
        V value;

        public Entry(K key, V value, long expires) {
            this.key = key;
            this.value = value;
            this.expires = expires;
        }

        public void invalidate() {
            this.valid = false;
        }

        public boolean isExpired() {
            return this.expires <= Clock.nanoTicks();
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

