/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.baja.nre.util.TextUtil;

public class Strings {
    public static String concatUris(String base, String path) {
        if (path == null || path.length() == 0) {
            return base;
        }
        if (base.endsWith("/")) {
            if (path.startsWith("/")) {
                return base + path.substring(1);
            }
        } else if (!path.startsWith("/")) {
            return base + "/" + path;
        }
        return base + path;
    }

    public static Map<String, String> decodeQueryString(String query) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        boolean shouldDecode = false;
        String key = null;
        String value = null;
        String[] pairs = Strings.fields(query, '&');
        int len = pairs.length;
        for (int i = 0; i < len; ++i) {
            int idx = pairs[i].indexOf("=");
            shouldDecode = Strings.isDecodingRequired(pairs[i]);
            try {
                if (shouldDecode) {
                    key = URLDecoder.decode(pairs[i].substring(0, idx), "UTF-8");
                    value = URLDecoder.decode(pairs[i].substring(idx + 1), "UTF-8");
                } else {
                    key = pairs[i].substring(0, idx);
                    value = pairs[i].substring(idx + 1);
                }
                ret.put(key, value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String decodeCsvCell(String s) {
        if ((s = s.trim()).indexOf(34) < 0) {
            return s;
        }
        int len = s.length() - 1;
        if (len > 1) {
            if (s.charAt(0) == '\"' && s.charAt(len) == '\"') {
                s = s.substring(1, len);
            }
            s = TextUtil.replace((String)s, (String)"\"\"", (String)"\"");
        }
        return s;
    }

    public static ArrayList<String> decodeCsvRow(CharSequence row, ArrayList<String> cells) {
        int len;
        if (cells == null) {
            cells = new ArrayList();
        }
        if ((len = row.length()) == 0) {
            return cells;
        }
        boolean inquote = false;
        StringBuilder cell = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch == ',') {
                if (inquote) {
                    cell.append(ch);
                    continue;
                }
                cells.add(Strings.decodeCsvCell(cell.toString()));
                cell.setLength(0);
                continue;
            }
            if (ch == '\"') {
                inquote = !inquote;
                cell.append(ch);
                continue;
            }
            cell.append(ch);
        }
        cells.add(Strings.decodeCsvCell(cell.toString()));
        return cells;
    }

    public static String encodeCsvCell(String s) {
        return Strings.encodeCsvCell(s, false);
    }

    public static String encodeCsvCell(String s, boolean forceQuotes) {
        if (s.indexOf(34) >= 0) {
            int len = s.length();
            StringBuilder buf = new StringBuilder(len * 2);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    buf.append(c);
                }
                buf.append(c);
            }
            s = buf.toString();
        }
        if (forceQuotes) {
            s = '\"' + s + '\"';
        } else if (s.indexOf(44) >= 0) {
            if (!s.startsWith("\"")) {
                s = "\"" + s;
            }
            if (!s.endsWith("\"")) {
                s = s + "\"";
            }
        }
        return s;
    }

    public static String encodeCsvRow(ArrayList<String> row) {
        if (row == null) {
            return "";
        }
        int len = row.size();
        StringBuilder buf = new StringBuilder(len * 15);
        boolean comma = false;
        for (int i = 0; i < len; ++i) {
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            buf.append(Strings.encodeCsvCell(row.get(i)));
        }
        return buf.toString();
    }

    public static String encodeQueryString(Map<String, String> map) {
        StringBuilder buf = new StringBuilder();
        try {
            boolean first = true;
            for (Map.Entry<String, String> e : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append('&');
                }
                if (Strings.shouldEncode(e.getKey())) {
                    buf.append(URLEncoder.encode(e.getKey(), "UTF-8"));
                } else {
                    buf.append(e.getKey());
                }
                buf.append('=');
                if (Strings.shouldEncode(e.getValue())) {
                    if (!e.getKey().equalsIgnoreCase("dataFilter")) {
                        buf.append(URLEncoder.encode(e.getValue(), "UTF-8"));
                        continue;
                    }
                    buf.append(e.getValue());
                    continue;
                }
                buf.append(e.getValue());
            }
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        return buf.toString();
    }

    public static String[] fields(String row, char delim) {
        StringBuilder buf = new StringBuilder(100);
        int len = row.length();
        Vector<String> v = new Vector<String>(100);
        for (int i = 0; i < len; ++i) {
            char ch = row.charAt(i);
            if (ch == delim) {
                if (buf.length() <= 0) continue;
                v.addElement(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            v.addElement(buf.toString());
        }
        len = v.size();
        Object[] ret = new String[len];
        if (len == 0) {
            return ret;
        }
        v.copyInto(ret);
        return ret;
    }

    public static boolean isDecodingRequired(String query) {
        return query.contains("%3A") || query.contains("%3B");
    }

    private static boolean shouldEncode(String str) {
        int i = str.length();
        while (--i >= 0) {
            switch (str.charAt(i)) {
                case '&': 
                case '+': 
                case '=': 
                case '|': {
                    return true;
                }
            }
        }
        return false;
    }
}

