/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.AonWriter;
import com.tridiumx.analytics.ws.BNaServlet;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;

abstract class ApiMessage
implements Runnable {
    protected long created = System.currentTimeMillis();
    protected Context cx;
    protected Amap request;
    protected AtomicReference<Amap> response = new AtomicReference();
    protected boolean running = false;

    public ApiMessage(Amap request, Context cx) {
        this.request = request;
        this.cx = cx;
    }

    public Context getContext() {
        return this.cx;
    }

    public Amap getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Amap getResponse() {
        ApiMessage apiMessage = this;
        synchronized (apiMessage) {
            while (this.running && !this.isExpired()) {
                try {
                    this.wait(5000L);
                }
                catch (Exception exception) {}
            }
        }
        if (this.response.get() == null) {
            this.run();
        }
        return this.response.get();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.created > 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        ApiMessage apiMessage = this;
        synchronized (apiMessage) {
            if (this.running) {
                return false;
            }
            return this.response.get() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        ApiMessage apiMessage = this;
        // MONITORENTER : apiMessage
        if (this.running) {
            // MONITOREXIT : apiMessage
            return;
        }
        if (this.response.get() != null) {
            // MONITOREXIT : apiMessage
            return;
        }
        this.running = true;
        // MONITOREXIT : apiMessage
        try {
            Amap temporaryResponse = null;
            try {
                temporaryResponse = this.doGetResponse();
            }
            catch (NoSuchElementException x) {
                temporaryResponse = BNaServlet.makeError(this.request, "clientError", x.getMessage(), x);
            }
            catch (NullOrdException x) {
                temporaryResponse = BNaServlet.makeError(this.request, "invalidOrd", x.getMessage(), x);
            }
            catch (UnknownSchemeException x) {
                temporaryResponse = BNaServlet.makeError(this.request, "invalidOrd", x.getMessage(), x);
            }
            catch (SyntaxException x) {
                temporaryResponse = BNaServlet.makeError(this.request, "invalidOrd", x.getMessage(), x);
            }
            catch (UnresolvedException x) {
                temporaryResponse = BNaServlet.makeError(this.request, "invalidOrd", x.getMessage(), x);
            }
            catch (SecurityException x) {
                temporaryResponse = BNaServlet.makeError(this.request, "permissionError", x.getMessage(), x);
            }
            catch (Throwable x) {
                temporaryResponse = BNaServlet.makeError(this.request, "serverError", x.getMessage(), x);
            }
            finally {
                this.response.compareAndSet(null, temporaryResponse);
            }
            apiMessage = this;
        }
        catch (Throwable throwable) {
            ApiMessage apiMessage2 = this;
            // MONITORENTER : apiMessage2
            this.running = false;
            this.notifyAll();
            // MONITOREXIT : apiMessage2
            throw throwable;
        }
        this.running = false;
        this.notifyAll();
        // MONITOREXIT : apiMessage
    }

    public void writeResponse(AonWriter out) {
        out.write(this.getResponse());
    }

    protected Aobj getRequired(Amap map, String key) {
        Aobj ret = map.get(key);
        if (ret == null) {
            throw new NoSuchElementException("Missing required request parameter: " + key);
        }
        return ret;
    }

    protected String getRequiredString(Amap map, String key) {
        return this.getRequired(map, key).toString();
    }

    protected OrdTarget resolveForInvoke(String path) {
        OrdTarget ot = BOrd.make((String)path).resolve((BObject)Sys.getStation(), this.getContext());
        if (!ot.canRead()) {
            throw new SecurityException("Cannot invoke: " + path);
        }
        return ot;
    }

    protected OrdTarget resolveForRead(String path) {
        OrdTarget ot = BOrd.make((String)path).resolve((BObject)Sys.getStation(), this.getContext());
        if (!ot.canRead()) {
            throw new SecurityException("Cannot read: " + path);
        }
        return ot;
    }

    protected OrdTarget resolveForWrite(String path) {
        OrdTarget ot = BOrd.make((String)path).resolve((BObject)Sys.getStation(), this.getContext());
        if (!ot.canWrite()) {
            throw new SecurityException("Cannot write: " + path);
        }
        return ot;
    }

    protected abstract Amap doGetResponse();
}

