/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Alist;
import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.aon.Aon;
import com.tridiumx.analytics.aon.AonWriter;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.GenericMessage;
import com.tridiumx.analytics.ws.GetChildNodesMessage;
import com.tridiumx.analytics.ws.GetNodeMessage;
import com.tridiumx.analytics.ws.GetRollupMessage;
import com.tridiumx.analytics.ws.GetTrendBaselineMessage;
import com.tridiumx.analytics.ws.GetTrendMessage;
import com.tridiumx.analytics.ws.GetValueMessage;
import com.tridiumx.analytics.ws.InvokeMessage;
import com.tridiumx.analytics.ws.PollSubscriptionMessage;
import com.tridiumx.analytics.ws.QueryMessage;
import com.tridiumx.analytics.ws.SubscribeMessage;
import com.tridiumx.analytics.ws.UnsubscribeMessage;
import com.tridiumx.analytics.ws.UpdateAlarms;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="servletName", type="String", defaultValue="na", flags=1, override=true), @NiagaraProperty(name="debugUser", type="String", defaultValue=""), @NiagaraProperty(name="debugRequests", type="boolean", defaultValue="false")})
public class BNaServlet
extends BWebServlet {
    @Generated
    public static final Property servletName = BNaServlet.newProperty((int)1, (String)"na", null);
    @Generated
    public static final Property debugUser = BNaServlet.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property debugRequests = BNaServlet.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNaServlet.class);
    private static boolean checkGzip = true;
    private static BWebService webService;
    private static final List<Pattern> includedCorsOrigins;
    private static final String WILDCARD = "*";

    @Generated
    public String getDebugUser() {
        return this.getString(debugUser);
    }

    @Generated
    public void setDebugUser(String v) {
        this.setString(debugUser, v, null);
    }

    @Generated
    public boolean getDebugRequests() {
        return this.getBoolean(debugRequests);
    }

    @Generated
    public void setDebugRequests(boolean v) {
        this.setBoolean(debugRequests, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doGet(WebOp op) throws Exception {
        Amap json = Aon.read(op.getRequest().getParameter("json")).toMap();
        this.process(op, json);
    }

    public void doPost(WebOp op) throws Exception {
        Amap json = Aon.read(op.getRequest().getReader()).toMap();
        this.process(op, json);
    }

    public void service(WebOp op) throws Exception {
        String method = op.getRequest().getMethod();
        switch (method.charAt(0)) {
            case 'O': 
            case 'o': {
                if (!method.equalsIgnoreCase("OPTIONS")) break;
                this.doOptions(op);
                return;
            }
        }
        super.service(op);
    }

    public void started() throws Exception {
        try {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.started();
    }

    protected void doOptions(WebOp op) throws Exception {
        this.enableCors(op);
        HttpServletResponse res = op.getResponse();
        res.setStatus(200);
        res.setContentLength(0);
        res.getWriter().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ApiMessage> getMethods(List<ApiMessage> queue, Alist methods, WebOp op) {
        Amap map = null;
        Iterator<Aobj> it = methods.iterator();
        while (it.hasNext()) {
            ApiMessage apiMethod = null;
            map = (Amap)it.next();
            String method = map.get("message", "");
            if (method.length() == 0) continue;
            try {
                block2 : switch (method.charAt(0)) {
                    case 'G': {
                        switch (method) {
                            case "GetNode": {
                                apiMethod = new GetNodeMessage(map, (Context)op);
                                break block2;
                            }
                            case "GetChildNodes": {
                                apiMethod = new GetChildNodesMessage(map, (Context)op);
                                break block2;
                            }
                            case "GetValue": {
                                apiMethod = new GetValueMessage(map, (Context)op);
                                break block2;
                            }
                            case "GetRollup": {
                                apiMethod = new GetRollupMessage(map, (Context)op);
                                break block2;
                            }
                            case "GetTrend": {
                                apiMethod = new GetTrendMessage(map, (Context)op);
                                break block2;
                            }
                            case "GetBaselineTrend": {
                                apiMethod = new GetTrendBaselineMessage(map, (Context)op);
                                break block2;
                            }
                        }
                        break;
                    }
                    case 'I': {
                        if (!method.equals("Invoke")) break;
                        apiMethod = new InvokeMessage(map, (Context)op);
                        break;
                    }
                    case 'P': {
                        if (!method.equals("PollSubscription")) break;
                        apiMethod = new PollSubscriptionMessage(map, (Context)op);
                        break;
                    }
                    case 'Q': {
                        if (!method.equals("Query")) break;
                        apiMethod = new QueryMessage(map, (Context)op);
                        break;
                    }
                    case 'S': {
                        if (!method.equals("Subscribe")) break;
                        apiMethod = new SubscribeMessage(map, (Context)op);
                        break;
                    }
                    case 'U': {
                        switch (method) {
                            case "UpdateAlarms": {
                                apiMethod = new UpdateAlarms(map, (Context)op);
                                break block2;
                            }
                            case "Unsubscribe": {
                                apiMethod = new UnsubscribeMessage(map, (Context)op);
                                break block2;
                            }
                        }
                        break;
                    }
                    default: {
                        apiMethod = new GenericMessage(map, map, (Context)op);
                        BNaServlet.makeError(map, "clientError", "Unknown method: " + method, null);
                    }
                }
                if (apiMethod == null) continue;
                queue.add(apiMethod);
            }
            catch (Throwable x) {
                try {
                    apiMethod = new GenericMessage(map, map, (Context)op);
                    BNaServlet.makeError(map, "serverError", x.getMessage(), x);
                    if (apiMethod == null) continue;
                    queue.add(apiMethod);
                }
                catch (Throwable throwable) {
                    if (apiMethod != null) {
                        queue.add(apiMethod);
                    }
                    throw throwable;
                }
            }
        }
        return queue;
    }

    static Amap makeError(String id, String msg, Throwable ex) {
        Amap ret = Aon.makeMap();
        if (id != null) {
            ret.put("id", id);
        }
        if (msg != null) {
            ret.put("display", msg);
        }
        if (ex != null) {
            // empty if block
        }
        return ret;
    }

    static Amap makeError(Amap map, String id, String msg, Throwable ex) {
        map.put("error", BNaServlet.makeError(id, msg, ex));
        return map;
    }

    void process(WebOp op, Amap request) throws Exception {
        this.enableCors(op);
        this.preventCaching(op);
        this.checkGzip(op);
        if (this.debugRequests((Context)op)) {
            Aon.makeWriter(System.out).write(request);
        }
        AonWriter out = Aon.makeWriter(op.getWriter());
        if (request.get("minify", false)) {
            out.setMinify(true);
        }
        out.println("{ \"responses\" : [");
        out.flush();
        try {
            Alist requests = request.getList("requests");
            if (requests != null) {
                boolean first = true;
                ArrayList<ApiMessage> methods = new ArrayList<ApiMessage>(requests.size());
                this.getMethods(methods, requests, op);
                for (ApiMessage method : methods) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(",");
                    }
                    method.writeResponse(out);
                }
            }
        }
        catch (Exception x) {
            out.write(BNaServlet.makeError(request, "serverError", x.getMessage(), x));
        }
        out.println("]}");
        out.flush();
    }

    private void checkGzip(WebOp op) {
        if (!checkGzip) {
            return;
        }
        if (webService == null) {
            webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        }
        if (webService != null) {
            // empty if block
        }
    }

    private boolean debugRequests(Context cx) {
        if (!this.getDebugRequests()) {
            return false;
        }
        return this.isDebugUser(cx);
    }

    private void enableCors(WebOp op) throws Exception {
        HttpServletRequest req = op.getRequest();
        String value = req.getHeader("origin");
        if (value == null || value.length() == 0) {
            return;
        }
        if (!BNaServlet.matchesAny(value, includedCorsOrigins)) {
            return;
        }
        HttpServletResponse res = op.getResponse();
        value = TextUtil.replace((String)TextUtil.replace((String)value, (String)"\n", (String)"\\n"), (String)"\r", (String)"\\r");
        res.setHeader("Access-Control-Allow-Origin", value);
        res.setHeader("Access-Control-Allow-Credentials", "true");
        res.setHeader("Access-Control-Max-Age", "604800");
        value = req.getHeader("access-control-request-headers");
        if (value != null) {
            value = TextUtil.replace((String)TextUtil.replace((String)value, (String)"\n", (String)"\\n"), (String)"\r", (String)"\\r");
            res.addHeader("Access-Control-Allow-Headers", value);
        }
        if ((value = req.getHeader("access-control-request-methods")) != null) {
            value = TextUtil.replace((String)TextUtil.replace((String)value, (String)"\n", (String)"\\n"), (String)"\r", (String)"\\r");
            res.addHeader("Access-Control-Allow-Methods", value);
        }
    }

    private static boolean matchesAny(String identifier, List<Pattern> origins) {
        for (Pattern origin : origins) {
            if (origin.pattern().isEmpty() || !origin.matcher(identifier).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> getIncludedCorsOrigins() {
        String origins = AccessController.doPrivileged(() -> System.getProperty("niagara.analytics.enableCrossOriginAccessToOrigins", "")).trim();
        return Collections.unmodifiableList(BNaServlet.makeOriginsList(origins));
    }

    private static List<Pattern> makeOriginsList(String origins) {
        ArrayList<Pattern> originsList = new ArrayList<Pattern>();
        for (String originString : origins.split(",")) {
            String trimmed = originString.trim();
            if (trimmed.isEmpty()) continue;
            if (trimmed.equals(WILDCARD)) {
                trimmed = ".*";
            }
            originsList.add(Pattern.compile(trimmed));
        }
        originsList.trimToSize();
        return originsList;
    }

    private boolean isDebugUser(Context cx) {
        String du = this.getDebugUser();
        if (du.length() == 0) {
            return true;
        }
        try {
            return du.equals(cx.getUser().getUsername());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void preventCaching(WebOp op) {
        HttpServletResponse res = op.getResponse();
        long time = System.currentTimeMillis();
        res.setDateHeader("Last-Modified", time);
        res.setDateHeader("Expires", time);
        res.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        res.setHeader("Pragma", "no-cache");
    }

    static {
        includedCorsOrigins = BNaServlet.getIncludedCorsOrigins();
    }
}

