/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.Analytics;
import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Aobj;
import com.tridiumx.analytics.trend.MergeTrend;
import com.tridiumx.analytics.util.Utils;
import com.tridiumx.analytics.util.WrapperException;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.Encoder;
import com.tridiumx.analytics.ws.WsAnalyticsContext;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Context;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.BAbsStartEndTime;
import javax.bajax.analytics.time.BAnalyticTimeRange;

public class GetTrendBaselineMessage
extends ApiMessage {
    public GetTrendBaselineMessage(Amap request, Context cx) {
        super(request, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Amap doGetResponse() {
        Amap map = this.getRequest();
        Amap baselineMap = map.copy().toMap();
        String path = this.getRequiredString(map, "node");
        this.getRequiredString(map, "data");
        this.resolveForRead(path);
        WsAnalyticsContext cx = new WsAnalyticsContext(map, this.getContext());
        AnalyticTrend trend = Analytics.getTrend(cx);
        String timeRangeName = baselineMap.get("timerange") != null ? "timerange" : "timeRange";
        boolean isBaselineAvailable = false;
        if (baselineMap.get("baselinetimerange") != null) {
            String baselineTimeRange = this.getBaselineTimeRange(map.get(timeRangeName), map.get("baselinetimerange").toString(), map.get("alignDow"));
            baselineMap.put(timeRangeName, baselineTimeRange);
            isBaselineAvailable = true;
        } else if (baselineMap.get("baselineTimeRange") != null) {
            String baselineTimeRange = this.getBaselineTimeRange(map.get(timeRangeName), map.get("baselineTimeRange").toString(), map.get("alignDow"));
            baselineMap.put(timeRangeName, baselineTimeRange);
            isBaselineAvailable = true;
        }
        AnalyticTrend merged = trend;
        if (isBaselineAvailable) {
            WsAnalyticsContext cx2 = new WsAnalyticsContext(baselineMap, this.getContext());
            cx2.setIsBaseline(BBoolean.TRUE);
            AnalyticTrend trend2 = Analytics.getTrend(cx2);
            merged = new MergeTrend(trend, trend2, cx2);
        }
        try {
            Encoder.encodeTrend(merged, cx, map);
        }
        catch (Exception x) {
            Encoder.encodeUnit(cx, map);
            WrapperException.throwRuntime(x);
        }
        finally {
            if (trend != null) {
                trend.close();
            }
        }
        return map;
    }

    private String getBaselineTimeRange(Aobj timeRange, String baselineTimeRange, Aobj alignDow) {
        String timeRangeVal = timeRange == null ? "today" : timeRange.toString();
        BAnalyticTimeRange analyticTimeRange = BAnalyticTimeRange.make(timeRangeVal);
        BAbsTime startTime = BAbsTime.make((long)analyticTimeRange.getStart());
        BAbsTime endTime = BAbsTime.make((long)analyticTimeRange.getEnd());
        boolean isAlignDow = alignDow != null && alignDow.toString().equals("true");
        switch (baselineTimeRange) {
            case "oneWeekPrior": {
                BAbsStartEndTime baselineStartEndTime = Utils.evaluatePrevWeekRange(startTime, endTime);
                return BAnalyticTimeRange.make(baselineStartEndTime.getStartTime(), baselineStartEndTime.getEndTime()).encodeToString();
            }
            case "oneMonthPrior": {
                BAbsStartEndTime baselineStartEndTime = Utils.evaluatePrevMonthRange(startTime, endTime, isAlignDow);
                return BAnalyticTimeRange.make(baselineStartEndTime.getStartTime(), baselineStartEndTime.getEndTime()).encodeToString();
            }
            case "oneYearPrior": {
                BAbsStartEndTime baselineStartEndTime = Utils.evaluatePrevYearRange(startTime, endTime, isAlignDow);
                return BAnalyticTimeRange.make(baselineStartEndTime.getStartTime(), baselineStartEndTime.getEndTime()).encodeToString();
            }
        }
        return baselineTimeRange;
    }
}

