/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.BNaServlet;
import com.tridiumx.analytics.ws.Encoder;
import com.tridiumx.analytics.ws.WsAnalyticsContext;
import com.tridiumx.analytics.ws.WsSubscription;
import java.util.NoSuchElementException;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.bajax.analytics.AnalyticContext;

abstract class SubscriptionElement {
    private boolean hasUpdate;
    private Object lastValue;
    private long nextUpdate;
    private Amap request;
    private WsSubscription subscription;
    private WsAnalyticsContext wsContext;

    public SubscriptionElement(WsSubscription sub, Amap request, Context context) {
        this.subscription = sub;
        this.request = request;
        this.wsContext = new WsAnalyticsContext(request, context);
        this.hasUpdate = true;
    }

    public AnalyticContext getAnalyticsContext() {
        return this.wsContext;
    }

    public Amap getResult(ApiMessage message) {
        Amap ret = this.request.copy().toMap();
        try {
            if (!message.getContext().getUser().equals((Object)this.wsContext.getUser())) {
                throw new SecurityException();
            }
            String path = message.getRequiredString(ret, "node");
            message.getRequiredString(ret, "data");
            message.resolveForRead(path);
            this.lastValue = this.doGetResult(this.wsContext);
            if (this.lastValue instanceof BComplex) {
                this.lastValue = ((BComplex)this.lastValue).newCopy(true);
            }
            Encoder.encodeValue(this.lastValue, this.wsContext, ret);
            this.hasUpdate = false;
        }
        catch (NoSuchElementException x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "clientError", x.getMessage(), x);
        }
        catch (NullOrdException x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "invalidOrd", x.getMessage(), x);
        }
        catch (UnknownSchemeException x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "invalidOrd", x.getMessage(), x);
        }
        catch (SyntaxException x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "invalidOrd", x.getMessage(), x);
        }
        catch (UnresolvedException x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "invalidOrd", x.getMessage(), x);
        }
        catch (SecurityException x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "permissionError", x.getMessage(), x);
        }
        catch (Throwable x) {
            this.lastValue = x;
            BNaServlet.makeError(ret, "serverError", x.getMessage(), x);
        }
        return ret;
    }

    protected abstract Object doGetResult(WsAnalyticsContext var1) throws Exception;

    protected void update() {
        if (this.hasUpdate) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextUpdate) {
            return;
        }
        try {
            Object newValue = this.doGetResult(this.wsContext);
            if (this.lastValue == null) {
                this.hasUpdate = true;
            } else if (this.lastValue instanceof BObject && newValue instanceof BObject) {
                BObject last = (BObject)this.lastValue;
                if (!last.equivalent(newValue)) {
                    this.hasUpdate = true;
                }
            } else if (!this.lastValue.equals(newValue)) {
                this.hasUpdate = true;
            }
        }
        catch (Exception x) {
            this.nextUpdate = now + 30000L;
            boolean bl = this.hasUpdate = !(this.lastValue instanceof Exception);
        }
        if (this.hasUpdate) {
            this.subscription.addUpdate(this);
        }
    }
}

