/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.aon.Alist;
import com.tridiumx.analytics.aon.Amap;
import com.tridiumx.analytics.aon.Atypes;
import com.tridiumx.analytics.util.Alarms;
import com.tridiumx.analytics.ws.ApiMessage;
import com.tridiumx.analytics.ws.BNaServlet;
import com.tridiumx.analytics.ws.Encoder;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.user.BUser;

class UpdateAlarms
extends ApiMessage
implements Atypes {
    public UpdateAlarms(Amap request, Context cx) {
        super(request, cx);
    }

    @Override
    protected Amap doGetResponse() {
        BAlarmService svc = Alarms.svc();
        Amap res = this.getRequest().copy().toMap();
        Alist alarms = res.getList("alarms");
        if (alarms == null) {
            return res;
        }
        int len = alarms.size();
        for (int i = 0; i < len; ++i) {
            BAlarmRecord rec;
            Amap alarm;
            block14: {
                alarm = alarms.getMap(i);
                String uuid = alarm.getString("uuid");
                if (uuid == null) continue;
                rec = null;
                try {
                    rec = Alarms.getAlarm(uuid);
                }
                catch (Exception x) {
                    BNaServlet.makeError(alarm, "clientError", "Unknown alarm UUID: " + uuid, x);
                    continue;
                }
                if (rec == null) {
                    BNaServlet.makeError(alarm, "clientError", "Unknown alarm UUID: " + uuid, null);
                    continue;
                }
                try {
                    BAlarmClass clz = svc.lookupAlarmClass(rec.getAlarmClass());
                    if (clz == null) break block14;
                    Property prop = clz.getPropertyInParent();
                    BUser user = this.cx.getUser();
                    if (user == null) break block14;
                    user.checkWrite((BComponent)svc, (Slot)prop);
                }
                catch (Exception x) {
                    BNaServlet.makeError(alarm, "permissionError", "Cannot modify alarm", null);
                    continue;
                }
            }
            String note = alarm.getString("note");
            if (note != null) {
                alarm.remove("note");
                BFacets ad = rec.getAlarmData();
                StringBuilder buf = new StringBuilder();
                buf.append("## ");
                buf.append(Clock.time().toString(null));
                try {
                    buf.append(" - ").append(this.cx.getUser().getUsername());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                buf.append(" ##\n");
                buf.append(note);
                String existing = ad.gets("notes", null);
                if (existing != null) {
                    buf.append("\n\n").append(existing);
                }
                note = buf.toString();
                ad = BFacets.make((BFacets)ad, (String)"notes", (BIDataValue)BString.make((String)note));
                rec.setAlarmData(ad);
                Alarms.save(rec);
            }
            if (alarm.get("acknowledge", false)) {
                try {
                    Alarms.ackAlarm(rec, this.cx);
                    Alarms.save(rec);
                }
                catch (Exception e) {
                    BNaServlet.makeError(alarm, "serverError", "Problem acknowledging alarm", e);
                    continue;
                }
            }
            alarm.remove("acknowledge");
            Encoder.encodeAlarm(rec, alarm, this.cx);
        }
        return res;
    }
}

