/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ws;

import com.tridiumx.analytics.ws.SubscriptionElement;
import com.tridiumx.analytics.ws.WsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class WsSubscription {
    private static IdentityHashMap<WsSubscription, WsSubscription> allSubscriptions = new IdentityHashMap();
    private long lastPoll = System.currentTimeMillis();
    private Map<String, SubscriptionElement> myElements = new TreeMap<String, SubscriptionElement>();
    private String name;
    private WsSession session;
    private IdentityHashMap<SubscriptionElement, SubscriptionElement> updates = new IdentityHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsSubscription(String name, WsSession session) {
        this.name = name;
        this.session = session;
        IdentityHashMap<WsSubscription, WsSubscription> identityHashMap = allSubscriptions;
        synchronized (identityHashMap) {
            allSubscriptions.put(this, this);
        }
    }

    public synchronized void addUpdate(SubscriptionElement elem) {
        if (this.updates == null) {
            this.updates = new IdentityHashMap();
        }
        this.updates.put(elem, elem);
    }

    public synchronized Collection<SubscriptionElement> getUpdates() {
        Set<SubscriptionElement> ret = this.updates.keySet();
        this.updates = null;
        return ret;
    }

    public synchronized boolean hasUpdates() {
        this.lastPoll = System.currentTimeMillis();
        if (this.updates == null) {
            return false;
        }
        return this.updates.size() > 0;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastPoll > 120000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putElement(String id, SubscriptionElement msg) {
        this.lastPoll = System.currentTimeMillis();
        SubscriptionElement tmp = null;
        Map<String, SubscriptionElement> map = this.myElements;
        synchronized (map) {
            tmp = this.myElements.get(id);
            if (tmp == null) {
                this.myElements.put(id, msg);
            } else {
                msg = tmp;
            }
        }
        this.addUpdate(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(String id) {
        Map<String, SubscriptionElement> map = this.myElements;
        synchronized (map) {
            this.myElements.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getElements(List<SubscriptionElement> list) {
        Map<String, SubscriptionElement> map = this.myElements;
        synchronized (map) {
            list.addAll(this.myElements.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = allSubscriptions;
        synchronized (object) {
            allSubscriptions.remove(this);
        }
        object = this.session;
        synchronized (object) {
            this.session.removeSubscription(this.name);
        }
    }

    static {
        new SubscriptionPoller().start();
    }

    static class SubscriptionPoller
    extends Thread {
        public SubscriptionPoller() {
            super("NAF Subscription Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList subscriptions = new ArrayList();
            ArrayList<SubscriptionElement> elements = new ArrayList<SubscriptionElement>();
            while (true) {
                long time = System.currentTimeMillis();
                IdentityHashMap identityHashMap = allSubscriptions;
                synchronized (identityHashMap) {
                    subscriptions.addAll(allSubscriptions.keySet());
                }
                int i = subscriptions.size();
                while (--i >= 0) {
                    WsSubscription sub = (WsSubscription)subscriptions.get(i);
                    if (sub.isExpired()) {
                        sub.destroy();
                    } else {
                        sub.getElements(elements);
                        int j = elements.size();
                        while (--j >= 0) {
                            SubscriptionElement elem = elements.get(j);
                            elem.update();
                        }
                    }
                    Thread.yield();
                }
                subscriptions.clear();
                elements.clear();
                time = System.currentTimeMillis() - time;
                time = 1000L - time;
                time = Math.max(time, 250L);
                try {
                    Thread.sleep(time);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

