/*
 * Decompiled with CFR 0.152.
 */
package javax.bajax.analytics;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import java.util.Map;
import javax.baja.sys.BDouble;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.data.Combination;
import javax.bajax.analytics.data.Combiner;
import javax.bajax.analytics.time.BInterval;

public class DegreeDayAnalyticContext
extends AnalyticContext {
    private BDouble baseTemp;
    private BUnit baseTempUnit;

    private DegreeDayAnalyticContext(Context base) {
        super(base);
    }

    @Override
    public BUnit getUnit(boolean force) {
        if (this.unit != null) {
            return this.unit;
        }
        if (!force) {
            return null;
        }
        BUnit ret = this.getBaseTempUnit();
        if (ret != null) {
            return ret;
        }
        return BUnit.NULL;
    }

    @Override
    public Combination getRollup(boolean force) {
        return this.rollup;
    }

    @Override
    public Combination getAggregation(boolean force) {
        return BCombination.avg;
    }

    public BDouble getBaseTemp() {
        return this.baseTemp;
    }

    public DegreeDayAnalyticContext setBaseTemp(BDouble baseTemp) {
        this.baseTemp = baseTemp;
        return this;
    }

    public BUnit getBaseTempUnit() {
        if (this.baseTempUnit != null && !this.baseTempUnit.isNull()) {
            return this.baseTempUnit;
        }
        if (this.getDataPolicy().getFacets() != null) {
            return (BUnit)this.getDataPolicy().getFacets().get("units");
        }
        return null;
    }

    public DegreeDayAnalyticContext setBaseTempUnit(BUnit baseTempUnit) {
        this.baseTempUnit = baseTempUnit;
        return this;
    }

    @Override
    public BUnit getInnermostUnit() {
        return null;
    }

    @Override
    public AnalyticContext newCopy() {
        return new DegreeDayAnalyticContext((Context)new BasicContext(this.getUser())).setBaseTemp(this.getBaseTemp()).setBaseTempUnit(this.getBaseTempUnit()).setAggregation(this.getAggregation(true)).setData(this.getData()).setDataFilter(this.getDataFilter()).setLeadingDeltas(this.getLeadingDeltas()).setInterval(this.getInterval(true)).setNode(this.getNode()).setRollup(this.getRollup(true)).setTimeRange(this.getTimeRange(true)).setTimeZone(this.getTimeZone()).setNormalizeTime(this.getNormalizeTime()).setUnit(this.getUnit(false)).setUseCache(this.getUseCache()).setDowInclusion(this.getDowInclusion().encodeToString()).setSeriesName(this.seriesName).setHistory(this.getHistory().getBoolean()).setHisTotEnabled(this.getHisTotEnabled());
    }

    public static class DegreeDayAnalyticContextWrapper
    extends AnalyticContextWrapper {
        private DegreeDayAnalyticContextWrapper(DegreeDayAnalyticContext arg) {
            super(arg);
        }

        public static DegreeDayAnalyticContextWrapper make(Map<String, String> args, Context base) {
            DegreeDayAnalyticContext inner = (DegreeDayAnalyticContext)AnalyticContext.updateAnalyticContext(args, new DegreeDayAnalyticContext(base));
            String str = args.get("baseTemp");
            if (str != null) {
                inner.setBaseTemp(BDouble.make((String)str));
            } else {
                inner.setBaseTemp(BDouble.DEFAULT);
            }
            str = args.get("baseTempUnit");
            if (str != null) {
                inner.setBaseTempUnit(BUnit.getUnit((String)str));
            }
            str = args.get("degreeDay");
            DegreeDay degreeDay = DegreeDay.DEFAULT;
            if (str != null) {
                degreeDay = DegreeDay.DEFAULT.getByTag(str);
            }
            DegreeDayAnalyticContextWrapper wrapper = new DegreeDayAnalyticContextWrapper(inner);
            wrapper.setInterval(BInterval.day);
            wrapper.setRollup(new DegreeDayCombination(inner.getBaseTemp().getDouble(), degreeDay));
            wrapper.setUnit(null);
            inner.setRollup(BCombination.sum);
            if (inner.getInterval(true).getOrdinal() < wrapper.getInterval(true).getOrdinal()) {
                inner.setInterval(BInterval.day);
            }
            return wrapper;
        }

        public BDouble getBaseTemp() {
            return ((DegreeDayAnalyticContext)this.getInner()).getBaseTemp();
        }

        public BUnit getBaseTempUnit() {
            BUnit baseTempUnit = ((DegreeDayAnalyticContext)this.getInner()).getBaseTempUnit();
            if (baseTempUnit != null && !baseTempUnit.isNull()) {
                return baseTempUnit;
            }
            if (this.getDataPolicy().getFacets() != null) {
                return (BUnit)this.getDataPolicy().getFacets().get("units");
            }
            return null;
        }

        @Override
        public Combination getRollup(boolean force) {
            return this.rollup;
        }

        @Override
        public BUnit getUnit(boolean force) {
            if (this.unit != null) {
                return this.unit;
            }
            if (!force) {
                return null;
            }
            BUnit ret = this.getBaseTempUnit();
            if (ret != null) {
                return ret;
            }
            return BUnit.NULL;
        }

        @Override
        public Combination getAggregation(boolean force) {
            return BCombination.avg;
        }

        @Override
        public AnalyticContext newCopy() {
            return new DegreeDayAnalyticContext((Context)new BasicContext(this.getUser())).setBaseTemp(this.getBaseTemp()).setBaseTempUnit(this.getBaseTempUnit()).setAggregation(this.getAggregation(true)).setData(this.getData()).setDataFilter(this.getDataFilter()).setLeadingDeltas(this.getLeadingDeltas()).setInterval(this.getInterval(true)).setNode(this.getNode()).setRollup(this.getRollup(true)).setTimeRange(this.getTimeRange(true)).setTimeZone(this.getTimeZone()).setNormalizeTime(this.getNormalizeTime()).setUnit(this.getUnit(false)).setUseCache(this.getUseCache()).setDowInclusion(this.getDowInclusion().encodeToString()).setSeriesName(this.seriesName).setHistory(this.getHistory().getBoolean()).setHisTotEnabled(this.getHisTotEnabled());
        }
    }

    private static final class DegreeDayCombiner
    extends AbstractCombiner {
        private NumericValue analytic = new NumericValue();
        private double value = 0.0;
        private double baseTemp;
        private DegreeDay degreeDay;

        protected DegreeDayCombiner(double baseTemp, DegreeDay degreeDay) {
            super(degreeDay.ordinal);
            this.baseTemp = baseTemp;
            this.degreeDay = degreeDay;
        }

        public DegreeDay getDegreeDay() {
            return this.degreeDay;
        }

        @Override
        protected void doReset() {
            this.value = 0.0;
        }

        @Override
        protected boolean doUpdate(AnalyticValue arg) {
            double tempValue = arg.toNumeric();
            switch (this.degreeDay) {
                case HEATING: {
                    if (tempValue < this.baseTemp) {
                        tempValue = Math.abs(arg.toNumeric() - this.baseTemp);
                        break;
                    }
                    return false;
                }
                case COOLING: {
                    if (tempValue > this.baseTemp) {
                        tempValue = Math.abs(arg.toNumeric() - this.baseTemp);
                        break;
                    }
                    return false;
                }
            }
            if (this.getCount() == 0) {
                this.value = tempValue;
                this.analytic.copyTimestamp(arg);
                this.analytic.copyStatus(arg);
            } else {
                this.value += tempValue;
                this.analytic.copyTimestamp(arg);
                this.analytic.orStatus(arg);
            }
            return true;
        }

        @Override
        public AnalyticValue getValue() {
            double avg = 0.0;
            int count = this.getCount();
            if (count != 0) {
                avg = this.value / (double)count;
            }
            this.analytic.setValue(avg);
            return this.analytic;
        }
    }

    private static final class DegreeDayCombination
    implements Combination {
        private DegreeDayCombiner degreeDayCombiner;

        public DegreeDayCombination(double baseTemp, DegreeDay degreeDay) {
            this.degreeDayCombiner = new DegreeDayCombiner(baseTemp, degreeDay);
        }

        @Override
        public int getOrdinal() {
            return this.degreeDayCombiner.getDegreeDay().getOrdinal();
        }

        @Override
        public String getTag() {
            return this.degreeDayCombiner.getDegreeDay().getTag();
        }

        @Override
        public Combiner makeCombiner() {
            return this.degreeDayCombiner;
        }
    }

    private static enum DegreeDay {
        HEATING(15, "heating"),
        COOLING(16, "cooling");

        private int ordinal;
        private String tag;
        public static final DegreeDay DEFAULT;

        private DegreeDay(int ordinal, String tag) {
            this.ordinal = ordinal;
            this.tag = tag;
        }

        public DegreeDay getByTag(String tag) {
            switch (tag) {
                case "heating": {
                    return HEATING;
                }
                case "cooling": {
                    return COOLING;
                }
            }
            return DEFAULT;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String getTag() {
            return this.tag;
        }

        static {
            DEFAULT = HEATING;
        }
    }
}

