/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platCcn;

public class CcnResponseBuffer {
    private final byte requestStatus;
    private final byte responseCommand;
    private final short responseDataLength;
    private final byte[] responseData;

    public CcnResponseBuffer(byte newRequestStatus, byte newResponseCommand, byte newResponseLen, byte[] newResponseData) {
        this.requestStatus = newRequestStatus;
        this.responseCommand = newResponseCommand;
        this.responseDataLength = (short)(newResponseLen & 0xFF);
        this.responseData = new byte[this.responseDataLength];
        if (newResponseData != null) {
            System.arraycopy(newResponseData, 0, this.responseData, 0, this.responseDataLength);
        }
    }

    public boolean isValidResponse() {
        return this.responseDataLength > 0;
    }

    public byte getRequestStatus() {
        return this.requestStatus;
    }

    public byte getResponseCommand() {
        return this.responseCommand;
    }

    public short getResponseDataLength() {
        return this.responseDataLength;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    private static String get2DigHexString(int val) {
        String hex = "00" + Integer.toHexString(val);
        return hex.substring(hex.length() - 2);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        if (this.responseCommand == 6) {
            ret.append("stat=00,");
        } else if (this.responseCommand == 21 && this.responseData.length > 0) {
            ret.append("stat=").append(CcnResponseBuffer.get2DigHexString(this.responseData[0] & 0xFF)).append(",");
        } else {
            ret.append("stat=ff,");
        }
        ret.append("cmd=0x").append(CcnResponseBuffer.get2DigHexString(this.responseCommand & 0xFF)).append(",");
        ret.append("dataLen=").append(this.responseDataLength & 0xFFFF).append(",");
        ret.append("dataHex={");
        for (int i = 0; i < this.responseDataLength; ++i) {
            ret.append(CcnResponseBuffer.get2DigHexString(this.responseData[i] & 0xFF));
            if (i >= this.responseDataLength - 1) continue;
            ret.append(" ");
        }
        ret.append("}");
        ret.append("]");
        return ret.toString();
    }
}

