/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.ui.point;

import com.tridium.ndriver.ui.NMgrUtil;
import com.tridium.workbench.util.WbViewEventWorker;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import com.tridiumemea.micros.ui.point.BMicrosPointManager;
import com.tridiumemea.micros.ui.point.MicrosPointManagerNewDialog;
import com.tridiumemea.micros.ui.point.MicrosPointManagerSyncDialog;
import java.util.logging.Level;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;

final class MicrosPointManagerController
extends PointController {
    private final DbSyncCommand dbSync;
    private final JobSummaryCommand jobSummary;
    private final BMicrosPointManager mgr;
    private BMicrosNetwork network;
    private static final Lexicon lex = BMicrosPointManager.lex;
    private static final String NO_NETWORK = lex.get("pmc.noNetwork");
    private static final String DB_SYNC_ARE_YOU_SURE = lex.getText("pmc.dbSync.areYouSure");

    MicrosPointManagerController(BMicrosPointManager mgr) {
        super((BPointManager)mgr);
        this.mgr = mgr;
        this.network = (BMicrosNetwork)NMgrUtil.findNNetwork((BAbstractManager)mgr);
        this.jobSummary = new JobSummaryCommand((BWidget)mgr);
        this.jobSummary.setFlags(7);
        this.dbSync = new DbSyncCommand((BWidget)mgr);
        this.dbSync.setFlags(7);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.newCommand, this.edit, this.newFolder, this.dbSync, this.jobSummary};
    }

    private static Integer attemptFetchingNumericFromLexicon(String key, int fallback) {
        try {
            return Integer.parseInt(lex.getText(key));
        }
        catch (NumberFormatException oops) {
            CommonUtil.globalLog.warning(key + " from lexicon could not be converted to int");
            return fallback;
        }
    }

    private boolean isNetOk() {
        if (this.testNet()) {
            return true;
        }
        this.network = (BMicrosNetwork)NMgrUtil.findNNetwork((BAbstractManager)this.mgr);
        if (this.testNet()) {
            return true;
        }
        BMicrosPointManager.LOG.log(Level.WARNING, NO_NETWORK);
        BDialog.error((BWidget)this.mgr, (Object)lex.getText("pmc.notRunning"));
        return false;
    }

    private boolean testNet() {
        return this.mgr.isRunning() && this.network != null;
    }

    public MgrEdit promptForNew(Context cx) throws Exception {
        String title = this.newCommand.getLabel();
        return MicrosPointManagerNewDialog.promptForNew(this.mgr, this.makeEdit(title));
    }

    private final class DbSyncCommand
    extends MgrController.MgrCommand {
        private final Object singleEntry;
        private volatile Subscriber activeSubscriber;

        DbSyncCommand(BWidget owner) {
            super(owner, lex, "pmc.DbSyncCmd");
            this.singleEntry = new Object();
        }

        public CommandArtifact doInvoke() {
            MicrosPointManagerController.this.network.lease();
            if (this.isSanityCheckPassed()) {
                BOrd existingOrd = (BOrd)MicrosPointManagerController.this.network.getDatabaseSyncJobOrd().newCopy();
                MicrosPointManagerController.this.network.databaseSync();
                WbViewEventWorker.getInstance().invokeLater(() -> {
                    try {
                        MicrosPointManagerController.this.network.lease(0);
                    }
                    catch (RuntimeException e) {
                        BMicrosPointManager.LOG.log(Level.INFO, "Could not lease network for dbSync", e);
                    }
                    boolean stillOldOrd = true;
                    int RETRIES = 5;
                    for (int attempts = 0; attempts < 5 && stillOldOrd; ++attempts) {
                        stillOldOrd = MicrosPointManagerController.this.network.getDatabaseSyncJobOrd().equals((Object)existingOrd);
                        if (!stillOldOrd) continue;
                        try {
                            Thread.sleep(666L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            BMicrosPointManager.LOG.log(Level.INFO, "Interrupted awaiting DB Sync Result", e);
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                    if (stillOldOrd) {
                        BDialog.message((BWidget)MicrosPointManagerController.this.mgr, (String)lex.getText("pmc.dbSync.useButtonTitle"), (Object)lex.getText("pmc.dbSync.useButton"));
                        return;
                    }
                    final BJob activeJob = (BJob)MicrosPointManagerController.this.network.getDatabaseSyncJobOrd().resolve((BObject)MicrosPointManagerController.this.network).get();
                    if (this.activeSubscriber != null) {
                        this.activeSubscriber.unsubscribeAll();
                    }
                    this.activeSubscriber = new Subscriber(){

                        public void event(BComponentEvent bComponentEvent) {
                            if (bComponentEvent.getSlot().equals((Object)BJob.jobState)) {
                                BMicrosPointManager.LOG.info("New job state detected : " + bComponentEvent.getValue());
                                DbSyncCommand.this.handleJobState(activeJob);
                            }
                        }
                    };
                    this.activeSubscriber.subscribe((BComponent)activeJob);
                    this.handleJobState(activeJob);
                });
            }
            return null;
        }

        private boolean isSanityCheckPassed() {
            boolean okToProceed;
            int confirm = BDialog.confirm((BWidget)MicrosPointManagerController.this.mgr, (Object)DB_SYNC_ARE_YOU_SURE);
            boolean bl = okToProceed = confirm == 4 && MicrosPointManagerController.this.isNetOk();
            if (okToProceed) {
                MicrosPointManagerController.this.network.lease(0);
                String reasonNotToProceed = null;
                if (MicrosPointManagerController.this.network.isDisabled() || MicrosPointManagerController.this.network.isFatalFault()) {
                    reasonNotToProceed = lex.getText("pmc.dbSync.disabled", new Object[]{MicrosPointManagerController.this.network.getStatus().toString()});
                    okToProceed = false;
                } else if (!MicrosPointManagerController.this.network.getLinkStatus().isLinkActive()) {
                    reasonNotToProceed = lex.get("pmc.dbSync.linkNotActive");
                    okToProceed = false;
                }
                if (!okToProceed) {
                    BMicrosPointManager.LOG.log(Level.WARNING, reasonNotToProceed);
                    BDialog.error((BWidget)MicrosPointManagerController.this.mgr, (Object)reasonNotToProceed);
                }
            }
            return okToProceed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleJobState(BJob activeJob) {
            BMicrosPointManager.LOG.log(Level.FINE, "Job state eval" + activeJob);
            Object object = this.singleEntry;
            synchronized (object) {
                if (activeJob.getJobState().equals((Object)BJobState.success)) {
                    if (this.activeSubscriber != null) {
                        BWidget.invokeLater(() -> ((MicrosPointManagerController)MicrosPointManagerController.this.mgr.getController()).jobSummary.doInvoke());
                    }
                } else if (activeJob.getJobState().equals((Object)BJobState.canceled)) {
                    BWidget.invokeLater(() -> {
                        String cancelledErr = lex.getText("ds.job.cancelled");
                        BMicrosPointManager.LOG.warning(cancelledErr);
                        BDialog.error((BWidget)MicrosPointManagerController.this.getManager(), (Object)cancelledErr);
                    });
                } else if (activeJob.getJobState().equals((Object)BJobState.failed)) {
                    BWidget.invokeLater(() -> {
                        BMicrosPointManager.LOG.log(Level.INFO, "Micros DS Job was failed");
                        BMicrosDatabaseSyncJob job = (BMicrosDatabaseSyncJob)activeJob;
                        if (job.getTotalRecievedCount() == 0) {
                            BAbsTime mustStartAfter = MicrosPointManagerController.this.network.getLastLinkActivationTime().add(BRelTime.makeMinutes((int)1));
                            if (job.getStartTime().compareTo((Object)mustStartAfter) <= 0) {
                                BDialog.message((BWidget)MicrosPointManagerController.this.mgr, (String)lex.getText("pmc.tooSoon.title"), (Object)lex.getText("pmc.tooSoon.text"));
                            }
                        } else if (job.getTotalRecievedCount() == job.getUnknownRoomCount()) {
                            BDialog.message((BWidget)MicrosPointManagerController.this.mgr, (String)lex.getText("pmc.noRooms.recognised.title"), (Object)lex.getText("pmc.noRooms.recognised.text"));
                        } else {
                            BDialog.message((BWidget)MicrosPointManagerController.this.mgr, (String)lex.get("Job Failed.title"), (Object)"Job Failed. Fidelio's default behaviour is to return no DS records until it has been connected for more than 1 minute.");
                        }
                    });
                } else {
                    return;
                }
                if (this.activeSubscriber != null) {
                    this.activeSubscriber.unsubscribeAll();
                    this.activeSubscriber = null;
                    BMicrosPointManager.LOG.log(Level.FINE, "Unsubscribed");
                }
            }
        }
    }

    private final class JobSummaryCommand
    extends MgrController.MgrCommand {
        private final String NO_RESULTS;

        JobSummaryCommand(BWidget owner) {
            super(owner, lex, "pmc.DbSyncSummary");
            this.NO_RESULTS = lex.getText("ds.popup.noResults");
        }

        public CommandArtifact doInvoke() {
            block12: {
                if (!MicrosPointManagerController.this.isNetOk()) {
                    return null;
                }
                try {
                    BWbShell shell = MicrosPointManagerController.this.mgr.getWbShell();
                    MicrosPointManagerController.this.network.lease(0, 10L);
                    BOrd jobOrd = MicrosPointManagerController.this.network.getDatabaseSyncJobOrd();
                    if (jobOrd != null && jobOrd != BOrd.NULL) {
                        BOrd normJobOrd = jobOrd.normalize();
                        BOrd target = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)normJobOrd);
                        BObject expectedJob = null;
                        try {
                            expectedJob = target.resolve((BObject)MicrosPointManagerController.this.network).get();
                        }
                        catch (UnresolvedException e) {
                            BMicrosPointManager.LOG.log(Level.WARNING, "Job Not Found - Referenced job could have been removed from jobService", e);
                            BDialog.error((BWidget)this.getShell(), (String)"Referenced Job Not Found", (Object)this.NO_RESULTS, (Throwable)e);
                        }
                        if (expectedJob instanceof BMicrosDatabaseSyncJob) {
                            ((BMicrosDatabaseSyncJob)expectedJob).lease(0, 10L);
                            try {
                                int totalWidth = MicrosPointManagerController.attemptFetchingNumericFromLexicon("summary.popup.width", 650);
                                int totalHeight = MicrosPointManagerController.attemptFetchingNumericFromLexicon("summary.popup.height", 400);
                                MicrosPointManagerSyncDialog.showWindow((BJob)expectedJob, totalWidth, totalHeight);
                            }
                            catch (RuntimeException e) {
                                BMicrosPointManager.LOG.log(Level.WARNING, "Error displaying window", e);
                            }
                        } else {
                            BMicrosPointManager.LOG.warning("Job not found");
                        }
                        break block12;
                    }
                    BDialog.error((BWidget)this.getShell(), (Object)this.NO_RESULTS);
                }
                catch (NullPointerException | NullOrdException npe) {
                    if (MicrosPointManagerController.this.network.getDatabaseSyncJobOrd() != null) {
                        BMicrosPointManager.LOG.warning("MicrosPointManager:" + this.NO_RESULTS + ": " + MicrosPointManagerController.this.network.getDatabaseSyncJobOrd());
                    }
                    BDialog.error((BWidget)MicrosPointManagerController.this.getManager(), (String)"Referenced Job Not Found", (Object)this.NO_RESULTS, (Throwable)npe);
                }
                catch (RuntimeException e) {
                    BMicrosPointManager.LOG.log(Level.WARNING, "Could not display any of the job results popup", e);
                }
            }
            return null;
        }
    }
}

