/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxButtonHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.ntp.BNtpMode;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.win32.BNtpPlatformServiceWin32;
import com.tridium.platform.win32.BNtpServerWin32;
import com.tridium.platform.win32.BNtpSyncPolicyWin32;
import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"platform:NtpPlatformServiceEditorWin32"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxNtpPlatSvcWin32Editor
extends BHxView {
    @Generated
    public static final BHxNtpPlatSvcWin32Editor INSTANCE = new BHxNtpPlatSvcWin32Editor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxNtpPlatSvcWin32Editor.class);
    private HxButtonHelper refreshButton = HxButtonHelper.makeRefresh();
    private HxButtonHelper saveButton = HxButtonHelper.makeSave();
    private Command handleEnabledChanged = new HandleEnabledChanged();
    private Command handleDeleteServer;
    private Command handleAddServer;
    private Command handleMoveServerUp;
    private Command handleMoveServerDown;
    private HxViewHelper enabledFe;
    private HxViewHelper maxPosPhaseCorrectionFe;
    private HxViewHelper maxNegPhaseCorrectionFe;
    private HxViewHelper minPollIntervalFe;
    private HxViewHelper maxPollIntervalFe;
    private HxViewHelper specialPollIntervalFe;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxNtpPlatSvcWin32Editor() {
        this.registerEvent((Event)this.handleEnabledChanged);
        this.handleAddServer = new HandleAddServer();
        this.registerEvent((Event)this.handleAddServer);
        this.handleDeleteServer = new HandleDeleteServer();
        this.registerEvent((Event)this.handleDeleteServer);
        this.handleMoveServerUp = new HandleMoveServerUp();
        this.registerEvent((Event)this.handleMoveServerUp);
        this.handleMoveServerDown = new HandleMoveServerDown();
        this.registerEvent((Event)this.handleMoveServerDown);
        this.enabledFe = HxBooleanHelper.makeFE("enabled", null);
        this.maxPosPhaseCorrectionFe = HxViewHelper.makeFE("maxPosPhaseCorrection", (BObject)BNtpPlatformServiceWin32.maxPosPhaseCorrection.getDefaultValue(), (Context)BNtpPlatformServiceWin32.maxPosPhaseCorrection.getFacets());
        this.maxNegPhaseCorrectionFe = HxViewHelper.makeFE("maxNegPhaseCorrection", (BObject)BNtpPlatformServiceWin32.maxNegPhaseCorrection.getDefaultValue(), (Context)BNtpPlatformServiceWin32.maxNegPhaseCorrection.getFacets());
        this.minPollIntervalFe = HxViewHelper.makeFE("minPollInterval", (BObject)BNtpPlatformServiceWin32.minPollInterval.getDefaultValue(), (Context)BNtpPlatformServiceWin32.minPollInterval.getFacets());
        this.maxPollIntervalFe = HxViewHelper.makeFE("maxPollInterval", (BObject)BNtpPlatformServiceWin32.maxPollInterval.getDefaultValue(), (Context)BNtpPlatformServiceWin32.maxPollInterval.getFacets());
        this.specialPollIntervalFe = HxViewHelper.makeFE("specialPollInterval", (BObject)BNtpPlatformServiceWin32.specialPollInterval.getDefaultValue(), (Context)BNtpPlatformServiceWin32.specialPollInterval.getFacets());
    }

    public void write(HxOp op) throws Exception {
        boolean readonly;
        BNtpPlatformServiceWin32 service = (BNtpPlatformServiceWin32)op.get();
        service.poll();
        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sys.poll();
        if (op.canWrite()) {
            if (sys.getIsServiceReadonly()) {
                op.setReadonly(true);
                readonly = true;
            } else {
                readonly = false;
            }
        } else {
            readonly = true;
        }
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<div class='hx-PropertySheet-header'>").safe((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.settings.label").getText((Context)op)).w((Object)"</div>");
        out.w((Object)"<div class='window-bg hx-PropertySheet'>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.enabled.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w((Object)"<select ").attr("name", op.scope("enabled.value"));
        if (readonly) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)" onchange='").w((Object)this.handleEnabledChanged.getInvokeCode(op)).w((Object)"' ");
        out.w((Object)">");
        out.w((Object)"<option value='false'");
        if (!service.getEnabled()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)BBoolean.toString((boolean)false, (Context)op)).w((Object)"</option>");
        out.w((Object)"<option value='true'");
        if (service.getEnabled()) {
            out.w((Object)" selected='selected'");
        }
        out.w((Object)">").safe((Object)BBoolean.toString((boolean)true, (Context)op)).w((Object)"</option>");
        out.w((Object)"</select>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("domainMember")).w((Object)("' value='" + service.getDomainMember() + "'/>"));
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.syncPolicy.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        out.w((Object)"<div id='").w((Object)op.scope("syncPolicySection")).w((Object)"'>");
        this.writeSyncPolicy(op, out, service.getEnabled(), service.getDomainMember(), service.getSyncPolicy());
        out.w((Object)"</div>");
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.maxPosPhaseCorrection.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.maxPosPhaseCorrectionFe.setReadonly(readonly);
        this.maxPosPhaseCorrectionFe.write((BObject)service.get(BNtpPlatformServiceWin32.maxPosPhaseCorrection), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.maxNegPhaseCorrection.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.maxNegPhaseCorrectionFe.setReadonly(readonly);
        this.maxNegPhaseCorrectionFe.write((BObject)service.get(BNtpPlatformServiceWin32.maxNegPhaseCorrection), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.minPollInterval.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.minPollIntervalFe.setReadonly(readonly);
        this.minPollIntervalFe.write((BObject)service.get(BNtpPlatformServiceWin32.minPollInterval), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.maxPollInterval.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.maxPollIntervalFe.setReadonly(readonly);
        this.maxPollIntervalFe.write((BObject)service.get(BNtpPlatformServiceWin32.maxPollInterval), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.specialPollInterval.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.specialPollIntervalFe.setReadonly(readonly);
        this.specialPollIntervalFe.write((BObject)service.get(BNtpPlatformServiceWin32.specialPollInterval), op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        out.w((Object)"<div class='hx-PropertySheet-header'>").safe((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.timeServers.label").getText((Context)op)).w((Object)"</div>");
        out.w((Object)"<div class='window-bg hx-PropertySheet'>");
        out.w((Object)"<div id='").w((Object)op.scope("serversSection")).w((Object)"'>");
        this.writeServersTableHeader(op, out);
        int i = 0;
        SlotCursor c = service.getTimeServers().getProperties();
        while (c.next(BNtpServerWin32.class)) {
            BNtpServerWin32 server = (BNtpServerWin32)c.get();
            this.writeServerRow(op, out, i++, server, false);
        }
        this.writeServersTableFooter(op, out);
        out.w((Object)"</div>");
        out.println("<div style='padding:10px; text-align:center;'>");
        this.refreshButton.write(op);
        if (!readonly) {
            this.saveButton.write(op);
        }
        out.println("</div>");
        out.println("</div>");
    }

    protected void writeServersTableHeader(HxOp op, HtmlWriter out) throws Exception {
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        if (op.canWrite()) {
            out.w((Object)"<th>");
            out.w((Object)"</th>");
        }
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformService.address.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.useSpecialPollInterval.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.fallback.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"<th>");
        out.w((Object)LexiconText.make((Type)TYPE, (String)"NtpPlatformServiceWin32.peerMode.label").getHtmlSafeText((Context)op));
        out.w((Object)"</th>");
        out.w((Object)"</tr>");
    }

    protected void writeServersTableFooter(HxOp op, HtmlWriter out) throws Exception {
        if (op.canWrite()) {
            out.w((Object)"<tr><td colspan='5' align='center'>");
            out.w((Object)"<a href='javascript:").w((Object)this.handleAddServer.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/add.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<a href='javascript:").w((Object)this.handleDeleteServer.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/delete.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<a href='javascript:").w((Object)this.handleMoveServerUp.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowUp.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"&nbsp;");
            out.w((Object)"<a href='javascript:").w((Object)this.handleMoveServerDown.getInvokeCode(op)).w((Object)"'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)BOrd.make((String)"module://icons/x16/arrowDown.png")), (String)"border='0'", (HxOp)op);
            out.w((Object)"</a>");
            out.w((Object)"</td></tr>");
        }
        out.w((Object)"</table>");
    }

    protected void writeServerRow(HxOp op, HtmlWriter out, int idx, BNtpServerWin32 server, boolean isSelected) throws Exception {
        out.w((Object)"<tr>");
        if (op.canWrite()) {
            out.w((Object)"<td>");
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("select_" + idx)).w((Object)"'");
            if (isSelected) {
                out.w((Object)" checked='checked'");
            }
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<input type='text' size='32'");
            out.w((Object)" ").attr("name", op.scope("address_" + idx));
            out.w((Object)" ").attr("value", server.getAddress());
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select ").attr("name", op.scope("useSpecial_" + idx)).w((Object)">");
            out.w((Object)"<option value='false'");
            if (!server.getUseSpecialPollInterval()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.FALSE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='true'");
            if (server.getUseSpecialPollInterval()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.TRUE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select ").attr("name", op.scope("fallback_" + idx)).w((Object)">");
            out.w((Object)"<option value='false'");
            if (!server.getFallbackOnly()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.FALSE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='true'");
            if (server.getFallbackOnly()) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BBoolean.TRUE.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
            out.w((Object)"<td>");
            out.w((Object)"<select ").attr("name", op.scope("peerMode_" + idx)).w((Object)">");
            out.w((Object)"<option value='0'");
            if (server.getPeerMode() == BNtpMode.unspecified) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BNtpMode.unspecified.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='1'");
            if (server.getPeerMode() == BNtpMode.symmetricActive) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BNtpMode.symmetricActive.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"<option value='3'");
            if (server.getPeerMode() == BNtpMode.client) {
                out.w((Object)" selected='selected'");
            }
            out.w((Object)">").safe((Object)BNtpMode.client.toString((Context)op)).w((Object)"</option>");
            out.w((Object)"</select>");
            out.w((Object)"</td>");
        } else {
            out.w((Object)"<td>").safe((Object)server.getAddress()).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.get(BNtpServerWin32.useSpecialPollInterval).toString((Context)op)).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.get(BNtpServerWin32.fallbackOnly).toString((Context)op)).w((Object)"</td>");
            out.w((Object)"<td>").safe((Object)server.getPeerMode().toString((Context)op)).w((Object)"</td>");
        }
        out.w((Object)"</tr>");
    }

    protected void writeSyncPolicy(HxOp op, HtmlWriter out, boolean enabled, boolean domainMember, BNtpSyncPolicyWin32 value) throws Exception {
        out.w((Object)"<select ").attr("name", op.scope("syncPolicy.value"));
        if (!op.canWrite()) {
            out.w((Object)" disabled='disabled'");
        }
        out.w((Object)">");
        if (enabled) {
            out.w((Object)"<option value='1' ");
            if (value == BNtpSyncPolicyWin32.ntp) {
                out.w((Object)"selected='selected'");
            }
            out.w('>');
            out.safe((Object)BNtpSyncPolicyWin32.ntp.toString((Context)op));
            out.w((Object)"</option>");
            if (domainMember) {
                out.w((Object)"<option value='2' ");
                if (value == BNtpSyncPolicyWin32.domain || value == BNtpSyncPolicyWin32.none) {
                    out.w((Object)"selected='selected'");
                }
                out.w('>');
                out.safe((Object)BNtpSyncPolicyWin32.domain.toString((Context)op));
                out.w((Object)"</option>");
                out.w((Object)"<option value='3' ");
                if (value == BNtpSyncPolicyWin32.both) {
                    out.w((Object)"selected='selected'");
                }
                out.w('>');
                out.safe((Object)BNtpSyncPolicyWin32.both.toString((Context)op));
                out.w((Object)"</option>");
            }
        } else {
            out.w((Object)"<option value='0' ");
            out.w((Object)"selected='selected'");
            out.w('>');
            out.safe((Object)BNtpSyncPolicyWin32.none.toString((Context)op));
            out.w((Object)"</option>");
        }
        out.w((Object)"</select>");
    }

    protected BNtpServerWin32[] getTimeServers(HxOp op) throws Exception {
        ArrayList<BNtpServerWin32> result = new ArrayList<BNtpServerWin32>();
        int i = 0;
        String address = op.getUnsafeFormValue("address_" + i);
        while (address != null) {
            BNtpServerWin32 server = new BNtpServerWin32();
            server.setAddress(address);
            server.setUseSpecialPollInterval(op.getFormValue("useSpecial_" + i).equals("true"));
            server.setFallbackOnly(op.getFormValue("fallback_" + i).equals("true"));
            server.setPeerMode(BNtpMode.make((int)Integer.parseInt(op.getFormValue("peerMode_" + i))));
            result.add(server);
            address = op.getUnsafeFormValue("address_" + ++i);
        }
        return (BNtpServerWin32[])ArrayUtil.arrayFromCollection(result, BNtpServerWin32[]::new);
    }

    public BObject save(HxOp op) throws Exception {
        BNtpPlatformServiceWin32 service = (BNtpPlatformServiceWin32)op.get();
        BNtpServerWin32[] servers = this.getTimeServers(op);
        String[] serverStrings = new String[servers.length];
        HashSet<String> usedProps = new HashSet<String>();
        for (int i = 0; i < servers.length; ++i) {
            String host = servers[i].getAddress();
            if (host.trim().length() == 0) {
                throw new LocalizableRuntimeException("platform", "NtpServerFE.nullAddress");
            }
            if (!IPAddressUtil.isNumericAddr((String)host) && !IPAddressUtil.isHostname((String)host)) {
                throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{host});
            }
            serverStrings[i] = servers[i].getServerString();
            String propName = servers[i].getPropertyName(serverStrings[i]);
            if (usedProps.contains(propName)) {
                throw new LocalizableRuntimeException("platform", "NtpServerVectorFE.duplicateServer");
            }
            usedProps.add(propName);
        }
        service.getTimeServers().sync(serverStrings);
        service.setEnabled(((BBoolean)this.enabledFe.save((BObject)service.get(BNtpPlatformService.enabled), op)).getBoolean());
        service.setSyncPolicy(BNtpSyncPolicyWin32.make((int)Integer.parseInt(op.getFormValue("syncPolicy.value"))));
        service.getTimeServers().sync(serverStrings);
        service.setMaxPosPhaseCorrection(((BInteger)this.maxPosPhaseCorrectionFe.save((BObject)service.get(BNtpPlatformServiceWin32.maxPosPhaseCorrection), op)).getInt());
        service.setMaxNegPhaseCorrection(((BInteger)this.maxNegPhaseCorrectionFe.save((BObject)service.get(BNtpPlatformServiceWin32.maxNegPhaseCorrection), op)).getInt());
        service.setMinPollInterval(((BInteger)this.minPollIntervalFe.save((BObject)service.get(BNtpPlatformServiceWin32.minPollInterval), op)).getInt());
        service.setMaxPollInterval(((BInteger)this.maxPollIntervalFe.save((BObject)service.get(BNtpPlatformServiceWin32.maxPollInterval), op)).getInt());
        service.setSpecialPollInterval(((BInteger)this.specialPollIntervalFe.save((BObject)service.get(BNtpPlatformServiceWin32.specialPollInterval), op)).getInt());
        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sys.poll();
        if (!sys.getIsServiceReadonly()) {
            service.savePlatformServiceProperties();
        }
        return service;
    }

    private class HandleDeleteServer
    extends Command {
        public HandleDeleteServer() {
            super((BHxView)BHxNtpPlatSvcWin32Editor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            BNtpServerWin32[] servers = BHxNtpPlatSvcWin32Editor.this.getTimeServers(op);
            String id = op.scope("serversSection");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
            out.w((Object)"serversSection.innerHTML = \"");
            BHxNtpPlatSvcWin32Editor.this.writeServersTableHeader(op, out);
            int numDeleted = 0;
            for (int i = 0; i < servers.length; ++i) {
                if (op.getFormValue("select_" + i) == null) {
                    BHxNtpPlatSvcWin32Editor.this.writeServerRow(op, out, i - numDeleted, servers[i], false);
                    continue;
                }
                ++numDeleted;
            }
            BHxNtpPlatSvcWin32Editor.this.writeServersTableFooter(op, out);
            out.w((Object)"\";");
        }
    }

    private class HandleAddServer
    extends Command {
        public HandleAddServer() {
            super((BHxView)BHxNtpPlatSvcWin32Editor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            BNtpServerWin32[] servers = BHxNtpPlatSvcWin32Editor.this.getTimeServers(op);
            String id = op.scope("serversSection");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
            out.w((Object)"serversSection.innerHTML = \"");
            BHxNtpPlatSvcWin32Editor.this.writeServersTableHeader(op, out);
            for (int i = 0; i < servers.length; ++i) {
                BHxNtpPlatSvcWin32Editor.this.writeServerRow(op, out, i, servers[i], false);
            }
            BHxNtpPlatSvcWin32Editor.this.writeServerRow(op, out, servers.length, new BNtpServerWin32(), false);
            BHxNtpPlatSvcWin32Editor.this.writeServersTableFooter(op, out);
            out.w((Object)"\";");
        }
    }

    private class HandleMoveServerDown
    extends Command {
        public HandleMoveServerDown() {
            super((BHxView)BHxNtpPlatSvcWin32Editor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            String[] keys = op.getFormKeys();
            int sel = -1;
            for (String key : keys) {
                if (!key.startsWith("select_")) continue;
                if (sel < 0) {
                    sel = Integer.parseInt(key.substring(7));
                    continue;
                }
                return;
            }
            if (sel >= 0 && op.getFormValue("address_" + (sel + 1)) != null) {
                BNtpServerWin32[] servers = BHxNtpPlatSvcWin32Editor.this.getTimeServers(op);
                BNtpServerWin32 temp = servers[sel + 1];
                servers[sel + 1] = servers[sel];
                servers[sel] = temp;
                String id = op.scope("serversSection");
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
                out.w((Object)"serversSection.innerHTML = \"");
                BHxNtpPlatSvcWin32Editor.this.writeServersTableHeader(op, out);
                for (int i = 0; i < servers.length; ++i) {
                    BHxNtpPlatSvcWin32Editor.this.writeServerRow(op, out, i, servers[i], i == sel + 1);
                }
                BHxNtpPlatSvcWin32Editor.this.writeServersTableFooter(op, out);
                out.w((Object)"\";");
            }
        }
    }

    private class HandleMoveServerUp
    extends Command {
        public HandleMoveServerUp() {
            super((BHxView)BHxNtpPlatSvcWin32Editor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            String[] keys = op.getFormKeys();
            int sel = -1;
            for (String key : keys) {
                if (!key.startsWith("select_")) continue;
                if (sel < 0) {
                    sel = Integer.parseInt(key.substring(7));
                    continue;
                }
                return;
            }
            if (sel > 0) {
                BNtpServerWin32[] servers = BHxNtpPlatSvcWin32Editor.this.getTimeServers(op);
                BNtpServerWin32 temp = servers[sel - 1];
                servers[sel - 1] = servers[sel];
                servers[sel] = temp;
                String id = op.scope("serversSection");
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"var serversSection = document.getElementById('").w((Object)id).w((Object)"');");
                out.w((Object)"serversSection.innerHTML = \"");
                BHxNtpPlatSvcWin32Editor.this.writeServersTableHeader(op, out);
                for (int i = 0; i < servers.length; ++i) {
                    BHxNtpPlatSvcWin32Editor.this.writeServerRow(op, out, i, servers[i], i == sel - 1);
                }
                BHxNtpPlatSvcWin32Editor.this.writeServersTableFooter(op, out);
                out.w((Object)"\";");
            }
        }
    }

    private class HandleEnabledChanged
    extends Command {
        public HandleEnabledChanged() {
            super((BHxView)BHxNtpPlatSvcWin32Editor.this);
        }

        public String getDisplayName(HxOp op) {
            return "";
        }

        public void handle(HxOp op) throws Exception {
            String id = op.scope("syncPolicySection");
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"var syncPolicySection = document.getElementById('").w((Object)id).w((Object)"');");
            out.w((Object)"syncPolicySection.innerHTML = \"");
            BHxNtpPlatSvcWin32Editor.this.writeSyncPolicy(op, out, op.getFormValue("enabled.value").equals("true"), op.getFormValue("domainMember").equals("true"), BNtpSyncPolicyWin32.make((int)Integer.parseInt(op.getFormValue("syncPolicy.value"))));
            out.w((Object)"\";");
        }
    }
}

