/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxStringHelper;
import com.tridium.platform.hx.util.HxStringListHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.hx.util.TcpIpAddressValidator;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"platform:TcpIpAdapterEditor"}, requiredPermissions="W")})
@NiagaraSingleton
public final class BHxTcpIpAdapterEditor
extends BHxView {
    @Generated
    public static final BHxTcpIpAdapterEditor INSTANCE = new BHxTcpIpAdapterEditor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxTcpIpAdapterEditor.class);
    private final HxViewHelper adapterEnabledEditor;
    private final HxViewHelper domainEditor = HxStringHelper.makeFE("domain", null);
    private final HxViewHelper gatewayEditor = HxStringHelper.makeFE("gateway", TcpIpAddressValidator.INSTANCE_PERMIT_NULL, null);
    private final HxViewHelper dnsEditor = HxStringListHelper.makeFE("dnsHosts", TcpIpAddressValidator.INSTANCE_PERMIT_NULL, null);
    private final HxViewHelper ipv6GatewayEditor;
    private final HxViewHelper ipv6DnsEditor;
    private final HxViewHelper ipAddressEditor = HxStringHelper.makeFE("ipAddress", TcpIpAddressValidator.INSTANCE, null);
    private final HxViewHelper subnetMaskEditor = HxStringHelper.makeFE("subnetMask", TcpIpAddressValidator.INSTANCE_SUBNET, null);
    private final HxViewHelper dhcpEnabledEditor;
    private final HxViewHelper ipv6EnabledEditor;
    private final HxViewHelper ipv6DhcpEnabledEditor;
    private final HxViewHelper ipv6AddressEditor;
    private final HxViewHelper ipv6SubnetPrefixLengthEditor;
    private final HxViewHelper dhcpdv4EnabledEditor;
    private final HxViewHelper dhcpdv4DefaultLeaseTimeEditor;
    private final HxViewHelper dhcpdv4MaxLeaseTimeEditor;
    private final HxViewHelper dhcpdv4SubnetEditor;
    private final HxViewHelper dhcpdv4NetmaskEditor;
    private final HxViewHelper dhcpdv4ClientRangeLowEditor;
    private final HxViewHelper dhcpdv4MaxClientsEditor;

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BHxTcpIpAdapterEditor() {
        this.ipv6GatewayEditor = HxStringHelper.makeFE("ipv6Gateway", TcpIpAddressValidator.INSTANCEv6_PERMIT_NULL, null);
        this.ipv6DnsEditor = HxStringListHelper.makeFE("ipv6DnsHosts", TcpIpAddressValidator.INSTANCEv6_PERMIT_NULL, null);
        this.ipv6AddressEditor = HxStringHelper.makeFE("ipv6Address", TcpIpAddressValidator.INSTANCEv6, null);
        this.ipv6SubnetPrefixLengthEditor = HxViewHelper.makeFE("ipv6SubnetPrefixLength", (BObject)BInteger.DEFAULT, (Context)BTcpIpAdapterSettings.ipv6SubnetPrefixLength.getFacets());
        this.dhcpdv4DefaultLeaseTimeEditor = HxViewHelper.makeFE("dhcpdv4DefaultLeaseTime", (BObject)BRelTime.DEFAULT, (Context)BDhcpdAdapterSettings.defaultLeaseTime.getFacets());
        this.dhcpdv4MaxLeaseTimeEditor = HxViewHelper.makeFE("dhcpdv4MaxLeaseTime", (BObject)BRelTime.DEFAULT, (Context)BDhcpdAdapterSettings.maxLeaseTime.getFacets());
        this.dhcpdv4SubnetEditor = HxStringHelper.makeFE("dhcpdv4Subnet", TcpIpAddressValidator.INSTANCE, null);
        this.dhcpdv4NetmaskEditor = HxStringHelper.makeFE("dhcpdv4Netmask", TcpIpAddressValidator.INSTANCE_SUBNET, null);
        this.dhcpdv4ClientRangeLowEditor = HxStringHelper.makeFE("dhcpdv4ClientRangeLow", TcpIpAddressValidator.INSTANCE, null);
        this.dhcpdv4MaxClientsEditor = HxViewHelper.makeFE("dhcpdv4MaxClients", (BObject)BInteger.DEFAULT, (Context)BDhcpdAdapterSettings.range.getFacets());
        BFacets dhcpEnabledFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.isDhcpEnabled.true)%"), BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.isDhcpEnabled.false)%")});
        BFacets dhcpv6EnabledFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.isIpv6DhcpEnabled.true)%"), BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.isIpv6DhcpEnabled.false)%")});
        BFacets ipv6EnabledFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.isIpv6Enabled.true)%"), BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.isIpv6Enabled.false)%")});
        BFacets adapterEnabledFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.adapterEnabled.true)%"), BString.make((String)"%lexicon(platform:TcpIpAdapterEditor.adapterEnabled.false)%")});
        BFacets dhcpdv4EnabledFacets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BString[]{BString.make((String)"%lexicon(platform:TcpIpAdapterEditorDhcpd.isDhcpdEnabled.true)%"), BString.make((String)"%lexicon(platform:TcpIpAdapterEditorDhcpd.isDhcpdEnabled.false)%")});
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("onChange", "onAdapterEnabledChanged(event)");
        this.adapterEnabledEditor = HxBooleanHelper.makeFE("adapterEnabled", attrs, (Context)adapterEnabledFacets);
        attrs = new HashMap();
        attrs.put("onChange", "onDhcpEnabledChanged(event)");
        this.dhcpEnabledEditor = HxBooleanHelper.makeFE("dhcpEnabled", attrs, (Context)dhcpEnabledFacets);
        attrs = new HashMap();
        attrs.put("onChange", "onIpv6EnabledChanged(event)");
        this.ipv6EnabledEditor = HxBooleanHelper.makeFE("ipv6Enabled", attrs, (Context)ipv6EnabledFacets);
        attrs = new HashMap();
        attrs.put("onChange", "onIpv6DhcpEnabledChanged(event)");
        this.ipv6DhcpEnabledEditor = HxBooleanHelper.makeFE("ipv6DhcpEnabled", attrs, (Context)dhcpv6EnabledFacets);
        attrs = new HashMap();
        attrs.put("onChange", "onDhcpdv4EnabledChanged(event)");
        this.dhcpdv4EnabledEditor = HxBooleanHelper.makeFE("dhcpdv4Enabled", attrs, (Context)dhcpdv4EnabledFacets);
    }

    public void write(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        BOrd ord = BOrd.make((String)"module://platform/lib/BHxTcpIpAdapterEditor.js");
        op.addJavaScript(ord);
        this.updatePermanentReadonly(op);
        boolean operatorCanWrite = op.canWrite();
        boolean isAdapterReadonly = adapter.getIsAdapterReadonly() || adapter.getHostSettings().getIsReadonly();
        boolean canDisableAdapter = !isAdapterReadonly && adapter.getCanDisableAdapter();
        boolean isAdapterEnabled = adapter.getIsAdapterEnabled();
        boolean canUseDhcp = adapter.getCanUseDhcp();
        boolean isIpv6Supported = adapter.getIsIpv6Supported();
        boolean isIpv6Readonly = isAdapterReadonly || adapter.getHostSettings().getIsIPv6Readonly();
        boolean isIpv6Enabled = adapter.getIsIpv6Enabled();
        boolean canDisableIpv6 = !isAdapterReadonly && adapter.getCanDisableIpv6();
        boolean canUseIpv6Dhcp = adapter.getCanUseIpv6Dhcp();
        HtmlWriter out = op.getHtmlWriter();
        out.println();
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("operatorCanWrite.hidden")).w((Object)("' value='" + operatorCanWrite)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("adapterEnabled.hidden")).w((Object)("' value='" + isAdapterEnabled)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("adapterReadonly.hidden")).w((Object)("' value='" + isAdapterReadonly)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("canDisableAdapter.hidden")).w((Object)("' value='" + canDisableAdapter)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("canUseDhcp.hidden")).w((Object)("' value='" + canUseDhcp)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("dhcpEnabled.hidden")).w((Object)("' value='" + adapter.getIsDhcpEnabled())).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("ipv6Supported.hidden")).w((Object)("' value='" + isIpv6Supported)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("canDisableIpv6.hidden")).w((Object)("' value='" + canDisableIpv6)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("ipv6Enabled.hidden")).w((Object)("' value='" + isIpv6Enabled)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("ipv6Readonly.hidden")).w((Object)("' value='" + isIpv6Readonly)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("canUseIpv6Dhcp.hidden")).w((Object)("' value='" + canUseIpv6Dhcp)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("ipv6DhcpEnabled.hidden")).w((Object)("' value='" + adapter.getIsIpv6DhcpEnabled())).println("'/>");
        boolean canUseDhcpdv4 = false;
        boolean isDhcpdv4Readonly = true;
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.loadSlots().get("dhcpdAdapterSettings");
        if (dhcpdAdapterSettings != null) {
            canUseDhcpdv4 = dhcpdAdapterSettings.getIsDhcpdIpv4Supported();
            isDhcpdv4Readonly = isAdapterReadonly || dhcpdAdapterSettings.getIsReadOnly();
        }
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("canUseDhcpdv4.hidden")).w((Object)("' value='" + canUseDhcpdv4)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("dhcpdv4Readonly.hidden")).w((Object)("' value='" + isDhcpdv4Readonly)).println("'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("dhcpdv4Enabled.hidden")).w((Object)("' value='" + (dhcpdAdapterSettings != null ? Boolean.valueOf(dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) : "false"))).println("'/>");
        out.println("<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.interfaceId").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(adapter.getAdapterId(), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.interfaceDesc").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(adapter.getDescription(), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.macAddress").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>").safe(adapter.getMediaAccessControlAddress(), false).w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isAdapterEnabled").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.adapterEnabledEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.isAdapterEnabled), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        if (adapter.getCanUseDhcp()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isDhcpEnabled").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpEnabledEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.isDhcpEnabled), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        if (adapter.getUsesAdapterLevelSettings()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.domain").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.domainEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.domain), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipAddress").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.ipAddressEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.ipAddress), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.subnetMask").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.subnetMaskEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.subnetMask), op);
        out.w((Object)"</td>");
        out.println("</tr>");
        if (adapter.getUsesAdapterLevelSettings()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.gateway").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.gatewayEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.defaultGateway), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        if (adapter.getCanUseDhcp()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpHost").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>").safe(adapter.getDhcpHost().trim(), false).w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpLeaseGranted").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>").safe(adapter.getDhcpLeaseGranted().trim(), false).w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpLeaseExpires").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>").safe(adapter.getDhcpLeaseExpires().trim(), false).w((Object)"</td>");
            out.println("</tr>");
        }
        if (adapter.getUsesAdapterLevelSettings()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dnsHostHx").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dnsEditor.write((BObject)adapter.getDnsHosts(), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Supported").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        if (isIpv6Supported) {
            out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Supported.true").getHtmlSafeText((Context)op)).w((Object)"</td>");
        } else {
            out.w((Object)"<td>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Supported.false").getHtmlSafeText((Context)op)).w((Object)"</td>");
        }
        out.println("</tr>");
        if (isIpv6Supported) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Enabled").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.ipv6EnabledEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6Enabled), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        if (isIpv6Supported && !isIpv6Enabled && canDisableIpv6 || isIpv6Supported && isIpv6Enabled) {
            if (canUseIpv6Dhcp) {
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6DhcpEnabled").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                this.ipv6DhcpEnabledEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6DhcpEnabled), op);
                out.w((Object)"</td>");
                out.println("</tr>");
            }
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Address").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.ipv6AddressEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.ipv6Address), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6SubnetPrefixLength").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.ipv6SubnetPrefixLengthEditor.write((BObject)BInteger.make((String)adapter.get(BTcpIpAdapterSettings.ipv6SubnetPrefixLength).toString()), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            if (adapter.getUsesAdapterLevelSettings()) {
                out.w((Object)"<tr>");
                out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Gateway").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
                out.w((Object)"<td>");
                this.ipv6GatewayEditor.write((BObject)adapter.get(BTcpIpAdapterSettings.ipv6DefaultGateway), op);
                out.w((Object)"</td>");
                out.println("</tr>");
            }
        }
        if ((isIpv6Supported && !isIpv6Enabled && canDisableIpv6 || isIpv6Supported && isIpv6Enabled) && canUseIpv6Dhcp && !adapter.getIpv6DhcpHost().trim().equalsIgnoreCase("n/a") && !adapter.getIpv6DhcpHost().trim().equalsIgnoreCase("")) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpHost").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>").safe(adapter.getIpv6DhcpHost(), false).w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpLeaseGranted").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>").safe(adapter.getIpv6DhcpLeaseGranted(), false).w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpLeaseExpires").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>").safe(adapter.getIpv6DhcpLeaseExpires(), false).w((Object)"</td>");
            out.println("</tr>");
        }
        if ((isIpv6Supported && !isIpv6Enabled && canDisableIpv6 || isIpv6Supported && isIpv6Enabled) && adapter.getUsesAdapterLevelSettings()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DnsHostHx").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.ipv6DnsEditor.write((BObject)adapter.getIpv6DnsHosts(), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        if (dhcpdAdapterSettings != null && dhcpdAdapterSettings.getIsDhcpdIpv4Supported()) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.isDhcpdEnabled").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4EnabledEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.isDhcpdIpv4Enabled), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.defaultLeaseTime.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4DefaultLeaseTimeEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.defaultLeaseTime), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.maxLeaseTime.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4MaxLeaseTimeEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.maxLeaseTime), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.subnet.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4SubnetEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.subnet), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.netmask.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4NetmaskEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.subnetMask), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.rangestart.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4ClientRangeLowEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.startClientAddress), op);
            out.w((Object)"</td>");
            out.println("</tr>");
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditorDhcpd.rangesize.label").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.dhcpdv4MaxClientsEditor.write((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.range), op);
            out.w((Object)"</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        String function = "executeAdapterOnLoad(\"" + op.getPath() + "\");";
        op.addOnload(function);
    }

    private BSimple getPropertyValue(BComplex parent, Property prop, HxViewHelper editor, HxOp op) throws Exception {
        BSimple currentValue = (BSimple)parent.get(prop);
        if (!editor.isReadonly() && editor.isFormValueAvailable(op)) {
            return (BSimple)editor.save((BObject)currentValue, op);
        }
        return currentValue;
    }

    public boolean isIpv6EnabledSelected(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        return ((BBoolean)this.getPropertyValue((BComplex)adapter, BTcpIpAdapterSettings.isIpv6Enabled, this.ipv6EnabledEditor, op)).getBoolean();
    }

    public String getAdapterIPValue(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        return ((BString)this.getPropertyValue((BComplex)adapter, BTcpIpAdapterSettings.ipAddress, this.ipAddressEditor, op)).getString();
    }

    public String getAdapterSubnetMaskValue(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        return ((BString)this.getPropertyValue((BComplex)adapter, BTcpIpAdapterSettings.subnetMask, this.subnetMaskEditor, op)).getString();
    }

    public boolean isAdapterEnabledSelected(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        return ((BBoolean)this.getPropertyValue((BComplex)adapter, BTcpIpAdapterSettings.isAdapterEnabled, this.adapterEnabledEditor, op)).getBoolean();
    }

    public boolean isDhcpEnabledSelected(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        return ((BBoolean)this.getPropertyValue((BComplex)adapter, BTcpIpAdapterSettings.isDhcpEnabled, this.dhcpEnabledEditor, op)).getBoolean();
    }

    public boolean isDhcpdv4EnabledSelected(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        return ((BBoolean)this.getPropertyValue((BComplex)adapter, BDhcpdAdapterSettings.isDhcpdIpv4Enabled, this.dhcpdv4EnabledEditor, op)).getBoolean();
    }

    public void validate(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        if (adapter.getIsAdapterReadonly()) {
            return;
        }
        this.updatePermanentReadonly(op);
        String ipv4Address = null;
        String ipv4SubnetMask = null;
        BBoolean adapterEnabled = BBoolean.make((boolean)adapter.getIsAdapterEnabled());
        if (adapter.getCanDisableAdapter() && this.adapterEnabledEditor.isFormValueAvailable(op)) {
            this.adapterEnabledEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.isAdapterEnabled), op);
            adapterEnabled = (BBoolean)this.adapterEnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isAdapterEnabled), op);
        }
        if (adapterEnabled.getBoolean()) {
            BDhcpdAdapterSettings dhcpdAdapterSettings;
            BBoolean dhcpEnabled = BBoolean.make((boolean)adapter.getIsDhcpEnabled());
            if (adapter.getCanUseDhcp() && this.dhcpEnabledEditor.isFormValueAvailable(op)) {
                this.dhcpEnabledEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.isDhcpEnabled), op);
                dhcpEnabled = (BBoolean)this.dhcpEnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isDhcpEnabled), op);
            }
            if (!dhcpEnabled.getBoolean()) {
                if (this.ipAddressEditor.isFormValueAvailable(op)) {
                    this.ipAddressEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.ipAddress), op);
                    ipv4Address = ((BString)this.ipAddressEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.ipAddress), op)).getString();
                }
                if (this.subnetMaskEditor.isFormValueAvailable(op)) {
                    this.subnetMaskEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.subnetMask), op);
                    ipv4SubnetMask = ((BString)this.subnetMaskEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.subnetMask), op)).getString();
                }
            }
            BBoolean ipv6Enabled = BBoolean.make((boolean)adapter.getIsIpv6Enabled());
            BBoolean ipv6DhcpEnabled = BBoolean.FALSE;
            if (adapter.getIsIpv6Supported() && adapter.getCanDisableIpv6() && this.ipv6EnabledEditor.isFormValueAvailable(op)) {
                this.ipv6EnabledEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6Enabled), op);
                ipv6Enabled = (BBoolean)this.ipv6EnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6Enabled), op);
            }
            if (ipv6Enabled.getBoolean()) {
                ipv6DhcpEnabled = BBoolean.make((boolean)adapter.getIsIpv6DhcpEnabled());
                if (adapter.getCanUseIpv6Dhcp() && this.ipv6DhcpEnabledEditor.isFormValueAvailable(op)) {
                    this.ipv6DhcpEnabledEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6DhcpEnabled), op);
                    ipv6DhcpEnabled = (BBoolean)this.ipv6DhcpEnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6DhcpEnabled), op);
                }
                if (!ipv6DhcpEnabled.getBoolean()) {
                    if (this.ipv6AddressEditor.isFormValueAvailable(op)) {
                        this.ipv6AddressEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.ipv6Address), op);
                    }
                    if (!this.ipv6SubnetPrefixLengthEditor.isReadonly()) {
                        this.ipv6SubnetPrefixLengthEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.ipv6SubnetPrefixLength), op);
                    }
                }
            }
            if (adapter.getUsesAdapterLevelSettings()) {
                if (!dhcpEnabled.getBoolean()) {
                    if (this.domainEditor.isFormValueAvailable(op)) {
                        this.domainEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.domain), op);
                    }
                    if (this.dnsEditor.isFormValueAvailable(op)) {
                        this.dnsEditor.validate((BObject)adapter.getDnsHosts(), op);
                    }
                    if (this.gatewayEditor.isFormValueAvailable(op)) {
                        this.gatewayEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.defaultGateway), op);
                    }
                }
                if (ipv6Enabled.getBoolean() && !ipv6DhcpEnabled.getBoolean()) {
                    if (this.ipv6DnsEditor.isFormValueAvailable(op)) {
                        this.ipv6DnsEditor.validate((BObject)adapter.getIpv6DnsHosts(), op);
                    }
                    if (this.ipv6GatewayEditor.isFormValueAvailable(op)) {
                        this.ipv6GatewayEditor.validate((BObject)adapter.get(BTcpIpAdapterSettings.ipv6DefaultGateway), op);
                    }
                }
            }
            if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.loadSlots().get("dhcpdAdapterSettings")) != null && dhcpdAdapterSettings.getIsDhcpdIpv4Supported()) {
                BBoolean dhcpdv4Enabled = BBoolean.make((boolean)dhcpdAdapterSettings.getIsDhcpdIpv4Enabled());
                if (this.dhcpdv4EnabledEditor.isFormValueAvailable(op)) {
                    this.dhcpdv4EnabledEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.isDhcpdIpv4Enabled), op);
                    dhcpdv4Enabled = (BBoolean)this.dhcpdv4EnabledEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.isDhcpdIpv4Enabled), op);
                }
                if (dhcpdv4Enabled.getBoolean()) {
                    if (!this.dhcpdv4DefaultLeaseTimeEditor.isReadonly()) {
                        this.dhcpdv4DefaultLeaseTimeEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.defaultLeaseTime), op);
                    }
                    if (!this.dhcpdv4MaxLeaseTimeEditor.isReadonly()) {
                        this.dhcpdv4MaxLeaseTimeEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.maxLeaseTime), op);
                    }
                    if (this.dhcpdv4SubnetEditor.isFormValueAvailable(op)) {
                        this.dhcpdv4SubnetEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.subnet), op);
                    }
                    if (this.dhcpdv4NetmaskEditor.isFormValueAvailable(op)) {
                        this.dhcpdv4NetmaskEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.subnetMask), op);
                    }
                    if (this.dhcpdv4ClientRangeLowEditor.isFormValueAvailable(op)) {
                        this.dhcpdv4ClientRangeLowEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.startClientAddress), op);
                    }
                    if (!this.dhcpdv4MaxClientsEditor.isReadonly()) {
                        this.dhcpdv4MaxClientsEditor.validate((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.range), op);
                    }
                    if (dhcpdv4Enabled.getBoolean() && adapter.getCanUseDhcp() && dhcpEnabled.getBoolean()) {
                        throw new LocalizableRuntimeException("platform", "TcpIpAdapterEditorDhcpdError.bothDhcpdAndDhcp");
                    }
                    try {
                        DhcpdUtil.validateDhcpdAdapterSettings((BDhcpdAdapterSettings)dhcpdAdapterSettings, (String)ipv4Address, (String)ipv4SubnetMask, (int)1, (int)240);
                    }
                    catch (Exception e) {
                        throw new LocalizableRuntimeException("platform", e.getMessage());
                    }
                }
            }
        }
    }

    public BObject save(HxOp op) throws Exception {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        if (adapter.getIsAdapterReadonly()) {
            return adapter;
        }
        this.updatePermanentReadonly(op);
        if (adapter.getCanDisableAdapter() && this.adapterEnabledEditor.isFormValueAvailable(op)) {
            adapter.setIsAdapterEnabled(((BBoolean)this.adapterEnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isAdapterEnabled), op)).getBoolean());
        }
        if (adapter.getIsAdapterEnabled()) {
            BDhcpdAdapterSettings dhcpdAdapterSettings;
            if (adapter.getCanUseDhcp() && this.dhcpEnabledEditor.isFormValueAvailable(op)) {
                adapter.setIsDhcpEnabled(((BBoolean)this.dhcpEnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isDhcpEnabled), op)).getBoolean());
            }
            if (!adapter.getIsDhcpEnabled()) {
                if (this.ipAddressEditor.isFormValueAvailable(op)) {
                    adapter.setIpAddress(this.ipAddressEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.ipAddress), op).toString());
                }
                if (this.subnetMaskEditor.isFormValueAvailable(op)) {
                    adapter.setSubnetMask(this.subnetMaskEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.subnetMask), op).toString());
                }
            }
            if (adapter.getCanDisableIpv6() && this.ipv6EnabledEditor.isFormValueAvailable(op)) {
                adapter.setIsIpv6Enabled(((BBoolean)this.ipv6EnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6Enabled), op)).getBoolean());
            }
            if (adapter.getIsIpv6Enabled() && adapter.getCanUseIpv6Dhcp() && this.ipv6DhcpEnabledEditor.isFormValueAvailable(op)) {
                adapter.setIsIpv6DhcpEnabled(((BBoolean)this.ipv6DhcpEnabledEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.isIpv6DhcpEnabled), op)).getBoolean());
            }
            if (adapter.getIsIpv6Enabled() && !adapter.getIsIpv6DhcpEnabled()) {
                if (this.ipv6AddressEditor.isFormValueAvailable(op)) {
                    adapter.setIpv6Address(this.ipv6AddressEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.ipv6Address), op).toString());
                }
                if (!this.ipv6SubnetPrefixLengthEditor.isReadonly()) {
                    adapter.setIpv6SubnetPrefixLength(((BInteger)this.ipv6SubnetPrefixLengthEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.ipv6SubnetPrefixLength), op)).getInt());
                }
            }
            if (adapter.getUsesAdapterLevelSettings()) {
                if (!adapter.getIsDhcpEnabled()) {
                    if (this.domainEditor.isFormValueAvailable(op)) {
                        adapter.setDomain(this.domainEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.domain), op).toString());
                    }
                    if (this.dnsEditor.isFormValueAvailable(op)) {
                        adapter.setDnsHosts((BVector)this.dnsEditor.save((BObject)adapter.getDnsHosts(), op));
                    }
                    if (this.gatewayEditor.isFormValueAvailable(op)) {
                        adapter.setDefaultGateway(this.gatewayEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.defaultGateway), op).toString());
                    }
                }
                if (adapter.getIsIpv6Enabled()) {
                    if (this.ipv6DnsEditor.isFormValueAvailable(op)) {
                        adapter.setIpv6DnsHosts((BVector)this.ipv6DnsEditor.save((BObject)adapter.getIpv6DnsHosts(), op));
                    }
                    if (this.ipv6GatewayEditor.isFormValueAvailable(op)) {
                        adapter.setIpv6DefaultGateway(this.ipv6GatewayEditor.save((BObject)adapter.get(BTcpIpAdapterSettings.ipv6DefaultGateway), op).toString());
                    }
                }
            }
            if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.loadSlots().get("dhcpdAdapterSettings")) != null && dhcpdAdapterSettings.getIsDhcpdIpv4Supported()) {
                if (this.dhcpdv4EnabledEditor.isFormValueAvailable(op)) {
                    dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(((BBoolean)this.dhcpdv4EnabledEditor.save((BObject)adapter.get(BDhcpdAdapterSettings.isDhcpdIpv4Enabled), op)).getBoolean());
                }
                if (dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
                    if (!this.dhcpdv4DefaultLeaseTimeEditor.isReadonly()) {
                        dhcpdAdapterSettings.setDefaultLeaseTime((BRelTime)this.dhcpdv4DefaultLeaseTimeEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.defaultLeaseTime), op));
                    }
                    if (!this.dhcpdv4MaxLeaseTimeEditor.isReadonly()) {
                        dhcpdAdapterSettings.setMaxLeaseTime((BRelTime)this.dhcpdv4MaxLeaseTimeEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.maxLeaseTime), op));
                    }
                    if (this.dhcpdv4SubnetEditor.isFormValueAvailable(op)) {
                        dhcpdAdapterSettings.setSubnet(this.dhcpdv4SubnetEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.subnet), op).toString());
                    }
                    if (this.dhcpdv4NetmaskEditor.isFormValueAvailable(op)) {
                        dhcpdAdapterSettings.setSubnetMask(this.dhcpdv4NetmaskEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.subnetMask), op).toString());
                    }
                    if (this.dhcpdv4ClientRangeLowEditor.isFormValueAvailable(op)) {
                        dhcpdAdapterSettings.setStartClientAddress(this.dhcpdv4ClientRangeLowEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.startClientAddress), op).toString());
                    }
                    if (!this.dhcpdv4MaxClientsEditor.isReadonly()) {
                        dhcpdAdapterSettings.setRange(((BInteger)this.dhcpdv4MaxClientsEditor.save((BObject)dhcpdAdapterSettings.get(BDhcpdAdapterSettings.range), op)).getInt());
                    }
                }
            }
        }
        return adapter;
    }

    private void updatePermanentReadonly(HxOp op) {
        BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)op.get();
        adapter.getHostSettings().lease(Integer.MAX_VALUE);
        boolean operatorCanWrite = op.canWrite();
        boolean isAdapterReadonly = adapter.getIsAdapterReadonly() || adapter.getHostSettings().getIsReadonly();
        boolean initialAdapterEnabled = adapter.getIsAdapterEnabled();
        boolean canDisableAdapter = !isAdapterReadonly && adapter.getCanDisableAdapter();
        boolean canUseDhcp = adapter.getCanUseDhcp();
        boolean isIpv6Supported = adapter.getIsIpv6Supported();
        boolean isIpv6Readonly = isAdapterReadonly || adapter.getHostSettings().getIsIPv6Readonly();
        boolean initialIpv6Enabled = adapter.getIsIpv6Enabled();
        boolean canDisableIpv6 = !isAdapterReadonly && adapter.getCanDisableIpv6();
        boolean canUseIpv6Dhcp = adapter.getCanUseIpv6Dhcp();
        this.adapterEnabledEditor.setReadonly(isAdapterReadonly || !operatorCanWrite || !canDisableAdapter);
        boolean baseAdapterReadonly = isAdapterReadonly || !operatorCanWrite || !initialAdapterEnabled && !canDisableAdapter;
        this.dhcpEnabledEditor.setReadonly(baseAdapterReadonly || !canUseDhcp);
        this.ipAddressEditor.setReadonly(baseAdapterReadonly);
        this.subnetMaskEditor.setReadonly(baseAdapterReadonly);
        if (adapter.getUsesAdapterLevelSettings()) {
            this.gatewayEditor.setReadonly(baseAdapterReadonly);
            this.dnsEditor.setReadonly(baseAdapterReadonly);
            this.domainEditor.setReadonly(baseAdapterReadonly);
        } else {
            this.gatewayEditor.setReadonly(true);
            this.dnsEditor.setReadonly(true);
            this.domainEditor.setReadonly(true);
        }
        if (isIpv6Supported) {
            this.ipv6EnabledEditor.setReadonly(baseAdapterReadonly || isIpv6Readonly || !canDisableIpv6);
            boolean baseIPv6Readonly = baseAdapterReadonly || isIpv6Readonly || !initialIpv6Enabled && !canDisableIpv6;
            this.ipv6DhcpEnabledEditor.setReadonly(baseIPv6Readonly || !canUseIpv6Dhcp);
            this.ipv6AddressEditor.setReadonly(baseIPv6Readonly);
            this.ipv6SubnetPrefixLengthEditor.setReadonly(baseIPv6Readonly);
            if (adapter.getUsesAdapterLevelSettings()) {
                this.ipv6GatewayEditor.setReadonly(baseIPv6Readonly);
                this.ipv6DnsEditor.setReadonly(baseIPv6Readonly);
            } else {
                this.ipv6GatewayEditor.setReadonly(true);
                this.ipv6DnsEditor.setReadonly(true);
            }
        } else {
            this.ipv6EnabledEditor.setReadonly(true);
            this.ipv6DhcpEnabledEditor.setReadonly(true);
            this.ipv6AddressEditor.setReadonly(true);
            this.ipv6SubnetPrefixLengthEditor.setReadonly(true);
            this.ipv6GatewayEditor.setReadonly(true);
            this.ipv6DnsEditor.setReadonly(true);
        }
        boolean canUseDhcpdv4 = false;
        boolean isDhcpdv4Readonly = true;
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.loadSlots().get("dhcpdAdapterSettings");
        if (dhcpdAdapterSettings != null) {
            canUseDhcpdv4 = dhcpdAdapterSettings.getIsDhcpdIpv4Supported();
            boolean bl = isDhcpdv4Readonly = isAdapterReadonly || dhcpdAdapterSettings.getIsReadOnly();
        }
        if (canUseDhcpdv4) {
            boolean baseDhpcdv4Readonly = baseAdapterReadonly || isDhcpdv4Readonly;
            this.dhcpdv4EnabledEditor.setReadonly(baseDhpcdv4Readonly);
            this.dhcpdv4DefaultLeaseTimeEditor.setReadonly(baseDhpcdv4Readonly);
            this.dhcpdv4MaxLeaseTimeEditor.setReadonly(baseDhpcdv4Readonly);
            this.dhcpdv4SubnetEditor.setReadonly(baseDhpcdv4Readonly);
            this.dhcpdv4NetmaskEditor.setReadonly(baseDhpcdv4Readonly);
            this.dhcpdv4ClientRangeLowEditor.setReadonly(baseDhpcdv4Readonly);
            this.dhcpdv4MaxClientsEditor.setReadonly(baseDhpcdv4Readonly);
        } else {
            this.dhcpdv4EnabledEditor.setReadonly(true);
            this.dhcpdv4DefaultLeaseTimeEditor.setReadonly(true);
            this.dhcpdv4MaxLeaseTimeEditor.setReadonly(true);
            this.dhcpdv4NetmaskEditor.setReadonly(true);
            this.dhcpdv4SubnetEditor.setReadonly(true);
            this.dhcpdv4ClientRangeLowEditor.setReadonly(true);
            this.dhcpdv4MaxClientsEditor.setReadonly(true);
        }
    }
}

