/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import com.tridium.platform.hx.util.StringToObjectMap;
import java.util.Map;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;
import javax.baja.util.LexiconText;

public class HxButtonHelper {
    private boolean readonly;
    private Map<String, ? super Object> attrs;

    protected HxButtonHelper(Map<String, ? super Object> attrs) {
        this.attrs = attrs;
    }

    public static HxButtonHelper makeRefresh() {
        StringToObjectMap<String> attrs = new StringToObjectMap<String>();
        attrs.put("onclick", "window.location.reload()");
        attrs.put("value", (String)LexiconText.make((String)"platform", (String)"HxButtonHelper.refresh"));
        attrs.put("class", "button");
        return new HxButtonHelper(attrs);
    }

    public static HxButtonHelper makeSave() {
        return HxButtonHelper.makeSave(null);
    }

    public static HxButtonHelper makeSave(Map<String, Object> pAttrs) {
        StringToObjectMap<Object> attrs = new StringToObjectMap<Object>();
        attrs.put("value", (Object)LexiconText.make((String)"platform", (String)"HxButtonHelper.save"));
        attrs.put("class", (Object)"button");
        attrs.put("type", (Object)"submit");
        if (pAttrs != null) {
            attrs.putAll(pAttrs);
        }
        return new HxButtonHelper(attrs);
    }

    public static HxButtonHelper make(LexiconText buttonText) {
        return HxButtonHelper.make(buttonText, null);
    }

    public static HxButtonHelper make(LexiconText buttonText, Map<String, Object> pAttrs) {
        StringToObjectMap<Object> attrs = new StringToObjectMap<Object>();
        attrs.put("value", (Object)buttonText);
        attrs.put("class", (Object)"button");
        if (pAttrs != null) {
            attrs.putAll(pAttrs);
        }
        return new HxButtonHelper(attrs);
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void write(HxOp op) throws Exception {
        this.write(op, null);
    }

    public void write(HxOp op, Map<String, ? super Object> extraAttrs) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<input ");
        StringToObjectMap<? super Object> m = new StringToObjectMap<Object>(this.attrs);
        if (extraAttrs != null) {
            m.putAll(extraAttrs);
        }
        String inputClass = m.getString("class", "button");
        out.w((Object)"class='").w((Object)inputClass).w((Object)"' ");
        if (inputClass.equals("button")) {
            String inputType = TextUtil.toLowerCase((String)m.getString("type", "button"));
            if (inputType.equals("submit") && m.containsKey("onclick")) {
                inputType = "button";
            }
            out.w((Object)"type='").w((Object)inputType).w((Object)"' ");
        }
        for (String key : m.keySet()) {
            String lc = TextUtil.toLowerCase((String)key);
            if (lc.equals("class") || lc.equals("disabled") || lc.equals("type")) continue;
            out.w((Object)key).w((Object)"='").w((Object)m.getString(key, op)).w((Object)"' ");
        }
        if (this.isReadonly()) {
            out.w((Object)"disabled='true' ");
        }
        out.println("/>");
    }
}

