/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.fox.BLicenseChannel;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.BLicensePlatformService;
import com.tridium.platform.license.BrandProps;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseModel;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.license.BFileInfoList;
import com.tridium.platform.ui.license.FileInfoListModel;
import com.tridium.platform.ui.license.UiUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.sys.Nre;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.ui.util.LabelUtil;
import com.tridium.util.ArrayUtil;
import com.tridium.workbench.tools.BRequestLicenseTool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.xml.XElem;

@NiagaraType(agent={@AgentOn(types={"platform:LicensePlatformService"}, requiredPermissions="W")})
public class BLicensePlatformServicePlugin
extends BWbComponentView
implements CommandBindings.Support {
    @Generated
    public static final Type TYPE = Sys.loadType(BLicensePlatformServicePlugin.class);
    private static IFileFilter licenseFilter = new ExtFileFilter("TODO", "license,lar");
    private static IFileFilter larFilter = new ExtFileFilter("TODO", "lar");
    private static IFilePathFilter larPathFilter = new ExtPathFilter("lar");
    private static IFileFilter certFilter = new ExtFileFilter("TODO", "certificate");
    private BLabel hostNameLabel;
    private BLabel hostIdLabel;
    private BGridPane hostIdInfoPane;
    private BLabel hostIdIndicator;
    private BLabel brandIdLabel;
    private BIBeamPane contentPane = new BIBeamPane();
    private BFileInfoList certs;
    private FileInfoListModel certModel;
    private BFileInfoList licenses;
    private FileInfoListModel licenseModel;
    private CommandBindings.ListSelection licensesSelection;
    private CommandBindings.ListSelection certsSelection;
    private FilePath licenseFilepath;
    private FilePath certFilepath;
    private Version niagaraVersion;
    private BFileSpace fileSpace;
    private String brandId;
    private String hostId;
    private boolean isLicenseReadonly;
    private boolean isNiagaraHomeReadonly;
    private boolean isBrandChangeAllowed;
    private BHostIdStatus hostIdStatus;
    private BButtonPane licenseButtons;
    private ImportCommand importLicenseCommand;
    private ExportCommand exportLicenseCommand;
    private Command viewLicenseCommand;
    private Command deleteLicenseCommand;
    private ChangeBrandLicenseCommand changeBrandLicenseCommand;
    private BTextField brandField;
    private BButtonPane certButtons;
    private AddCertCommand addCertCommand;
    private Command viewCertificateCommand;
    private Command deleteCertificateCommand;
    private static final String LICENSE_DB_FOLDER = "db";
    private static final Lexicon lex = Lexicon.make((String)"platform");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLicensePlatformServicePlugin() {
        BGridPane upperPane = new BGridPane(2);
        upperPane.setHalign(BHalign.left);
        upperPane.setValign(BValign.top);
        upperPane.setColumnGap(10.0);
        upperPane.setRowGap(6.0);
        this.hostIdInfoPane = new BGridPane(2);
        this.hostIdLabel = new BLabel();
        this.hostIdInfoPane.add(null, (BValue)this.hostIdLabel);
        this.hostIdIndicator = new BLabel();
        this.hostIdInfoPane.add(null, (BValue)this.hostIdIndicator);
        upperPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicensePlatformServicePlugin.hostNameLabel"), (boolean)true));
        this.hostNameLabel = new BLabel();
        upperPane.add(null, (BValue)this.hostNameLabel);
        upperPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicensePlatformServicePlugin.hostIdLabel"), (boolean)true));
        upperPane.add(null, (BValue)this.hostIdInfoPane);
        upperPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicensePlatformServicePlugin.brandIdLabel"), (boolean)true));
        this.brandIdLabel = new BLabel();
        upperPane.add(null, (BValue)this.brandIdLabel);
        this.contentPane.setTop((BWidget)new BBorderPane((BWidget)upperPane, 0.0, 0.0, 6.0, 0.0));
        this.contentPane.setCenter(new BBox(20.0, 0.0));
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)new BBorderPane((BWidget)this.contentPane)));
        this.autoRegisterForComponentEvents = false;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BLicensePlatformService service = (BLicensePlatformService)value;
        this.registerForComponentEvents((BComponent)service, 4);
        service.poll();
        this.hostNameLabel.setText(service.getHost().getNavDisplayName(null));
        BSystemPlatformService system = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        system.poll();
        system.lease();
        this.hostId = system.getHostId();
        this.hostIdLabel.setText(this.hostId);
        this.hostIdStatus = system.getHostIdStatus();
        if (this.hostIdStatus != BHostIdStatus.perpetual) {
            this.hostIdIndicator.setImage(this.getHostIdStatusIndicatorImage(this.hostIdStatus));
            this.hostIdIndicator.setText(this.getHostIdFaultCause(this.hostIdStatus));
        }
        this.niagaraVersion = system.getNiagaraVersion().equals("") ? new Version("3.0") : new Version(system.getNiagaraVersion());
        this.isLicenseReadonly = system.getIsLicenseReadonly();
        this.isBrandChangeAllowed = system.getAllowBrandChange();
        this.isNiagaraHomeReadonly = system.getIsNiagaraHomeReadonly();
        this.licenseButtons = new BButtonPane();
        this.certButtons = new BButtonPane();
        this.licenseFilepath = SystemFilePaths.getLicensesDirPath((boolean)true, (boolean)this.hostIdStatus.isPerpetual(), (boolean)this.isNiagaraHomeReadonly);
        this.licenseModel = new FileInfoListModel(this.licenseFilepath, "license", LicenseInfo.class);
        this.licenses = new BFileInfoList(this.licenseModel, licenseFilter, new LicenseValidator(), new LicenseTransfer());
        this.importLicenseCommand = new ImportCommand(this.licenses);
        this.exportLicenseCommand = new ExportCommand(this.licenses);
        this.viewLicenseCommand = this.licenses.getViewCommand();
        this.deleteLicenseCommand = this.licenses.getDeleteCommand();
        this.changeBrandLicenseCommand = new ChangeBrandLicenseCommand(this.licenses);
        CommandBindings bindings = new CommandBindings();
        bindings.addCommand(this.importLicenseCommand, BCommandEnablePolicy.always);
        bindings.addCommand(this.exportLicenseCommand, BCommandEnablePolicy.anySelection);
        bindings.addCommand(this.viewLicenseCommand, BCommandEnablePolicy.singleSelection);
        bindings.addCommand(this.deleteLicenseCommand, BCommandEnablePolicy.anySelection);
        bindings.addCommand(this.changeBrandLicenseCommand, BCommandEnablePolicy.always);
        bindings.setDoubleClickCommand(this.viewLicenseCommand);
        bindings.setSupport(this);
        this.licenses.setController(new FileListController(bindings));
        this.licensesSelection = new CommandBindings.ListSelection(bindings);
        this.licenses.setSelection(this.licensesSelection);
        this.licenses.setMultipleSelection(true);
        this.licenseButtons.setUniformColumnWidth(false);
        this.licenseButtons.add(this.importLicenseCommand);
        this.licenseButtons.add(this.exportLicenseCommand);
        this.licenseButtons.add(this.viewLicenseCommand);
        this.licenseButtons.add(this.deleteLicenseCommand);
        this.certFilepath = SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)this.hostIdStatus.isPerpetual(), (boolean)this.isNiagaraHomeReadonly);
        this.certModel = new FileInfoListModel(this.certFilepath, "certificate", CertificateInfo.class);
        this.certs = new BFileInfoList(this.certModel, certFilter, new CertificateTransfer());
        this.addCertCommand = new AddCertCommand(this.certs);
        this.viewCertificateCommand = this.certs.getViewCommand();
        this.deleteCertificateCommand = this.certs.getDeleteCommand();
        bindings = new CommandBindings();
        bindings.addCommand(this.addCertCommand, BCommandEnablePolicy.always);
        bindings.addCommand(this.viewCertificateCommand, BCommandEnablePolicy.singleSelection);
        bindings.addCommand(this.deleteCertificateCommand, BCommandEnablePolicy.anySelection);
        bindings.setDoubleClickCommand(this.viewCertificateCommand);
        bindings.setSupport(this);
        this.certs.setController(new FileListController(bindings));
        this.certsSelection = new CommandBindings.ListSelection(bindings);
        this.certs.setSelection(this.certsSelection);
        this.certs.setMultipleSelection(true);
        this.certButtons.setUniformColumnWidth(false);
        this.certButtons.add(this.addCertCommand);
        this.certButtons.add(this.viewCertificateCommand);
        this.certButtons.add(this.deleteCertificateCommand);
        BLabel label = new BLabel(lex.getText("LicensePlatformServicePlugin.licenseList.header"));
        this.contentPane.setLeft((BWidget)new BEdgePane((BWidget)label, (BWidget)this.licenseButtons, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.licenses, BBorder.inset, BInsets.DEFAULT), 5.0, 0.0, 5.0, 0.0)));
        label.setHalign(BHalign.left);
        label = new BLabel(lex.getText("LicensePlatformServicePlugin.certList.header"));
        this.contentPane.setRight((BWidget)new BEdgePane((BWidget)label, (BWidget)this.certButtons, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.certs, BBorder.inset, BInsets.DEFAULT), 5.0, 0.0, 5.0, 0.0)));
        label.setHalign(BHalign.left);
        this.fileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)service);
        this.certModel.loadValue(this.fileSpace);
        this.licenseModel.loadValue(this.fileSpace);
        this.findBrandId();
        this.licensesSelection.setCommandEnabledStates();
        this.certsSelection.setCommandEnabledStates();
    }

    @Override
    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        boolean combinedEnabledState = false;
        combinedEnabledState = command == this.importLicenseCommand || command == this.deleteLicenseCommand || command == this.addCertCommand || command == this.deleteCertificateCommand ? bindingBasedState && !this.isLicenseReadonly : (command == this.changeBrandLicenseCommand ? bindingBasedState && !this.isLicenseReadonly && this.isBrandChangeAllowed : bindingBasedState);
        command.setEnabled(combinedEnabledState);
    }

    protected void findBrandId() throws Exception {
        this.brandId = null;
        for (int i = 0; this.brandId == null && i < this.licenseModel.getItemCount(); ++i) {
            VendorLicense lic = ((LicenseInfo)this.licenseModel.getInfo((int)i)).vendorLicense;
            this.brandId = lic.getBrandId();
        }
        if (this.brandId == null) {
            this.brandId = new BrandProps(this.fileSpace).get("brand.id", null);
        }
        this.brandIdLabel.setText(this.brandId == null ? "" : this.brandId);
    }

    protected boolean isPerpetual() {
        return this.hostIdStatus == null || this.hostIdStatus == BHostIdStatus.perpetual;
    }

    protected LicenseInfo[] getDatabaseLicenses() throws Exception {
        ArrayList<LicenseInfo> result = new ArrayList<LicenseInfo>();
        VendorLicense[] dbLicenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.hostId);
        String b = this.brandId;
        for (VendorLicense dbLicense : dbLicenses) {
            if (dbLicense.getBrandId() != null && b != null && !b.equals(dbLicense.getBrandId())) continue;
            result.add(new LicenseInfo(dbLicense, null));
            b = dbLicense.getBrandId();
        }
        return (LicenseInfo[])ArrayUtil.arrayFromCollection(result, LicenseInfo[]::new);
    }

    protected void saveToStation(IFileInfo fileInfo) throws Exception {
        long size = fileInfo.getXmlContent().length();
        BFoxSession foxSession = (BFoxSession)this.fileSpace.getSession();
        BLicenseChannel licenseChannel = (BLicenseChannel)foxSession.getConnection().getChannels().get("license", BLicenseChannel.TYPE);
        FoxMessage message = new FoxMessage();
        message.add("dir", false);
        message.add("readonly", false);
        message.add("modified", BAbsTime.now().getMillis());
        message.add("size", String.valueOf(size));
        message.add("permissions", "rw");
        BFoxFileStore fileStore = BFileChannel.msgToStore((BFoxFileSpace)((BFoxFileSpace)this.fileSpace), (FilePath)fileInfo.getInstalledFilePath(true, this.isPerpetual(), this.isNiagaraHomeReadonly), (FoxMessage)message);
        try (OutputStream out = licenseChannel.write(fileStore);){
            fileInfo.write(out);
        }
    }

    protected void removeFromStation(IFileInfo fileInfo) throws Exception {
        long size = fileInfo.getXmlContent().length();
        BFoxSession foxSession = (BFoxSession)this.fileSpace.getSession();
        BLicenseChannel licenseChannel = (BLicenseChannel)foxSession.getConnection().getChannels().get("license", BLicenseChannel.TYPE);
        FoxMessage message = new FoxMessage();
        message.add("dir", false);
        message.add("readonly", false);
        message.add("modified", BAbsTime.now().getMillis());
        message.add("size", String.valueOf(size));
        message.add("permissions", "rw");
        BFoxFileStore fileStore = BFileChannel.msgToStore((BFoxFileSpace)((BFoxFileSpace)this.fileSpace), (FilePath)fileInfo.getInstalledFilePath(true, this.isPerpetual(), this.isNiagaraHomeReadonly), (FoxMessage)message);
        licenseChannel.delete(fileStore);
    }

    protected void sync(LicenseSync<LicenseInfo> licenseSync, LicenseSync<CertificateInfo> certSync) throws Exception {
        CertificateInfo update;
        CertificateInfo add;
        int i;
        int count;
        ArrayList<IFileInfo> allAdds = new ArrayList<IFileInfo>();
        ArrayList<IFileInfo> allUpdates = new ArrayList<IFileInfo>();
        ArrayList<IFileInfo> allRemoves = new ArrayList<IFileInfo>();
        boolean anyChanges = false;
        boolean restart = false;
        if (licenseSync != null) {
            count = licenseSync.toRemove.size();
            allRemoves.addAll(licenseSync.toRemove);
            for (i = 0; i < count; ++i) {
                LicenseInfo remove = (LicenseInfo)licenseSync.toRemove.get(i);
                this.removeFromStation((IFileInfo)remove);
                anyChanges = true;
            }
            count = licenseSync.toAdd.size();
            allAdds.addAll(licenseSync.toAdd);
            for (i = 0; i < count; ++i) {
                add = (LicenseInfo)licenseSync.toAdd.get(i);
                this.saveToStation((IFileInfo)add);
                restart = true;
                anyChanges = true;
            }
            count = licenseSync.toUpdate.size();
            allUpdates.addAll(licenseSync.toUpdate);
            for (i = 0; i < count; ++i) {
                update = (LicenseInfo)licenseSync.toUpdate.get(i);
                this.saveToStation((IFileInfo)update);
                restart = true;
                anyChanges = true;
            }
        }
        if (certSync != null) {
            count = certSync.toAdd.size();
            allAdds.addAll(certSync.toAdd);
            for (i = 0; i < count; ++i) {
                add = (CertificateInfo)certSync.toAdd.get(i);
                this.saveToStation((IFileInfo)add);
                anyChanges = true;
            }
            count = certSync.toUpdate.size();
            allUpdates.addAll(certSync.toUpdate);
            for (i = 0; i < count; ++i) {
                update = (CertificateInfo)certSync.toUpdate.get(i);
                this.saveToStation((IFileInfo)update);
                anyChanges = true;
            }
        }
        if (anyChanges) {
            if (restart) {
                String requiredMessage;
                BSystemPlatformService sys = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get(this.getCurrentValue());
                sys.lease();
                boolean requireReboot = !sys.getAllowStationRestart();
                boolean hasPermission = requireReboot ? sys.getIsServiceReadonly() : sys.getLocalDaemonAccess().atLeast(BDaemonAccessLevel.restricted);
                String confirmMessage = requireReboot ? lex.getText("LicensePlatformServicePlugin.sync.rebootMessage") : lex.getText("LicensePlatformServicePlugin.sync.restartMessage");
                String string = requiredMessage = requireReboot ? lex.getText("LicensePlatformServicePlugin.sync.rebootRequiredMessage") : lex.getText("LicensePlatformServicePlugin.sync.restartRequiredMessage");
                if (hasPermission) {
                    BWidget content = UiUtil.buildUpdateDescription(lex.getText("LicensePlatformServicePlugin.sync.successMessage"), confirmMessage, allAdds, allUpdates, allRemoves);
                    if (4 == BDialog.confirm((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.successTitle"), (Object)content, (int)12)) {
                        sys.restartStation();
                        return;
                    }
                } else {
                    BWidget content = UiUtil.buildUpdateDescription(lex.getText("LicensePlatformServicePlugin.sync.successMessage"), requiredMessage, allAdds, allUpdates, allRemoves);
                    BDialog.message((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.successTitle"), (Object)content);
                }
            } else {
                BWidget content = UiUtil.buildUpdateDescription(lex.getText("LicensePlatformServicePlugin.sync.successMessage"), null, allAdds, allUpdates, allRemoves);
                BDialog.message((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.successTitle"), (Object)content);
            }
            this.loadValue(this.getCurrentValue());
        } else if (this.isPerpetual()) {
            BDialog.message((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.currentTitle"), (Object)lex.getText("LicensePlatformServicePlugin.sync.currentMessage"));
        }
    }

    public BImage getHostIdStatusIndicatorImage(BHostIdStatus hostIdStatus) {
        if (hostIdStatus == BHostIdStatus.unregistered) {
            return BImage.make((BIcon)BIcon.std((String)"questionMark.png"));
        }
        if (hostIdStatus == BHostIdStatus.cloned) {
            return BImage.make((BIcon)BIcon.std((String)"error.png"));
        }
        return BImage.make((BIcon)BIcon.std((String)"check.png"));
    }

    public String getHostIdFaultCause(BHostIdStatus hostIdStatus) {
        if (hostIdStatus == BHostIdStatus.cloned || hostIdStatus == BHostIdStatus.unregistered) {
            return this.getLexicon().getText("LicenseManager.hostIdFaultCause." + hostIdStatus.getTag());
        }
        return "";
    }

    private boolean brandedLicenseExists(List<VendorLicense> licenses) {
        for (VendorLicense license : licenses) {
            if (license.getBrandId() == null || license.getBrandId().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private class ChangeBrandLicenseCommand
    extends AsyncCommand {
        public ChangeBrandLicenseCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicensePlatformServicePlugin.changeBrandLicense");
            this.setEnabled(false);
        }

        @Override
        public void doInvokeAsync() {
            try {
                if (BLicensePlatformServicePlugin.this.isLicenseReadonly) {
                    throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.readonlyLicenses");
                }
                if (!BLicensePlatformServicePlugin.this.isBrandChangeAllowed) {
                    throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.readonlyBrand");
                }
                BGridPane grid = new BGridPane(1);
                BEdgePane pane = new BEdgePane();
                pane.setTop((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandMessage")));
                BGridPane brandGrid = new BGridPane(1);
                BLicensePlatformServicePlugin.this.brandField = new BTextField("", 40);
                BLicensePlatformServicePlugin.this.brandField.setEnabled(true);
                brandGrid.add("brandField", (BValue)BLicensePlatformServicePlugin.this.brandField);
                pane.setCenter((BWidget)brandGrid);
                grid.add(null, (BValue)pane);
                if (2 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    return;
                }
                if (BLicensePlatformServicePlugin.this.brandId == null) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandLicense.noExistingBrand")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                String newBrand = BLicensePlatformServicePlugin.this.brandField.getText();
                if (newBrand.isEmpty() || BLicensePlatformServicePlugin.this.brandId.equals(newBrand)) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandLicense.brandNotUnique")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                LicenseInfo[] existingLicenses = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenses.getFileInfoListModel().getInfo();
                if (existingLicenses == null || existingLicenses.length == 0) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandLicense.noDeviceLicense")), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                boolean checkAgainstLocalLicenseDb = true;
                ArrayList<VendorLicense> brandedLicenses = new ArrayList<VendorLicense>();
                if (!PortalLicenseUtil.isApiAvailable()) {
                    BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandLicense.noPortalApi")), 10.0, 10.0, 10.0, 10.0), (int)1);
                    return;
                }
                try {
                    List brandedModels = PortalLicenseUtil.getExistingLicenses((String)BLicensePlatformServicePlugin.this.hostId, (String)newBrand, null);
                    block6: for (Object brandedModel : brandedModels) {
                        for (XElem licenseElem : brandedModel.getLicenseElements()) {
                            VendorLicense brandedLicense = VendorLicense.make((String)"portal", (XElem)licenseElem);
                            brandedLicense.load("portal", licenseElem);
                            LicenseDatabase.LOCAL_INSTANCE.add(brandedLicense);
                            String vendorLicenseBrand = brandedLicense.getBrandId();
                            if (vendorLicenseBrand == null || !vendorLicenseBrand.equals(newBrand)) continue;
                            brandedLicenses.add(brandedLicense);
                            checkAgainstLocalLicenseDb = false;
                            continue block6;
                        }
                    }
                }
                catch (Exception e) {
                    BPlatform.log.log(Level.WARNING, lex.getText("LicensePlatformServicePlugin.changeBrandLicense.portalLicensesError"), e);
                }
                if (checkAgainstLocalLicenseDb) {
                    VendorLicense[] dbLicenses = LicenseDatabase.LOCAL_INSTANCE.getLicenses(BLicensePlatformServicePlugin.this.hostId, newBrand);
                    Collections.addAll(brandedLicenses, dbLicenses);
                }
                if (brandedLicenses.isEmpty() || !BLicensePlatformServicePlugin.this.brandedLicenseExists(brandedLicenses)) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandLicense.noLicenses", new Object[]{newBrand})), 10.0, 10.0, 10.0, 10.0));
                    return;
                }
                if (2 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandWarning")), 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    return;
                }
                ArrayList<LicenseInfo> toAdd = new ArrayList<LicenseInfo>();
                Feature.Brand brandFeature = null;
                for (VendorLicense license : brandedLicenses) {
                    brandFeature = license.getBrandFeature();
                    FilePath brandedLicenseFilePath = BLicensePlatformServicePlugin.this.licenseFilepath.merge(BLicensePlatformServicePlugin.LICENSE_DB_FOLDER).merge(BLicensePlatformServicePlugin.this.hostId).merge(license.getLicenseName() + ".license");
                    BIFile brandedLicenseFile = BFileSystem.INSTANCE.findFile(brandedLicenseFilePath);
                    toAdd.add(new LicenseInfo(license, brandedLicenseFile));
                }
                try {
                    LicenseSync sync = PortalLicenseUtil.syncLicenses((String)BLicensePlatformServicePlugin.this.hostId, (Feature.Brand)brandFeature, (LicenseInfo[])existingLicenses, (LicenseInfo[])toAdd.toArray(new LicenseInfo[0]));
                    BLicensePlatformServicePlugin.this.sync((LicenseSync<LicenseInfo>)sync, null);
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.changeBrandLicense.dialogTitle"), (Object)new BBorderPane((BWidget)new BLabel(lex.getText("LicensePlatformServicePlugin.changeBrandLicense.licenseChangeFailed")), 10.0, 10.0, 10.0, 10.0), (Throwable)e);
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
        }
    }

    private class CertificateTransfer
    implements BFileInfoList.ListTransfer {
        private CertificateTransfer() {
        }

        @Override
        public void processFile(BIFile file) throws Exception {
            CertificateInfo[] toInstall = new CertificateInfo[]{new CertificateInfo(file)};
            CertificateInfo[] installed = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
            LicenseSync sync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installed, (CertificateInfo[])toInstall);
            BLicensePlatformServicePlugin.this.sync(null, (LicenseSync<CertificateInfo>)sync);
        }
    }

    private class LicenseTransfer
    implements BFileInfoList.ListTransfer {
        private LicenseTransfer() {
        }

        @Override
        public void processFile(BIFile file) throws Exception {
            LicenseInfo[] toInstall = PortalLicenseUtil.getLicenseInfo((BIFile)file, (String)BLicensePlatformServicePlugin.this.hostId, (String)BLicensePlatformServicePlugin.this.brandId);
            LicenseInfo[] installed = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            LicenseSync sync = PortalLicenseUtil.syncLicenses((String)BLicensePlatformServicePlugin.this.hostId, (LicenseInfo[])installed, (LicenseInfo[])toInstall);
            BLicensePlatformServicePlugin.this.sync((LicenseSync<LicenseInfo>)sync, null);
        }
    }

    private class AddCertCommand
    extends AsyncCommand {
        public AddCertCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicensePlatformServicePlugin.addCert");
        }

        @Override
        public void doInvokeAsync() {
            block6: {
                try {
                    BIFile[] certfiles;
                    if (BLicensePlatformServicePlugin.this.isLicenseReadonly) {
                        throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.readonlyCertificates");
                    }
                    BIFile currentSelection = BFileSystem.INSTANCE.findFile(SystemFilePaths.getCertificatesDirPath((boolean)true));
                    if (currentSelection == null) {
                        currentSelection = BFileSystem.INSTANCE.getSysHome();
                    }
                    if ((certfiles = BFileChooserDialog.chooseFiles(this.getOwner(), BImage.make((String)lex.getText("LicensePlatformServicePlugin.addCertDialog.icon")), lex.getText("LicensePlatformServicePlugin.addCertDialog.title"), lex.getText("LicensePlatformServicePlugin.addCertDialog.message", new Object[]{BLicensePlatformServicePlugin.this.hostNameLabel.getText()}), currentSelection, certFilter, certFilter)).length <= 0) break block6;
                    try {
                        CertificateInfo[] toInstall = CertificateInfo.make((BIFile[])certfiles);
                        CertificateInfo[] installed = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
                        LicenseSync sync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installed, (CertificateInfo[])toInstall);
                        BLicensePlatformServicePlugin.this.sync(null, (LicenseSync<CertificateInfo>)sync);
                    }
                    catch (Exception e) {
                        throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.addCertException", (Throwable)e);
                    }
                    BLicensePlatformServicePlugin.this.loadValue(BLicensePlatformServicePlugin.this.getCurrentValue());
                }
                catch (Throwable t) {
                    CommandUtil.error(this, t);
                }
            }
        }
    }

    private class ImportCommand
    extends AsyncCommand {
        public ImportCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicensePlatformServicePlugin.importLicense");
        }

        private void importFile() throws Exception {
            BIFile currentSelection = BFileSystem.INSTANCE.findFile(SystemFilePaths.getLicensesDirPath((boolean)true));
            if (currentSelection == null) {
                currentSelection = BFileSystem.INSTANCE.getSysHome();
            }
            BIFile[] files = BFileChooserDialog.chooseFiles(this.getOwner(), BImage.make((String)lex.getText("LicensePlatformServicePlugin.importFileDialog.icon")), lex.getText("LicensePlatformServicePlugin.importFileDialog.title"), lex.getText("LicensePlatformServicePlugin.importFileDialog.message", new Object[]{BLicensePlatformServicePlugin.this.hostNameLabel.getText()}), currentSelection, licenseFilter, licenseFilter, new LicenseListModel());
            List validated = Arrays.asList(files).stream().filter(new LicenseValidator()::accept).collect(Collectors.toList());
            if (validated.size() == 0) {
                return;
            }
            LicenseInfo[] toInstall = PortalLicenseUtil.getLicenseInfo((BIFile[])((BIFile[])ArrayUtil.arrayFromCollection(validated, BIFile[]::new)), (String)BLicensePlatformServicePlugin.this.hostId, (String)BLicensePlatformServicePlugin.this.brandId);
            LicenseInfo[] installed = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            LicenseSync sync = PortalLicenseUtil.syncLicenses((String)BLicensePlatformServicePlugin.this.hostId, (LicenseInfo[])installed, (LicenseInfo[])toInstall);
            BLicensePlatformServicePlugin.this.sync((LicenseSync<LicenseInfo>)sync, null);
        }

        public void requestLicense() {
            UiUtil.requestLicense(this.getOwner().getShell(), BLicensePlatformServicePlugin.this.hostId);
        }

        public void getOnline() throws Exception {
            LicenseInfo[] installedLicenses = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            CertificateInfo[] installedCerts = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
            HashSet<String> vendorSet = new HashSet<String>();
            for (LicenseInfo licenseInfo : installedLicenses) {
                vendorSet.add(licenseInfo.vendorLicense.getVendor());
            }
            for (LicenseInfo exception : installedCerts) {
                vendorSet.add(exception.vendorCertificate.getVendor());
            }
            boolean mustRequest = true;
            LicenseSync licenseSync = null;
            LicenseSync certSync = null;
            try {
                List exception = PortalLicenseUtil.getExistingLicenses((String)BLicensePlatformServicePlugin.this.hostId, (String)BLicensePlatformServicePlugin.this.brandId, (Version)BLicensePlatformServicePlugin.this.niagaraVersion);
                List existingLicenseList = exception.size() == 0 ? Collections.emptyList() : ((LicenseModel)exception.get(0)).getLicenseInfos();
                LicenseInfo[] portalLicenses = existingLicenseList.toArray(new LicenseInfo[0]);
                licenseSync = PortalLicenseUtil.syncLicenses((String)BLicensePlatformServicePlugin.this.hostId, (LicenseInfo[])installedLicenses, (LicenseInfo[])portalLicenses);
                for (LicenseInfo portalLicense : portalLicenses) {
                    vendorSet.add(portalLicense.vendorLicense.getVendor());
                }
                mustRequest = licenseSync.unchanged() && LicenseInfo.countActiveLicenses((LicenseInfo[])installedLicenses, (BAbsTime)BAbsTime.now()) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String[] stringArray = vendorSet.toArray(new String[0]);
                CertificateInfo[] portalCerts = CertificateInfo.make((XElem[])PortalLicenseUtil.getCertificates((String[])stringArray));
                certSync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installedCerts, (CertificateInfo[])portalCerts);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BLicensePlatformServicePlugin.this.sync(licenseSync, certSync);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mustRequest) {
                BRequestLicenseTool.requestLicense((BWidget)BLicensePlatformServicePlugin.this.getWbShell(), (String)BLicensePlatformServicePlugin.this.hostId);
            }
        }

        public void getEntitlement() throws Exception {
            BLicenseChannel licenseChannel;
            LicenseInfo[] installedLicenses = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            CertificateInfo[] installedCerts = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
            HashSet<LicenseInfo> entitlementLicenses = new HashSet<LicenseInfo>();
            HashSet<CertificateInfo> entitlementCerts = new HashSet<CertificateInfo>();
            HashSet<VendorLicense> vendorLicenses = new HashSet<VendorLicense>();
            HashSet<VendorCertificate> vendorCerts = new HashSet<VendorCertificate>();
            HashSet<String> entitlementLicenseVendors = new HashSet<String>();
            for (LicenseInfo licenseInfo : installedLicenses) {
                vendorLicenses.add(licenseInfo.vendorLicense);
            }
            for (LicenseInfo licenseInfo : installedCerts) {
                vendorCerts.add(licenseInfo.vendorCertificate);
            }
            Exception entitlementException = null;
            LicenseSync licenseSync = null;
            LicenseSync certSync = null;
            try {
                BFoxSession exception = (BFoxSession)BLicensePlatformServicePlugin.this.fileSpace.getSession();
                licenseChannel = (BLicenseChannel)exception.getConnection().getChannels().get("license", BLicenseChannel.TYPE);
                Map licenseList = licenseChannel.updateentitlements();
                for (String vendor : licenseList.keySet()) {
                    ByteArrayInputStream licenseStream = new ByteArrayInputStream(((String)licenseList.get(vendor)).getBytes(StandardCharsets.UTF_8));
                    VendorLicense updatedLicense = VendorLicense.make((String)"entitlement", (InputStream)licenseStream);
                    entitlementLicenses.add(new LicenseInfo(updatedLicense, null));
                    entitlementLicenseVendors.add(updatedLicense.getVendor());
                }
            }
            catch (Exception exception) {
                entitlementException = exception;
            }
            try {
                BFoxSession bFoxSession = (BFoxSession)BLicensePlatformServicePlugin.this.fileSpace.getSession();
                licenseChannel = (BLicenseChannel)bFoxSession.getConnection().getChannels().get("license", BLicenseChannel.TYPE);
                HashSet<String> vendors = new HashSet<String>();
                for (VendorCertificate certificate : vendorCerts) {
                    vendors.add(certificate.getVendor());
                }
                vendors.addAll(entitlementLicenseVendors);
                for (String vendor : vendors) {
                    String certificate = licenseChannel.updatecertificate(vendor);
                    if (certificate == null || certificate.length() == 0) continue;
                    ByteArrayInputStream certStream = new ByteArrayInputStream(certificate.getBytes(StandardCharsets.UTF_8));
                    VendorCertificate updatedCert = VendorCertificate.make((String)"entitlement", (InputStream)certStream);
                    entitlementCerts.add(new CertificateInfo(updatedCert, null));
                }
            }
            catch (Exception exception) {
                entitlementException = exception;
            }
            try {
                licenseSync = PortalLicenseUtil.syncLicenses((String)BLicensePlatformServicePlugin.this.hostId, (LicenseInfo[])installedLicenses, (LicenseInfo[])entitlementLicenses.toArray(new LicenseInfo[0]));
                certSync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installedCerts, (CertificateInfo[])entitlementCerts.toArray(new CertificateInfo[0]));
                if (licenseSync != null || certSync != null) {
                    BLicensePlatformServicePlugin.this.sync((LicenseSync<LicenseInfo>)licenseSync, (LicenseSync<CertificateInfo>)certSync);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entitlementException != null) {
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.sync.currentTitle"), (Object)lex.getText("LicensePlatformServicePlugin.importType.getEntitlement.error"), (Throwable)entitlementException);
            }
        }

        @Override
        public void doInvokeAsync() {
            try {
                if (BLicensePlatformServicePlugin.this.isLicenseReadonly) {
                    throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.readonlyLicenses");
                }
                if (Nre.bootEnv.isRemote()) {
                    this.importFile();
                    return;
                }
                BGridPane grid = new BGridPane(1);
                ToggleCommandGroup grp = new ToggleCommandGroup();
                BRadioButton useFile = new BRadioButton(grp, lex.getText("LicensePlatformServicePlugin.importType.file"), true);
                grid.add(null, (BValue)useFile);
                BRadioButton useDb = new BRadioButton(grp, lex.getText("LicensePlatformServicePlugin.importType.localDb"), false);
                grid.add(null, (BValue)useDb);
                LicenseInfo[] installedLicenses = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
                LicenseInfo[] dbLicenses = BLicensePlatformServicePlugin.this.getDatabaseLicenses();
                LicenseSync dbSync = PortalLicenseUtil.syncLicenses((String)BLicensePlatformServicePlugin.this.hostId, (LicenseInfo[])installedLicenses, (LicenseInfo[])dbLicenses);
                if (dbSync.unchanged()) {
                    useDb.setEnabled(false);
                }
                BRadioButton getOnline = new BRadioButton(grp, lex.getText("LicensePlatformServicePlugin.importType.getOnline"), false);
                BRadioButton requestLicense = new BRadioButton(grp, lex.getText("LicensePlatformServicePlugin.importType.requestLicense"), false);
                BRadioButton getEntitlement = new BRadioButton(grp, lex.getText("LicensePlatformServicePlugin.importType.getEntitlement"), false);
                if (BLicensePlatformServicePlugin.this.isPerpetual()) {
                    if (PortalLicenseUtil.isApiAvailable()) {
                        if (PortalLicenseUtil.requestLicensesOnline()) {
                            grid.add(null, (BValue)getOnline);
                        } else {
                            grid.add(null, (BValue)requestLicense);
                        }
                    }
                } else {
                    grid.add(null, (BValue)getEntitlement);
                }
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.importType.dlgTitle"), (Object)new BBorderPane((BWidget)grid, 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    if (useFile.isSelected()) {
                        this.importFile();
                    } else if (useDb.isSelected()) {
                        BLicensePlatformServicePlugin.this.sync((LicenseSync<LicenseInfo>)dbSync, null);
                    } else if (getOnline.isSelected()) {
                        this.getOnline();
                    } else if (getEntitlement.isSelected()) {
                        this.getEntitlement();
                    } else if (requestLicense.isSelected()) {
                        this.requestLicense();
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
        }
    }

    private class ExportCommand
    extends AsyncCommand {
        public ExportCommand(BList list) {
            super((BWidget)list, TYPE.getModule(), "LicensePlatformServicePlugin.exportLicense");
        }

        @Override
        public void doInvokeAsync() {
            try {
                BDirectory currentSelection = BFileSystem.INSTANCE.getSysHome();
                FilePath path = BFileChooserDialog.chooseFilePath(this.getOwner(), BImage.make((String)lex.getText("LicensePlatformServicePlugin.exportDialog.icon")), lex.getText("LicensePlatformServicePlugin.exportDialog.title"), lex.getText("LicensePlatformServicePlugin.exportDialog.message"), (BIFile)currentSelection, larFilter, larPathFilter, new LicenseListModel(), "licenses.lar");
                if (path != null) {
                    BLicenseArchiveFile dest = (BLicenseArchiveFile)BFileSystem.INSTANCE.findFile(path);
                    if (dest == null) {
                        dest = (BLicenseArchiveFile)BFileSystem.INSTANCE.makeFile(path);
                    } else if (8 == BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.replaceFileDialog.title"), (Object)lex.getText("LicensePlatformServicePlugin.replaceFileDialog.message", new Object[]{path.getName()}))) {
                        return;
                    }
                    if (path.getParent().getBody().equals(SystemFilePaths.getLicensesDirPath((boolean)true).getBody())) {
                        BLicensePlatformServicePlugin.this.licenseModel.reload();
                    }
                    int[] sel = BLicensePlatformServicePlugin.this.licenseModel.getSelection().getItems();
                    VendorLicense[] licenses = new VendorLicense[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        licenses[i] = ((LicenseInfo)((BLicensePlatformServicePlugin)BLicensePlatformServicePlugin.this).licenseModel.getInfo((int)sel[i])).vendorLicense;
                    }
                    dest.writeLicenses(licenses);
                    BDialog.message((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.fileWrittenDialog.title"), (Object)lex.getText("LicensePlatformServicePlugin.fileWrittenDialog.message", new Object[]{path.getName()}));
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
        }
    }

    public static class LicenseListModel
    extends BFileChooserListView.ListModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return UiLexicon.bajaui().getText("fileChooser.name");
                }
                case 1: {
                    return lex.getText("LicensePlatformServicePlugin.hostIdLabel");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            BIFile file = (BIFile)this.kids[row];
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
                case 1: {
                    try {
                        if (file.getExtension() == null || !(file instanceof BLicenseFile)) {
                            return "";
                        }
                        LicenseInfo license = new LicenseInfo(file);
                        return license.vendorLicense.getHostId();
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private class LicenseValidator
    implements IFileFilter,
    IFilter {
        private LicenseValidator() {
        }

        public boolean accept(Object obj) {
            return obj instanceof BIFile && this.accept((BIFile)obj);
        }

        public boolean accept(BIFile file) {
            try {
                if (file instanceof BLicenseFile) {
                    LicenseInfo license = new LicenseInfo(file);
                    if (BLicensePlatformServicePlugin.this.hostId.equals(license.vendorLicense.getHostId())) {
                        if (BLicensePlatformServicePlugin.this.brandId != null && license.vendorLicense.getBrandId() != null && !BLicensePlatformServicePlugin.this.brandId.equals(license.vendorLicense.getBrandId())) {
                            BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.cantChangeBrand.title"), (Object)lex.getText("LicensePlatformServicePlugin.cantChangeBrand.message", new Object[]{license}));
                            return false;
                        }
                        if (license.allowsLocalWbAccess()) {
                            return true;
                        }
                        BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.noAccess.title"), (Object)lex.getText("LicensePlatformServicePlugin.noAccess.message", new Object[]{license}));
                        return false;
                    }
                    BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.badHostId.title"), (Object)lex.getText("LicensePlatformServicePlugin.badHostId.message", new Object[]{license}));
                    return false;
                }
                if (file instanceof BLicenseArchiveFile) {
                    VendorLicense[] vendorLicenses;
                    int nUpdates = 0;
                    for (VendorLicense vendorLicense : vendorLicenses = ((BLicenseArchiveFile)file).getLicenses(BLicensePlatformServicePlugin.this.hostId)) {
                        if (BLicensePlatformServicePlugin.this.brandId != null && vendorLicense.getBrandId() != null && !BLicensePlatformServicePlugin.this.brandId.equals(vendorLicense.getBrandId())) continue;
                        LicenseInfo license = new LicenseInfo(vendorLicense, file);
                        if (!license.allowsLocalWbAccess()) {
                            BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.noAccess.title"), (Object)lex.getText("LicensePlatformServicePlugin.noAccess.message", new Object[]{license}));
                            return false;
                        }
                        ++nUpdates;
                    }
                    if (nUpdates == 0) {
                        BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.noHostLicenses.title"), (Object)lex.getText("LicensePlatformServicePlugin.noHostLicenses.message"));
                        return false;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.addLicenseException", (Throwable)e);
            }
        }

        public String getDescription(Context cx) {
            return "TODO";
        }
    }

    private class FileListController
    extends CommandBindings.ListController {
        public FileListController(CommandBindings bindings) {
            super(bindings);
        }

        public void focusGained(BFocusEvent event) {
            BLicensePlatformServicePlugin.this.setTransferWidget((BTransferWidget)this.getList());
            if (this.getList() == BLicensePlatformServicePlugin.this.certs) {
                BLicensePlatformServicePlugin.this.licenses.getSelection().deselectAll();
            } else {
                BLicensePlatformServicePlugin.this.certs.getSelection().deselectAll();
            }
        }
    }
}

