/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.platform.fox.BLicenseChannel;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import java.util.Arrays;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.list.ListModel;
import javax.baja.util.Version;

public class FileInfoListModel
extends ListModel {
    private Array<IFileInfo> kids = new Array(IFileInfo.class);
    private FilePath directoryPath;
    private String ext;
    private BFileSpace space;
    private Class<?> elementClass;

    public FileInfoListModel(FilePath pDirectoryPath, String pExt, Class<?> pElementClass) {
        this.directoryPath = pDirectoryPath;
        this.ext = pExt;
        this.elementClass = pElementClass;
    }

    public int getItemCount() {
        return this.kids.size();
    }

    public Object getItem(int index) {
        return this.getFileName(index);
    }

    public IFileInfo getInfo(int index) {
        return (IFileInfo)this.kids.get(index);
    }

    public BIFile getFile(int index) {
        return this.getInfo(index).getFile();
    }

    public String getFileName(int index) {
        return this.getFile(index).getFileName();
    }

    public int getFileSize(int index) {
        return (int)this.getFile(index).getSize();
    }

    public synchronized IFileInfo[] getInfo() {
        IFileInfo[] result = (IFileInfo[])java.lang.reflect.Array.newInstance(this.elementClass, this.getItemCount());
        for (int i = 0; i < this.getItemCount(); ++i) {
            result[i] = this.getInfo(i);
        }
        return result;
    }

    public FilePath getFilePath(int index) {
        return this.directoryPath.merge(this.getFileName(index));
    }

    public InputStream getFileContentStream(int index) {
        BLicenseChannel channel = this.getChannel();
        if (channel != null) {
            try {
                return channel.read((BFoxFileStore)this.getFile(index).getStore());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return this.getFile(index).getInputStream();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void deleteFiles(int[] indices) {
        try {
            for (int index : indices) {
                this.getChannel().delete((BFoxFileStore)this.getFile(index).getStore());
            }
            Arrays.sort(indices);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.kids.remove(indices[i]);
            }
            this.updateList();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void deleteFile(int index) {
        try {
            this.getChannel().delete((BFoxFileStore)this.getFile(index).getStore());
            this.kids.remove(index);
            this.updateList();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public String getFileContents(int index) {
        BLicenseChannel channel = this.getChannel();
        if (channel != null) {
            try {
                ByteBuffer buffer = new ByteBuffer();
                buffer.readToEnd(channel.read((BFoxFileStore)this.getFile(index).getStore()));
                return new String(buffer.toByteArray());
            }
            catch (Exception buffer) {
                // empty catch block
            }
        }
        try {
            return new String(this.getFile(index).read());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void reload() {
        this.loadValue(this.space);
    }

    public synchronized void loadValue(BFileSpace pSpace) {
        BDirectory dir;
        this.kids.clear();
        this.space = pSpace;
        BIFile[] dirKids = null;
        BLicenseChannel channel = this.getChannel();
        if (channel != null) {
            try {
                if ("license".equals(this.ext)) {
                    dirKids = channel.listlicenses((BFoxFileSpace)this.space);
                } else if ("certificate".equals(this.ext)) {
                    dirKids = channel.listcertificates((BFoxFileSpace)this.space);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dirKids == null && (dir = (BDirectory)this.space.findFile(this.directoryPath)) != null) {
            dirKids = dir.listFiles();
        }
        assert (dirKids != null);
        for (BIFile dirKid : dirKids) {
            if (dirKid.getExtension() == null || !dirKid.getExtension().equals(this.ext)) continue;
            try {
                VendorLicense dbLicense;
                IFileInfo info = PortalLicenseUtil.makeFileInfo((BIFile)dirKid);
                this.kids.add((Object)info);
                if (!(info instanceof LicenseInfo)) continue;
                VendorLicense listLicense = null;
                try {
                    if (channel != null) {
                        InputStream in = channel.read((BFoxFileStore)dirKid.getStore());
                        listLicense = VendorLicense.make((String)dirKid.getFileName(), (InputStream)in);
                    }
                }
                catch (Exception in) {
                    // empty catch block
                }
                if (listLicense == null) {
                    listLicense = VendorLicense.make((BIFile)dirKid);
                }
                if ((dbLicense = LicenseDatabase.LOCAL_INSTANCE.getLicense(listLicense.getHostId(), listLicense.getVendor(), listLicense.getBrandId())) != null && dbLicense.getGenerated() >= listLicense.getGenerated()) continue;
                LicenseDatabase.LOCAL_INSTANCE.add(listLicense);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.updateList();
    }

    public BLicenseChannel getChannel() {
        BLicenseChannel channel = null;
        if (this.space instanceof BFoxFileSpace) {
            BFoxFileSpace foxSpace = (BFoxFileSpace)this.space;
            try {
                Version remoteVersion = (Version)foxSpace.getFoxSession().fw(404, (Object)"platform", (Object)"rt", null, null);
                if (remoteVersion != null && remoteVersion.compareTo(new Version("3.7.201")) != -1) {
                    channel = (BLicenseChannel)foxSpace.getFoxSession().getConnection().getChannels().get("license", BLicenseChannel.TYPE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return channel;
    }
}

