/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.RequestCertificates;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.ui.theme.Theme;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;

public class UiUtil {
    public static final Lexicon lex = Lexicon.make((String)"platform");
    private static RequestCertificates rc = new RequestCertificates();

    public static void requestLicense(BWidgetShell shell, String hostId) {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            BModule portalApiModule = Sys.loadModule((String)"portalApi");
            Class procClass = portalApiModule.loadClass("com.tridium.portal.wb.LicenseProcedure");
            Method method = procClass.getMethod("requestLicense", BWidgetShell.class, String.class);
            method.invoke(null, shell, hostId);
        }
        catch (Exception ex) {
            BDialog.error((BWidget)shell, (String)"Error", (Object)"License request failed.", (Throwable)ex);
        }
    }

    public static BWidget buildUpdateDescription(String headerMsg, IFileInfo[] added, IFileInfo[] updated, IFileInfo[] removed) {
        return UiUtil.buildUpdateDescription(headerMsg, null, added, updated, removed);
    }

    public static BWidget buildUpdateDescription(String headerMsg, String footerMsg, IFileInfo[] added, IFileInfo[] updated, IFileInfo[] removed) {
        return UiUtil.buildUpdateDescription(headerMsg, footerMsg, Arrays.asList(added), Arrays.asList(updated), Arrays.asList(removed));
    }

    public static BWidget buildUpdateDescription(String headerMsg, Collection<IFileInfo> added, Collection<IFileInfo> updated, Collection<IFileInfo> removed) {
        return UiUtil.buildUpdateDescription(headerMsg, null, added, updated, removed);
    }

    public static BWidget buildUpdateDescription(String headerMsg, String footerMsg, Collection<IFileInfo> added, Collection<IFileInfo> updated, Collection<IFileInfo> removed) {
        BLabel label;
        BEdgePane main = new BEdgePane();
        BLabel msg = new BLabel(headerMsg);
        msg.setHalign(BHalign.left);
        main.setTop((BWidget)msg);
        BGridPane list = new BGridPane(1);
        list.setHalign(BHalign.left);
        main.setCenter((BWidget)new BBorderPane((BWidget)list, 4.0, 4.0, 4.0, 0.0));
        if (added != null && added.size() != 0) {
            label = new BLabel(lex.getText("UiUtil.added"));
            label.setFont(Theme.label().getBoldText());
            list.add(null, (BValue)label);
            for (IFileInfo anAdded : added) {
                list.add(null, (BValue)new BBorderPane((BWidget)new BLabel(anAdded.toString()), 0.0, 0.0, 0.0, 10.0));
            }
        }
        if (updated != null && updated.size() != 0) {
            label = new BLabel(lex.getText("UiUtil.updated"));
            label.setFont(Theme.label().getBoldText());
            list.add(null, (BValue)label);
            for (IFileInfo anUpdated : updated) {
                list.add(null, (BValue)new BBorderPane((BWidget)new BLabel(anUpdated.toString()), 0.0, 0.0, 0.0, 10.0));
            }
        }
        if (removed != null && removed.size() != 0) {
            label = new BLabel(lex.getText("UiUtil.removed"));
            label.setFont(Theme.label().getBoldText());
            list.add(null, (BValue)label);
            for (IFileInfo aRemoved : removed) {
                list.add(null, (BValue)new BBorderPane((BWidget)new BLabel(aRemoved.toString()), 0.0, 0.0, 0.0, 10.0));
            }
        }
        if (footerMsg != null) {
            msg = new BLabel(footerMsg);
            msg.setHalign(BHalign.left);
            main.setBottom((BWidget)msg);
        }
        return main;
    }

    public static List<VendorCertificate> getCertificateUpdate(List<VendorCertificate> certificates) {
        return UiUtil.getCertificateUpdate(certificates, new ArrayList<String>());
    }

    public static List<VendorCertificate> getCertificateUpdate(List<VendorCertificate> certificates, List<String> vendorNames) {
        ArrayList<VendorCertificate> certList = new ArrayList<VendorCertificate>();
        try {
            XElem[] certElems;
            HashSet<String> vendors = new HashSet<String>();
            for (VendorCertificate certificate : certificates) {
                vendors.add(certificate.getVendor());
            }
            for (String vendorName : vendorNames) {
                vendors.add(vendorName);
            }
            EntitlementApi.EntitlementStatus es = AccessController.doPrivileged(() -> {
                try {
                    return rc.getCertificatesApi(SubscriptionLicenseUtil.getNreId(), vendors.toArray(new String[0]), rc.getCertificateVersion(), false);
                }
                catch (Exception ignore) {
                    return new EntitlementApi.EntitlementStatus(EntitlementApi.EntitlementState.FAILURE, 200, "Certificate request failed");
                }
            });
            if (!es.isSuccess()) {
                return certList;
            }
            for (XElem elem : certElems = es.getCertificates().elems()) {
                certList.add(VendorCertificate.make((String)"entitlement", (XElem)elem));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return certList;
    }
}

