/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.ui.util.ValidatingTextController;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.text.TextController;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:IpHost"}, requiredPermissions="W")})
@NiagaraActions(value={@NiagaraAction(name="propagateFocusEvent", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="propagateKeyEvent", parameterType="BKeyEvent", defaultValue="new BKeyEvent()", flags=4), @NiagaraAction(name="propagateMouseEvent", parameterType="BMouseEvent", defaultValue="new BMouseEvent()", flags=4)})
public class BIpHostFE
extends BWbFieldEditor {
    @Generated
    public static final Action propagateFocusEvent = BIpHostFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action propagateKeyEvent = BIpHostFE.newAction((int)4, (BValue)new BKeyEvent(), null);
    @Generated
    public static final Action propagateMouseEvent = BIpHostFE.newAction((int)4, (BValue)new BMouseEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIpHostFE.class);
    private boolean isIpv6 = false;
    private final BTextField field;
    private static final String HEX = "0123456789abcdefABCDEF";

    @Generated
    public void propagateFocusEvent(BFocusEvent parameter) {
        this.invoke(propagateFocusEvent, (BValue)parameter, null);
    }

    @Generated
    public void propagateKeyEvent(BKeyEvent parameter) {
        this.invoke(propagateKeyEvent, (BValue)parameter, null);
    }

    @Generated
    public void propagateMouseEvent(BMouseEvent parameter) {
        this.invoke(propagateMouseEvent, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIpHostFE() {
        this(false);
    }

    public BIpHostFE(boolean ipv6Field) {
        this.isIpv6 = ipv6Field;
        this.field = this.isIpv6 ? new BTextField("", 45) : new BTextField("", 15);
        this.field.setController((TextController)(this.isIpv6 ? new Ipv6Controller() : new Controller()));
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.field, (Slot)BTextField.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo("lk3", (BComponent)this.field, (Slot)BTextField.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo("lk4", (BComponent)this.field, (Slot)BTextField.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.field);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BString host = (BString)value;
        this.field.setText(host.toString());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String s = this.field.getText();
        StringBuilder result = new StringBuilder();
        int octetStartIndex = 0;
        if (s.trim().length() == 0) {
            return BString.DEFAULT;
        }
        if (this.isIpv6) {
            int colons = 0;
            int width = 0;
            if (s.indexOf("::") != s.lastIndexOf("::")) {
                throw new CannotSaveException("improper IPv6 address format: ambiguous expansion");
            }
            for (int idx = 0; idx < s.length(); idx = (int)((short)(idx + 1))) {
                char buffer = s.charAt(idx);
                if (buffer == ':') {
                    if (colons >= 7) {
                        throw new CannotSaveException("improper IPv6 address format: too many colons");
                    }
                    if (width > 0) {
                        result.append(Integer.toHexString(Integer.parseInt(s.substring(octetStartIndex, idx), 16)));
                    }
                    result.append(':');
                    width = 0;
                    colons = (short)(colons + 1);
                    continue;
                }
                if (HEX.indexOf(buffer) != -1) {
                    if (width == 0) {
                        octetStartIndex = idx;
                    }
                    if (width >= 4) {
                        throw new CannotSaveException("improper IPv6 address format: exceeded field width");
                    }
                    width = (short)(width + 1);
                    continue;
                }
                throw new CannotSaveException("improper IPv6 address format: illegal character");
            }
            if (width > 0) {
                result.append(Integer.toHexString(Integer.parseInt(s.substring(octetStartIndex), 16)));
            }
            if (colons < 2 || result.indexOf("::") == -1 && colons < 7 || width == 0 && result.lastIndexOf(":") == result.length() - 1 && result.indexOf("::") != result.length() - 2) {
                throw new CannotSaveException("improper IPv6 address format: not enough colons or trailing colon");
            }
        } else {
            int dots = 0;
            int digit = 0;
            int quartetValue = 0;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '.') {
                    if (digit == 0 || dots >= 3) {
                        throw new CannotSaveException("improper IPv4 address format: leading dot, double dot, or too many dots");
                    }
                    result.append(Integer.parseInt(s.substring(octetStartIndex, i)));
                    result.append('.');
                    digit = 0;
                    quartetValue = 0;
                    ++dots;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (digit == 0) {
                        octetStartIndex = i;
                    }
                    if (digit >= 3) {
                        throw new CannotSaveException("improper IPv4 address format: too many digits");
                    }
                    ++digit;
                    if ((quartetValue = quartetValue * 10 + Integer.parseInt(String.valueOf(c))) <= 255) continue;
                    throw new CannotSaveException("improper IPv4 address format: value > 255");
                }
                throw new CannotSaveException("improper IPv4 address format");
            }
            result.append(Integer.parseInt(s.substring(octetStartIndex)));
            if (dots != 3 || digit == 0) {
                throw new CannotSaveException("improper IPv4 address format: too few dots or trailing dot");
            }
        }
        return BString.make((String)result.toString());
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.field.setEditable(value);
    }

    protected void doSetReadonly(boolean readonly) {
        this.setEnabled(!readonly);
    }

    public void doPropagateFocusEvent(BFocusEvent evt) {
        this.fireFocusEvent(new BFocusEvent(evt.getId(), (BWidget)this, evt.isTemporary()));
    }

    public void doPropagateKeyEvent(BKeyEvent evt) {
        this.fireKeyEvent(new BKeyEvent(evt.getId(), (BWidget)this, evt.getModifiersEx(), evt.getKeyCode(), evt.getKeyChar()));
    }

    public void doPropagateMouseEvent(BMouseEvent evt) {
        if (evt instanceof BMouseWheelEvent) {
            this.fireMouseEvent((BMouseEvent)new BMouseWheelEvent(evt.getId(), (BWidget)this, evt.getModifiersEx(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger(), ((BMouseWheelEvent)evt).getWheelRotation()));
        } else {
            this.fireMouseEvent(new BMouseEvent(evt.getId(), (BWidget)this, evt.getModifiersEx(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger()));
        }
    }

    private static class Ipv6Controller
    extends Controller {
        private Ipv6Controller() {
        }

        @Override
        protected boolean valid(String address) {
            if (address.trim().length() == 0) {
                return true;
            }
            int colons = 0;
            int width = 0;
            if (address.indexOf("::") != address.lastIndexOf("::")) {
                return false;
            }
            for (int idx = 0; idx < address.length(); idx = (int)((short)(idx + 1))) {
                char c = address.charAt(idx);
                if (c == ':') {
                    if (colons >= 7) {
                        return false;
                    }
                    width = 0;
                    colons = (short)(colons + 1);
                    continue;
                }
                if (BIpHostFE.HEX.indexOf(c) != -1) {
                    if (width >= 4) {
                        return false;
                    }
                    width = (short)(width + 1);
                    continue;
                }
                return false;
            }
            return true;
        }
    }

    private static class Controller
    extends ValidatingTextController {
        private Controller() {
        }

        protected boolean valid(String address) {
            if (address.trim().length() == 0) {
                return true;
            }
            int dots = 0;
            int digit = 0;
            int quartetValue = 0;
            for (int i = 0; i < address.length(); ++i) {
                char c = address.charAt(i);
                if (c == '.') {
                    if (digit == 0 || dots >= 3) {
                        return false;
                    }
                    digit = 0;
                    quartetValue = 0;
                    ++dots;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (digit >= 3) {
                        return false;
                    }
                    ++digit;
                    if ((quartetValue = quartetValue * 10 + Integer.parseInt(String.valueOf(c))) <= 255) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
    }
}

