/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import javax.baja.sys.BComponent;
import javax.baja.sys.Slot;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;

public class BooleanRadioGroup
extends ToggleCommandGroup<ToggleCommand> {
    private BRadioButton trueButton;
    private BRadioButton falseButton;
    private boolean value;

    public BooleanRadioGroup(BWidget owner, String trueLabel, String falseLabel, boolean initialValue) {
        this(owner, trueLabel, falseLabel);
        this.setValue(initialValue);
    }

    public BooleanRadioGroup(BWidget owner, ToggleCommand trueCommand, ToggleCommand falseCommand) {
        this.trueButton = new BRadioButton(trueCommand, true, false);
        this.add(trueCommand);
        this.falseButton = new BRadioButton(falseCommand, true, false);
        this.add(falseCommand);
    }

    public BooleanRadioGroup(BWidget owner, String trueLabel, String falseLabel) {
        this(owner, new ToggleCommand(owner, trueLabel), new ToggleCommand(owner, falseLabel));
    }

    public void linkAction(BComponent target, Slot targetSlot) {
        target.linkTo(null, (BComponent)this.trueButton, (Slot)BRadioButton.actionPerformed, targetSlot);
        target.linkTo(null, (BComponent)this.falseButton, (Slot)BRadioButton.actionPerformed, targetSlot);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean newValue) {
        if (newValue) {
            this.trueButton.setSelected(true);
        } else {
            this.falseButton.setSelected(true);
        }
    }

    protected void selected(ToggleCommand command) {
        this.value = command == this.trueButton.getCommand();
    }

    public BWidget getTrueWidget() {
        return this.trueButton;
    }

    public BWidget getFalseWidget() {
        return this.falseButton;
    }
}

