/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BCommandDialog;
import java.util.Properties;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.sys.BModule;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class DialogCommand
extends Command {
    private BCommandDialog dialog = null;
    private int result;
    private static String okText;
    private static String cancelText;
    private static String yesText;
    private static String noText;
    private static String closeText;

    public DialogCommand(BWidget owner, int result, BModule module, String keyBase) {
        super(owner, module, keyBase);
        this.result = result;
    }

    public DialogCommand(BWidget owner, int result, Lexicon lexicon, String keyBase) {
        super(owner, lexicon, keyBase);
        this.result = result;
    }

    public DialogCommand(BWidget owner, int result, Properties props, String keyBase) {
        super(owner, props, keyBase);
        this.result = result;
    }

    public DialogCommand(BWidget owner, int result, String label, BImage icon, BAccelerator acc, String description) {
        super(owner, label, icon, acc, description);
        this.result = result;
    }

    public DialogCommand(BWidget owner, int result, String label) {
        super(owner, label);
        this.result = result;
    }

    public static DialogCommand makeOk(BWidget owner) {
        DialogCommand.initButtonText();
        return new DialogCommand(owner, 1, okText);
    }

    public static DialogCommand makeClose(BWidget owner) {
        DialogCommand.initButtonText();
        return new DialogCommand(owner, 16, closeText);
    }

    public static DialogCommand makeCancel(BWidget owner) {
        DialogCommand.initButtonText();
        return new DialogCommand(owner, 2, cancelText);
    }

    public static DialogCommand makeYes(BWidget owner) {
        DialogCommand.initButtonText();
        return new DialogCommand(owner, 4, yesText);
    }

    public static DialogCommand makeNo(BWidget owner) {
        DialogCommand.initButtonText();
        return new DialogCommand(owner, 8, noText);
    }

    public static DialogCommand[] make(BWidget owner, int buttons) {
        Array result = new Array(DialogCommand.class);
        if ((buttons & 1) > 0) {
            result.add((Object)DialogCommand.makeOk(owner));
        }
        if ((buttons & 2) > 0) {
            result.add((Object)DialogCommand.makeCancel(owner));
        }
        if ((buttons & 4) > 0) {
            result.add((Object)DialogCommand.makeYes(owner));
        }
        if ((buttons & 8) > 0) {
            result.add((Object)DialogCommand.makeNo(owner));
        }
        if ((buttons & 0x10) > 0) {
            result.add((Object)DialogCommand.makeClose(owner));
        }
        return (DialogCommand[])result.trim();
    }

    public void setDialog(BCommandDialog value) {
        this.dialog = value;
    }

    public BCommandDialog getDialog() {
        return this.dialog;
    }

    public CommandArtifact doInvoke() throws Exception {
        if (this.dialog != null) {
            this.dialog.close(this);
        }
        return null;
    }

    public int getResult() {
        return this.result;
    }

    private static void initButtonText() {
        if (okText != null) {
            return;
        }
        okText = UiLexicon.bajaui().getText("dialog.ok");
        cancelText = UiLexicon.bajaui().getText("dialog.cancel");
        yesText = UiLexicon.bajaui().getText("dialog.yes");
        noText = UiLexicon.bajaui().getText("dialog.no");
        closeText = Lexicon.make((String)"platform").getText("dialog.close");
    }
}

