/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.ui.options.BOptions;
import javax.baja.util.BFolder;

public class FavoriteDirectory {
    public static BDirectory loadByPath(String optionsKey, String optionName, FilePath defaultPath) {
        BDirectory result = null;
        try {
            BValue path;
            BOptions options = BOptions.load((String)optionsKey, (Type)BOptions.TYPE);
            BValue optionValue = options.get(optionName);
            if (optionValue != null && optionValue instanceof BComponent && (path = ((BComponent)optionValue).get("path")) != null && path instanceof BString) {
                result = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath(path.toString()));
            }
            if (result == null || !result.isDirectory()) {
                if (defaultPath == null) {
                    return null;
                }
                result = BFileSystem.INSTANCE.makeDir(defaultPath, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (defaultPath == null) {
                    return null;
                }
                result = BFileSystem.INSTANCE.makeDir(defaultPath, null);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable t) {
                throw new BajaRuntimeException(t);
            }
        }
        return result;
    }

    public static void savePath(String optionsKey, String optionName, BDirectory dir) {
        if (dir != null) {
            FavoriteDirectory.savePath(optionsKey, optionName, dir.getFilePath());
        }
    }

    public static void savePath(String optionsKey, String optionName, FilePath dirPath) {
        try {
            BOptions options = BOptions.load((String)optionsKey, (Type)BOptions.TYPE);
            BValue optionValue = options.get(optionName);
            if (optionValue != null && optionValue instanceof BComponent) {
                BComponent c = (BComponent)optionValue;
                Property p = c.getProperty("path");
                if (p == null) {
                    c.add("path", (BValue)BString.make((String)dirPath.getBody()));
                } else {
                    c.set(p, (BValue)BString.make((String)dirPath.getBody()));
                }
            } else {
                BFolder c = new BFolder();
                c.add("path", (BValue)BString.make((String)dirPath.getBody()));
                if (optionValue == null) {
                    options.add(optionName, (BValue)c);
                } else {
                    options.set(optionName, (BValue)c);
                }
            }
            options.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BOrd loadByOrd(String optionsKey, String optionName, FilePath defaultPath) {
        if (defaultPath == null) {
            return FavoriteDirectory.loadByOrd(optionsKey, optionName, (BOrd)null);
        }
        return FavoriteDirectory.loadByOrd(optionsKey, optionName, BOrd.make((OrdQuery)defaultPath));
    }

    public static BOrd loadByOrd(String optionsKey, String optionName, BOrd defaultOrd) {
        BOrd result = defaultOrd;
        try {
            BValue value;
            BOptions options = BOptions.load((String)optionsKey, (Type)BOptions.TYPE);
            BValue optionValue = options.get(optionName);
            if (optionValue != null && optionValue instanceof BComponent && (value = ((BComponent)optionValue).get("ord")) != null && value instanceof BOrd) {
                result = (BOrd)value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            try {
                OrdQuery[] queries = result.parse();
                if (queries.length == 1 && queries[0] instanceof FilePath || queries.length == 2 && queries[0].getScheme().equals("local") && queries[1] instanceof FilePath) {
                    BFileSystem.INSTANCE.makeDir((FilePath)queries[queries.length - 1], null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void saveOrd(String optionsKey, String optionName, BDirectory dir) {
        if (dir != null) {
            FavoriteDirectory.saveOrd(optionsKey, optionName, dir.getNavOrd());
        }
    }

    public static void saveOrd(String optionsKey, String optionName, BOrd ord) {
        if (ord == null) {
            return;
        }
        try {
            BOptions options = BOptions.load((String)optionsKey, (Type)BOptions.TYPE);
            BValue optionValue = options.get(optionName);
            if (optionValue != null && optionValue instanceof BComponent) {
                BComponent c = (BComponent)optionValue;
                Property p = c.getProperty("ord");
                if (p == null) {
                    c.add("ord", (BValue)ord);
                } else {
                    c.set(p, (BValue)ord);
                }
            } else {
                BFolder c = new BFolder();
                c.add("ord", (BValue)ord);
                if (optionValue == null) {
                    options.add(optionName, (BValue)c);
                } else {
                    options.set(optionName, (BValue)c);
                }
            }
            options.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

