/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import javax.baja.ui.text.Line;
import javax.baja.ui.text.TextModel;

public class LimitedTextModel
extends TextModel {
    private int maxLines;
    private static int MAX_LINES_DEFAULT = 500;

    public LimitedTextModel() {
        this(MAX_LINES_DEFAULT);
    }

    public LimitedTextModel(int maxLines) {
        this.setMaxLines(maxLines);
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    protected void update(Line[] lines) {
        if (lines.length <= this.getMaxLines()) {
            super.update(lines);
        } else {
            Line[] trunc = new Line[this.getMaxLines()];
            System.arraycopy(lines, lines.length - this.getMaxLines(), trunc, 0, this.getMaxLines());
            super.update(trunc);
        }
    }
}

