/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortableTableUtil {

    private static class ColumnComparator
    implements Comparator<SortableRow> {
        private int comparatorSortColumn;
        private boolean comparatorAscending;

        public ColumnComparator(int comparatorSortColumn, boolean comparatorAscending) {
            this.comparatorSortColumn = comparatorSortColumn;
            this.comparatorAscending = comparatorAscending;
        }

        @Override
        public int compare(SortableRow row1, SortableRow row2) {
            int sortDirection = this.comparatorAscending ? 1 : -1;
            return sortDirection * row1.compareToRowForColumn(row2, this.comparatorSortColumn);
        }
    }

    public static class OriginalOrderComparator
    implements Comparator<SortableRow> {
        Map<Object, Integer> sequenceMapById = new HashMap<Object, Integer>();

        public OriginalOrderComparator(Model model) {
            if (model != null) {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    this.sequenceMapById.put(model.getSortableRow(i).getRowId(), i);
                }
            }
        }

        @Override
        public int compare(SortableRow r1, SortableRow r2) {
            Integer s1 = this.sequenceMapById.get(r1.getRowId());
            Integer s2 = this.sequenceMapById.get(r2.getRowId());
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    public static class RowComparator
    implements Comparator<SortableRow> {
        private List<Comparator<SortableRow>> comparators;

        public RowComparator(Model model, Comparator<SortableRow> defaultComparison) {
            int offset;
            int[] sortColumns = new int[model.getColumnCount()];
            sortColumns[0] = model.getSortColumn();
            int next = 1;
            for (int i = 0; i < sortColumns.length; ++i) {
                if (i == model.getSortColumn()) continue;
                sortColumns[next++] = i;
            }
            if (defaultComparison == null) {
                this.comparators = new ArrayList<Comparator<SortableRow>>();
                offset = 0;
            } else {
                this.comparators = new ArrayList<Comparator<SortableRow>>();
                this.comparators.add(defaultComparison);
                offset = 1;
            }
            for (int i = offset; i < this.comparators.size(); ++i) {
                this.comparators.add(i, new ColumnComparator(sortColumns[i - offset], model.isSortAscending()));
            }
        }

        @Override
        public int compare(SortableRow o1, SortableRow o2) {
            int result = 0;
            for (int i = 0; i < this.comparators.size() && result == 0; ++i) {
                result = this.comparators.get(i).compare(o1, o2);
            }
            return result;
        }
    }

    public static interface SortableRow {
        public Object getRowId();

        public int compareToRowForColumn(SortableRow var1, int var2);
    }

    public static interface Model {
        public int getColumnCount();

        public int getRowCount();

        public SortableRow getSortableRow(int var1);

        public void sortByColumn(int var1, boolean var2);

        public int getSortColumn();

        public boolean isSortAscending();
    }
}

